/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.config.job;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Arrays;
import org.janusgraph.hadoop.compat.HadoopCompatLoader;
import org.janusgraph.hadoop.config.job.JobClasspathConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobClasspathConfigurers {
    private static final Logger log = LoggerFactory.getLogger(JobClasspathConfigurers.class);
    private static final ImmutableList<String> POSSIBLE_MAPRED_JAR_DIRS;

    public static JobClasspathConfigurer get(String configuredMapReduceJar, String defaultMapReduceJar) {
        if (null != configuredMapReduceJar) {
            log.info("Using configuration's mapred job jar: {}", (Object)configuredMapReduceJar);
            return HadoopCompatLoader.DEFAULT_COMPAT.newMapredJarConfigurer(configuredMapReduceJar);
        }
        for (String dir : POSSIBLE_MAPRED_JAR_DIRS) {
            String candidate = dir + File.separator + defaultMapReduceJar;
            if (!new File(candidate).exists()) continue;
            log.info("Using mapred job jar found in {}: {}", (Object)dir, (Object)candidate);
            return HadoopCompatLoader.DEFAULT_COMPAT.newMapredJarConfigurer(candidate);
        }
        log.info("Uploading jars on classpath DistributedCache in lieu of a mapred job jar");
        return HadoopCompatLoader.DEFAULT_COMPAT.newDistCacheConfigurer();
    }

    static {
        ImmutableList.Builder b = ImmutableList.builder();
        for (String prefix : Arrays.asList("", ".." + File.separator)) {
            for (String dir : Arrays.asList("target", "lib")) {
                b.add((Object)(prefix + dir));
            }
        }
        POSSIBLE_MAPRED_JAR_DIRS = b.build();
    }
}

