/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
@Deprecated
public class CqlBridgeRecordReader
extends RecordReader<StaticBuffer, Iterable<Entry>> {
    private static final Logger log = LoggerFactory.getLogger(CqlBridgeRecordReader.class);
    private ColumnFamilySplit split;
    private DistinctKeyIterator distinctKeyIterator;
    private int totalRowCount;
    private String keyspace;
    private String cfName;
    private String cqlQuery;
    private Cluster cluster;
    private Session session;
    private IPartitioner partitioner;
    private String inputColumns;
    private String userDefinedWhereClauses;
    private final List<String> partitionKeys = new ArrayList<String>();
    private final LinkedHashMap<String, Boolean> partitionBoundColumns = Maps.newLinkedHashMap();
    private int nativeProtocolVersion = 1;
    private KV currentKV;

    CqlBridgeRecordReader() {
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.split = (ColumnFamilySplit)split;
        Configuration conf = HadoopCompat.getConfiguration((JobContext)context);
        this.totalRowCount = this.split.getLength() < Long.MAX_VALUE ? (int)this.split.getLength() : ConfigHelper.getInputSplitSize((Configuration)conf);
        this.cfName = ConfigHelper.getInputColumnFamily((Configuration)conf);
        this.keyspace = ConfigHelper.getInputKeyspace((Configuration)conf);
        this.partitioner = ConfigHelper.getInputPartitioner((Configuration)conf);
        this.inputColumns = CqlConfigHelper.getInputcolumns((Configuration)conf);
        this.userDefinedWhereClauses = CqlConfigHelper.getInputWhereClauses((Configuration)conf);
        try {
            if (this.cluster != null) {
                return;
            }
            String[] locations = split.getLocations();
            this.cluster = Cluster.builder().addContactPoints(locations).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create cluster for table: " + this.cfName + ", in keyspace: " + this.keyspace, e);
        }
        this.session = this.cluster.connect(this.quote(this.keyspace));
        Preconditions.checkNotNull((Object)this.session, (Object)"Can't create connection session");
        this.nativeProtocolVersion = this.cluster.getConfiguration().getProtocolOptions().getProtocolVersion().toInt();
        this.cqlQuery = CqlConfigHelper.getInputCql((Configuration)conf);
        if (StringUtils.isNotEmpty((CharSequence)this.cqlQuery) && (StringUtils.isNotEmpty((CharSequence)this.inputColumns) || StringUtils.isNotEmpty((CharSequence)this.userDefinedWhereClauses))) {
            throw new AssertionError((Object)"Cannot define a custom query with input columns and / or where clauses");
        }
        if (StringUtils.isEmpty((CharSequence)this.cqlQuery)) {
            this.cqlQuery = this.buildQuery();
        }
        log.trace("cqlQuery {}", (Object)this.cqlQuery);
        this.distinctKeyIterator = new DistinctKeyIterator();
        log.trace("created {}", (Object)this.distinctKeyIterator);
    }

    public void close() {
        if (this.session != null) {
            this.session.close();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
    }

    public StaticBuffer getCurrentKey() {
        return this.currentKV.key;
    }

    public Iterable<Entry> getCurrentValue() throws IOException {
        return this.currentKV.entries;
    }

    public float getProgress() {
        if (!this.distinctKeyIterator.hasNext()) {
            return 1.0f;
        }
        float progress = (float)this.distinctKeyIterator.totalRead / (float)this.totalRowCount;
        return progress > 1.0f ? 1.0f : progress;
    }

    public boolean nextKeyValue() throws IOException {
        Object kv = this.distinctKeyIterator.next();
        if (kv == null) {
            return false;
        }
        Map.Entry onlyEntry = (Map.Entry)Iterables.getOnlyElement(kv.entrySet());
        KV newKV = new KV((StaticArrayBuffer)onlyEntry.getKey());
        Map v = (Map)onlyEntry.getValue();
        List<Entry> entries = v.keySet().stream().map(column -> StaticArrayEntry.of((StaticBuffer)column, (StaticBuffer)((StaticBuffer)v.get(column)))).collect(Collectors.toList());
        newKV.addEntries(entries);
        this.currentKV = newKV;
        return true;
    }

    public int getNativeProtocolVersion() {
        return this.nativeProtocolVersion;
    }

    private String buildQuery() {
        this.fetchKeys();
        List<String> columns = this.getSelectColumns();
        String selectColumnList = columns.size() == 0 ? "*" : this.makeColumnList(columns);
        String partitionKeyList = this.makeColumnList(this.partitionKeys);
        return String.format("SELECT %s FROM %s.%s WHERE token(%s)>? AND token(%s)<=?" + this.getAdditionalWhereClauses(), selectColumnList, this.quote(this.keyspace), this.quote(this.cfName), partitionKeyList, partitionKeyList);
    }

    private String getAdditionalWhereClauses() {
        String whereClause = "";
        if (StringUtils.isNotEmpty((CharSequence)this.userDefinedWhereClauses)) {
            whereClause = whereClause + " AND " + this.userDefinedWhereClauses;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.userDefinedWhereClauses)) {
            whereClause = whereClause + " ALLOW FILTERING";
        }
        return whereClause;
    }

    private List<String> getSelectColumns() {
        ArrayList<String> selectColumns = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)this.inputColumns)) {
            selectColumns.addAll(this.partitionKeys);
            for (String column : Splitter.on((char)',').split((CharSequence)this.inputColumns)) {
                if (this.partitionKeys.contains(column)) continue;
                selectColumns.add(column);
            }
        }
        return selectColumns;
    }

    private String makeColumnList(Collection<String> columns) {
        return columns.stream().map(this::quote).collect(Collectors.joining(","));
    }

    private void fetchKeys() {
        TableMetadata tableMetadata = this.session.getCluster().getMetadata().getKeyspace(Metadata.quote((String)this.keyspace)).getTable(Metadata.quote((String)this.cfName));
        if (tableMetadata == null) {
            throw new RuntimeException("No table metadata found for " + this.keyspace + "." + this.cfName);
        }
        for (ColumnMetadata partitionKey : tableMetadata.getPartitionKey()) {
            this.partitionKeys.add(partitionKey.getName());
        }
    }

    private String quote(String identifier) {
        return "\"" + identifier.replaceAll("\"", "\"\"") + "\"";
    }

    private class DistinctKeyIterator
    implements Iterator<Map<StaticArrayBuffer, Map<StaticBuffer, StaticBuffer>>> {
        public static final String KEY = "key";
        public static final String COLUMN_NAME = "column1";
        public static final String VALUE = "value";
        private final Iterator<Row> rowIterator;
        long totalRead;
        Row previousRow = null;

        DistinctKeyIterator() {
            AbstractType type = CqlBridgeRecordReader.this.partitioner.getTokenValidator();
            Object startToken = type.compose(type.fromString(CqlBridgeRecordReader.this.split.getStartToken()));
            Object endToken = type.compose(type.fromString(CqlBridgeRecordReader.this.split.getEndToken()));
            SimpleStatement statement = new SimpleStatement(CqlBridgeRecordReader.this.cqlQuery, new Object[]{startToken, endToken});
            this.rowIterator = CqlBridgeRecordReader.this.session.execute((Statement)statement).iterator();
            for (ColumnMetadata meta : CqlBridgeRecordReader.this.cluster.getMetadata().getKeyspace(CqlBridgeRecordReader.this.quote(CqlBridgeRecordReader.this.keyspace)).getTable(CqlBridgeRecordReader.this.quote(CqlBridgeRecordReader.this.cfName)).getPartitionKey()) {
                CqlBridgeRecordReader.this.partitionBoundColumns.put(meta.getName(), Boolean.TRUE);
            }
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext();
        }

        @Override
        public Map<StaticArrayBuffer, Map<StaticBuffer, StaticBuffer>> next() {
            if (!this.rowIterator.hasNext()) {
                return null;
            }
            HashMap<StaticArrayBuffer, Map<StaticBuffer, StaticBuffer>> keyColumnValues = new HashMap<StaticArrayBuffer, Map<StaticBuffer, StaticBuffer>>();
            Row row = this.previousRow == null ? this.rowIterator.next() : this.previousRow;
            StaticArrayBuffer key = StaticArrayBuffer.of((ByteBuffer)row.getBytesUnsafe(KEY));
            StaticArrayBuffer column1 = StaticArrayBuffer.of((ByteBuffer)row.getBytesUnsafe(COLUMN_NAME));
            StaticArrayBuffer value = StaticArrayBuffer.of((ByteBuffer)row.getBytesUnsafe(VALUE));
            HashMap<StaticArrayBuffer, StaticArrayBuffer> cvs = new HashMap<StaticArrayBuffer, StaticArrayBuffer>();
            cvs.put(column1, value);
            keyColumnValues.put(key, cvs);
            while (this.rowIterator.hasNext()) {
                Row nextRow = this.rowIterator.next();
                StaticArrayBuffer nextKey = StaticArrayBuffer.of((ByteBuffer)nextRow.getBytesUnsafe(KEY));
                if (!key.equals((Object)nextKey)) {
                    this.previousRow = nextRow;
                    break;
                }
                StaticArrayBuffer nextColumn = StaticArrayBuffer.of((ByteBuffer)nextRow.getBytesUnsafe(COLUMN_NAME));
                StaticArrayBuffer nextValue = StaticArrayBuffer.of((ByteBuffer)nextRow.getBytesUnsafe(VALUE));
                cvs.put(nextColumn, nextValue);
                ++this.totalRead;
            }
            return keyColumnValues;
        }
    }

    private static class KV {
        private final StaticArrayBuffer key;
        private ArrayList<Entry> entries;

        KV(StaticArrayBuffer key) {
            this.key = key;
        }

        void addEntries(Collection<Entry> toAdd) {
            if (this.entries == null) {
                this.entries = new ArrayList(toAdd.size());
            }
            this.entries.addAll(toAdd);
        }
    }
}

