/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.GraphFilterAware;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.hadoop.formats.util.HadoopRecordReader;
import org.janusgraph.hadoop.formats.util.JanusGraphVertexDeserializer;
import org.janusgraph.hadoop.formats.util.input.JanusGraphHadoopSetup;
import org.janusgraph.util.system.ConfigurationUtil;

public abstract class HadoopInputFormat
extends InputFormat<NullWritable, VertexWritable>
implements Configurable,
GraphFilterAware {
    private final InputFormat<StaticBuffer, Iterable<Entry>> inputFormat;
    private static final RefCountedCloseable<JanusGraphVertexDeserializer> refCounter = new RefCountedCloseable<JanusGraphVertexDeserializer>(conf -> {
        String janusgraphVersion = "current";
        String className = "org.janusgraph.hadoop.formats.util.input.current.JanusGraphHadoopSetupImpl";
        JanusGraphHadoopSetup ts = (JanusGraphHadoopSetup)ConfigurationUtil.instantiate((String)className, (Object[])new Object[]{conf}, (Class[])new Class[]{Configuration.class});
        return new JanusGraphVertexDeserializer(ts);
    });

    public HadoopInputFormat(InputFormat<StaticBuffer, Iterable<Entry>> inputFormat) {
        this.inputFormat = inputFormat;
        Preconditions.checkState((boolean)Configurable.class.isAssignableFrom(inputFormat.getClass()));
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        return this.inputFormat.getSplits(context);
    }

    public RecordReader<NullWritable, VertexWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new HadoopRecordReader(refCounter, (RecordReader<StaticBuffer, Iterable<Entry>>)this.inputFormat.createRecordReader(split, context));
    }

    public void setConf(Configuration conf) {
        ((Configurable)this.inputFormat).setConf(conf);
        refCounter.setBuilderConfiguration(conf);
    }

    public Configuration getConf() {
        return ((Configurable)this.inputFormat).getConf();
    }

    public void setGraphFilter(GraphFilter graphFilter) {
    }

    public static class RefCountedCloseable<T extends AutoCloseable> {
        private T current;
        private long refCount;
        private final Function<Configuration, T> builder;
        private Configuration configuration;

        public RefCountedCloseable(Function<Configuration, T> builder) {
            this.builder = builder;
        }

        public synchronized void setBuilderConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        public synchronized T acquire() {
            if (null == this.current) {
                Preconditions.checkState((0L == this.refCount ? 1 : 0) != 0);
                this.current = (AutoCloseable)this.builder.apply(this.configuration);
            }
            ++this.refCount;
            return this.current;
        }

        public synchronized void release() throws Exception {
            Preconditions.checkNotNull(this.current);
            Preconditions.checkState((0L < this.refCount ? 1 : 0) != 0);
            --this.refCount;
            if (0L == this.refCount) {
                this.current.close();
                this.current = null;
            }
        }
    }
}

