/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.spark.serializer.KryoRegistrator;
import org.janusgraph.core.attribute.Geoshape;

public class JanusGraphKryoRegistrator
implements KryoRegistrator {
    public void registerClasses(Kryo kryo) {
        kryo.register(Geoshape.class, (Serializer)new GeoShapeKryoSerializer());
    }

    public static class GeoShapeKryoSerializer
    extends Serializer<Geoshape> {
        public void write(Kryo kryo, Output output, Geoshape geoshape) {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                Geoshape.GeoshapeBinarySerializer.write((OutputStream)outputStream, (Geoshape)geoshape);
                byte[] bytes = outputStream.toByteArray();
                output.write(bytes.length);
                output.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O exception writing geoshape");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Geoshape read(Kryo kryo, Input input, Class<Geoshape> aClass) {
            int length = input.read();
            Preconditions.checkArgument((length > 0 ? 1 : 0) != 0);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(input.readBytes(length));){
                Geoshape geoshape = Geoshape.GeoshapeBinarySerializer.read((InputStream)inputStream);
                return geoshape;
            }
            catch (IOException e) {
                throw new RuntimeException("I/O exception reading geoshape");
            }
        }
    }
}

