/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.graphdb.olap.job.IndexRemoveJob;
import org.janusgraph.graphdb.olap.job.IndexRepairJob;
import org.janusgraph.hadoop.MapReduceIndexJobs;
import org.janusgraph.hadoop.scan.HBaseHadoopScanRunner;
import org.janusgraph.util.system.IOUtils;

public class HBaseMapReduceIndexJobsUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanMetrics repair(String janusgraphPropertiesPath, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        ScanMetrics scanMetrics;
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(janusgraphPropertiesPath);
            p.load(fis);
            scanMetrics = HBaseMapReduceIndexJobsUtils.repair(p, indexName, relationType);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fis);
        return scanMetrics;
    }

    public static ScanMetrics repair(Properties janusgraphProperties, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        return HBaseMapReduceIndexJobsUtils.repair(janusgraphProperties, indexName, relationType, new org.apache.hadoop.conf.Configuration());
    }

    public static ScanMetrics repair(Properties janusgraphProperties, String indexName, String relationType, org.apache.hadoop.conf.Configuration hadoopBaseConf) throws InterruptedException, IOException, ClassNotFoundException {
        IndexRepairJob job = new IndexRepairJob();
        HBaseHadoopScanRunner cr = new HBaseHadoopScanRunner((VertexScanJob)job);
        return HBaseMapReduceIndexJobsUtils.executeScanRunner(janusgraphProperties, indexName, relationType, hadoopBaseConf, cr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanMetrics remove(String janusgraphPropertiesPath, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        ScanMetrics scanMetrics;
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(janusgraphPropertiesPath);
            p.load(fis);
            scanMetrics = HBaseMapReduceIndexJobsUtils.remove(p, indexName, relationType);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fis);
        return scanMetrics;
    }

    public static ScanMetrics remove(Properties janusgraphProperties, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        return HBaseMapReduceIndexJobsUtils.remove(janusgraphProperties, indexName, relationType, new org.apache.hadoop.conf.Configuration());
    }

    public static ScanMetrics remove(Properties janusgraphProperties, String indexName, String relationType, org.apache.hadoop.conf.Configuration hadoopBaseConf) throws InterruptedException, IOException, ClassNotFoundException {
        IndexRemoveJob job = new IndexRemoveJob();
        HBaseHadoopScanRunner cr = new HBaseHadoopScanRunner((ScanJob)job);
        return HBaseMapReduceIndexJobsUtils.executeScanRunner(janusgraphProperties, indexName, relationType, hadoopBaseConf, cr);
    }

    private static ScanMetrics executeScanRunner(Properties janusgraphProperties, String indexName, String relationType, org.apache.hadoop.conf.Configuration hadoopBaseConf, HBaseHadoopScanRunner cr) throws InterruptedException, IOException, ClassNotFoundException {
        ModifiableConfiguration mc = MapReduceIndexJobs.getIndexJobConf((String)indexName, (String)relationType);
        MapReduceIndexJobs.copyPropertiesToInputAndOutputConf((org.apache.hadoop.conf.Configuration)hadoopBaseConf, (Properties)janusgraphProperties);
        cr.scanJobConf((Configuration)mc);
        cr.scanJobConfRoot(GraphDatabaseConfiguration.class.getName() + "#JOB_NS");
        cr.baseHadoopConf(hadoopBaseConf);
        return cr.run();
    }
}

