/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.scan;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.formats.hbase.HBaseBinaryInputFormat;
import org.janusgraph.hadoop.scan.AbstractHadoopScanRunner;
import org.janusgraph.hadoop.scan.HadoopScanRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseHadoopScanRunner
extends AbstractHadoopScanRunner<HBaseHadoopScanRunner> {
    private static final Logger log = LoggerFactory.getLogger(HBaseHadoopScanRunner.class);

    public HBaseHadoopScanRunner(ScanJob scanJob) {
        super(scanJob);
    }

    public HBaseHadoopScanRunner(VertexScanJob vertexScanJob) {
        super(vertexScanJob);
    }

    protected HBaseHadoopScanRunner self() {
        return this;
    }

    public ScanMetrics run() throws InterruptedException, IOException, ClassNotFoundException {
        org.apache.hadoop.conf.Configuration hadoopConf;
        org.apache.hadoop.conf.Configuration configuration = hadoopConf = null != this.baseHadoopConf ? this.baseHadoopConf : new org.apache.hadoop.conf.Configuration();
        if (null != this.janusgraphConf) {
            String prefix = ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".";
            for (String k : this.janusgraphConf.getKeys("")) {
                hadoopConf.set(prefix + k, this.janusgraphConf.get(k, Object.class).toString());
                log.debug("Set: {}={}", (Object)(prefix + k), (Object)this.janusgraphConf.get(k, Object.class).toString());
            }
        }
        Preconditions.checkNotNull((Object)hadoopConf);
        if (null != this.scanJob) {
            return HadoopScanRunner.runScanJob((ScanJob)this.scanJob, (Configuration)this.scanJobConf, (String)this.scanJobConfRoot, (org.apache.hadoop.conf.Configuration)hadoopConf, HBaseBinaryInputFormat.class);
        }
        return HadoopScanRunner.runVertexScanJob((VertexScanJob)this.vertexScanJob, (Configuration)this.scanJobConf, (String)this.scanJobConfRoot, (org.apache.hadoop.conf.Configuration)hadoopConf, HBaseBinaryInputFormat.class);
    }
}

