/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.inmemory;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.inmemory.BufferPageUtils;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;

class BufferPage {
    public static final int[] EMPTY_INDEX = new int[0];
    public static final byte[] EMPTY_DATA = new byte[0];
    private int[] offsetIndex;
    private byte[] rawData;

    BufferPage(int[] indices, byte[] data) {
        this.offsetIndex = indices;
        this.rawData = data;
    }

    protected int[] getOffsetIndex() {
        return this.offsetIndex;
    }

    protected byte[] getRawData() {
        return this.rawData;
    }

    protected void setRawData(byte[] rawData) {
        this.rawData = rawData;
    }

    protected void setOffsetIndex(int[] offsetIndex) {
        this.offsetIndex = offsetIndex;
    }

    public boolean isEmpty() {
        return this.offsetIndex.length == 0;
    }

    public int getIndex(StaticBuffer column) {
        int low = 0;
        int high = this.offsetIndex.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Preconditions.checkArgument((boolean)(column instanceof StaticArrayBuffer));
            int compare = -((StaticArrayBuffer)column).compareTo(this.rawData, this.offsetIndex[mid] + 1, this.offsetIndex[mid] + 1 + this.rawData[this.offsetIndex[mid]]);
            if (compare < 0) {
                low = mid + 1;
                continue;
            }
            if (compare > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private int getEntryLength(int index) {
        if (index < this.offsetIndex.length - 1) {
            return this.offsetIndex[index + 1] - this.offsetIndex[index];
        }
        return this.rawData.length - this.offsetIndex[index];
    }

    private int getEntryEndOffset(int index) {
        if (index < this.offsetIndex.length - 1) {
            return this.offsetIndex[index + 1];
        }
        return this.rawData.length;
    }

    public Entry get(int index) {
        int entryBufLen = this.getEntryLength(index);
        ByteBuffer entryBuffer = ByteBuffer.wrap(this.rawData, this.offsetIndex[index], entryBufLen);
        byte valPos = entryBuffer.get();
        byte[] col = new byte[valPos];
        entryBuffer.get(col);
        byte[] val = new byte[entryBufLen - valPos - 1];
        entryBuffer.get(val);
        return StaticArrayEntry.of((StaticBuffer)StaticArrayBuffer.of((byte[])col), (StaticBuffer)StaticArrayBuffer.of((byte[])val));
    }

    public Entry getNoCopy(int index) {
        return new StaticArrayEntry(this.rawData, this.offsetIndex[index] + 1, this.getEntryEndOffset(index), (int)this.rawData[this.offsetIndex[index]]);
    }

    public int numEntries() {
        return this.offsetIndex.length;
    }

    public int byteSize() {
        return this.rawData.length + this.offsetIndex.length * 4 + 16;
    }

    public static List<BufferPage> merge(List<BufferPage> pagesToMerge, int maxPageSize) {
        int n;
        int i;
        if (pagesToMerge == null || pagesToMerge.size() < 1) {
            return pagesToMerge;
        }
        int totalCount = 0;
        for (BufferPage bufferPage : pagesToMerge) {
            totalCount += bufferPage.numEntries();
        }
        Entry[] newdata = new Entry[totalCount];
        totalCount = 0;
        for (BufferPage p : pagesToMerge) {
            for (i = 0; i < p.numEntries(); ++i) {
                newdata[totalCount++] = p.getNoCopy(i);
            }
        }
        int n2 = newdata.length / maxPageSize;
        if (newdata.length % maxPageSize > 0) {
            ++n;
        }
        ArrayList<BufferPage> newPages = new ArrayList<BufferPage>(n);
        for (i = 0; i < n; ++i) {
            newPages.add(BufferPageUtils.buildFromEntryArray(newdata, i * maxPageSize, Math.min(newdata.length, (i + 1) * maxPageSize)));
        }
        return newPages;
    }

    public List<BufferPage> merge(Entry[] add, int iaddp, int addLimit, Entry[] del, int idelp, int delLimit, int maxPageSize) {
        int iadd = iaddp;
        int idel = idelp;
        Entry[] newdata = new Entry[this.numEntries() + addLimit - iadd];
        int i = 0;
        int iold = 0;
        while (iold < this.numEntries()) {
            int compare;
            Entry e = this.getNoCopy(iold);
            ++iold;
            if (iadd < addLimit) {
                compare = e.compareTo((Object)add[iadd]);
                if (compare >= 0) {
                    e = add[iadd];
                    ++iadd;
                    while (iadd < addLimit && e.equals(add[iadd])) {
                        ++iadd;
                    }
                }
                if (compare > 0) {
                    --iold;
                }
            }
            if (idel < delLimit) {
                compare = e.compareTo((Object)del[idel]);
                if (compare == 0) {
                    e = null;
                }
                if (compare >= 0) {
                    ++idel;
                }
            }
            if (e == null) continue;
            newdata[i] = e;
            ++i;
        }
        while (iadd < addLimit) {
            newdata[i] = add[iadd];
            ++i;
            ++iadd;
        }
        int newDataEnd = i;
        int numNewPages = newDataEnd / maxPageSize;
        if (newDataEnd % maxPageSize > 0) {
            ++numNewPages;
        }
        ArrayList<BufferPage> newPages = new ArrayList<BufferPage>(numNewPages);
        for (i = 0; i < numNewPages; ++i) {
            newPages.add(BufferPageUtils.buildFromEntryArray(newdata, i * maxPageSize, Math.min(newDataEnd, (i + 1) * maxPageSize)));
        }
        return newPages;
    }
}

