/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.inmemory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.inmemory.InMemoryColumnValueStore;
import org.janusgraph.diskstorage.inmemory.InMemoryKeyColumnValueStoreFragmentationReport;
import org.janusgraph.diskstorage.inmemory.SharedEntryBufferFragmentationReport;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryKeyColumnValueStore
implements KeyColumnValueStore {
    private static final boolean USE_COMPRESSION = true;
    private static final int READ_BUFFER_SIZE = 0x800000;
    private static final int WRITE_BUFFER_SIZE = 0x800000;
    private static final Logger log = LoggerFactory.getLogger(InMemoryKeyColumnValueStore.class);
    private final String name;
    private final ConcurrentNavigableMap<StaticBuffer, InMemoryColumnValueStore> kcv;

    public InMemoryKeyColumnValueStore(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        this.name = name;
        this.kcv = new ConcurrentSkipListMap<StaticBuffer, InMemoryColumnValueStore>();
    }

    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        InMemoryColumnValueStore cvs = (InMemoryColumnValueStore)this.kcv.get(query.getKey());
        if (cvs == null) {
            return EntryList.EMPTY_LIST;
        }
        return cvs.getSlice(query, txh);
    }

    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        HashMap result = Maps.newHashMap();
        for (StaticBuffer key : keys) {
            result.put(key, this.getSlice(new KeySliceQuery(key, query), txh));
        }
        return result;
    }

    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        InMemoryColumnValueStore cvs = (InMemoryColumnValueStore)this.kcv.get(key);
        if (cvs == null) {
            this.kcv.putIfAbsent(key, new InMemoryColumnValueStore());
            cvs = (InMemoryColumnValueStore)this.kcv.get(key);
        }
        cvs.mutate(additions, deletions, txh);
    }

    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) throws BackendException {
        return new RowIterator(this.kcv.subMap((Object)query.getKeyStart(), (Object)query.getKeyEnd()).entrySet().iterator(), (SliceQuery)query, txh);
    }

    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) throws BackendException {
        return new RowIterator(this.kcv.entrySet().iterator(), query, txh);
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.kcv.clear();
    }

    public void close() throws BackendException {
        this.kcv.clear();
    }

    public InMemoryKeyColumnValueStoreFragmentationReport createFragmentationReport(StoreTransaction txh) throws BackendException {
        int totalPageCount = 0;
        int numMultipageStores = 0;
        int[] pageLevels = new int[]{0, 1, 3, 5, 10, 100, 500};
        int[] pageCounts = new int[pageLevels.length + 1];
        int[] compressablePageLevels = new int[]{0, 1, 3, 5, 10, 100, 500};
        int[] compressablePageCounts = new int[compressablePageLevels.length + 1];
        int[] reductionLevels = new int[]{0, 1, 3, 5, 10, 100, 500};
        int[] reductionCounts = new int[reductionLevels.length + 1];
        int[] entryLevels = new int[]{3, 5, 10, 100, 500, 5000, 20000, 100000, 500000, 1000000};
        int[] entryCounts = new int[entryLevels.length + 1];
        ArrayList<InMemoryColumnValueStore> storesToDefragment = new ArrayList<InMemoryColumnValueStore>(0);
        int keysByteSize = 0;
        int numFragmentedStores = 0;
        int totalFragmentedPages = 0;
        int numCompressableStores = 0;
        int totalCompressablePages = 0;
        int totalAchievablePageReduction = 0;
        for (Map.Entry e : this.kcv.entrySet()) {
            int i;
            keysByteSize += ((StaticBuffer)e.getKey()).length();
            int numEntries = ((InMemoryColumnValueStore)e.getValue()).numEntries(txh);
            for (i = 0; i < entryLevels.length && numEntries > entryLevels[i]; ++i) {
            }
            int n = i;
            entryCounts[n] = entryCounts[n] + 1;
            if (!(e.getValue() instanceof InMemoryColumnValueStore)) continue;
            InMemoryColumnValueStore pbCvs = (InMemoryColumnValueStore)e.getValue();
            SharedEntryBufferFragmentationReport fr = pbCvs.createFragmentationReport(txh);
            int pageCount = fr.getPageCount();
            totalPageCount += pageCount;
            if (pageCount > 1) {
                ++numMultipageStores;
            }
            for (i = 0; i < pageLevels.length && pageCount > pageLevels[i]; ++i) {
            }
            int n2 = i;
            pageCounts[n2] = pageCounts[n2] + 1;
            if (fr.getFragmentedPageCount() <= 0) continue;
            ++numFragmentedStores;
            totalFragmentedPages += fr.getFragmentedPageCount();
            if (fr.getCompressableChunksCount() <= 0) continue;
            ++numCompressableStores;
            totalCompressablePages += fr.getCompressablePageCount();
            totalAchievablePageReduction += fr.getAchievablePageReduction();
            storesToDefragment.add(pbCvs);
            for (i = 0; i < compressablePageLevels.length && fr.getCompressablePageCount() > compressablePageLevels[i]; ++i) {
            }
            int n3 = i;
            compressablePageCounts[n3] = compressablePageCounts[n3] + 1;
            for (i = 0; i < reductionLevels.length && fr.getAchievablePageReduction() > reductionLevels[i]; ++i) {
            }
            int n4 = i;
            reductionCounts[n4] = reductionCounts[n4] + 1;
        }
        return new InMemoryKeyColumnValueStoreFragmentationReport.Builder().name(this.name).numStores(this.kcv.size()).numMultipageStores(numMultipageStores).totalPageCount(totalPageCount).numFragmentedStores(numFragmentedStores).totalFragmentedPages(totalFragmentedPages).numCompressableStores(numCompressableStores).totalCompressablePages(totalCompressablePages).totalAchievablePageReduction(totalAchievablePageReduction).keysByteSize(keysByteSize).entryLevels(entryLevels).entryCounts(entryCounts).pageLevels(pageLevels).pageCounts(pageCounts).compressablePageLevels(compressablePageLevels).compressablePageCounts(compressablePageCounts).reductionLevels(reductionLevels).reductionCounts(reductionCounts).storesToDefragment(storesToDefragment).build();
    }

    public void quickDefragment(Collection<InMemoryColumnValueStore> stores, StoreTransaction txh) throws BackendException {
        for (InMemoryColumnValueStore cvs : stores) {
            cvs.quickDefragment(txh);
        }
    }

    public void quickDefragment(StoreTransaction txh) throws BackendException {
        this.quickDefragment(this.kcv.values(), txh);
    }

    private static OutputStream compressedOutputStream(OutputStream streamToWrap) {
        return new DeflaterOutputStream(streamToWrap, new Deflater(1, true), true);
    }

    private static InputStream compressedInputStream(InputStream streamToWrap) {
        return new InflaterInputStream(streamToWrap, new Inflater(true));
    }

    public void dumpTo(Path storePath, ForkJoinPool parallelOperationsExecutor) {
        if (this.kcv.size() < 1) {
            return;
        }
        int numChunks = Runtime.getRuntime().availableProcessors() * 2;
        int chunkSize = this.kcv.size() > 1000 ? this.kcv.size() / numChunks : this.kcv.size();
        ArrayList chunks = Lists.newArrayList((Iterator)Iterators.partition(this.kcv.entrySet().iterator(), (int)chunkSize));
        IntStream.range(0, chunks.size()).mapToObj(i -> {
            Path filePath = Paths.get(storePath.toString(), this.getName() + "_" + i);
            return parallelOperationsExecutor.submit(() -> this.dumpChunk(filePath, (List)chunks.get(i)));
        }).collect(Collectors.toList()).stream().map(ForkJoinTask::join).collect(Collectors.toList());
    }

    private void dumpChunk(Path filePath, List<Map.Entry<StaticBuffer, InMemoryColumnValueStore>> chunk) {
        if (log.isDebugEnabled()) {
            log.debug("number of column stores in chunk " + filePath + ": " + chunk.size() + " " + Thread.currentThread().getName());
        }
        try (OutputStream rawStream = Files.newOutputStream(filePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             BufferedOutputStream bufferedStream = new BufferedOutputStream(rawStream, 0x800000);
             OutputStream compressedStream = InMemoryKeyColumnValueStore.compressedOutputStream(bufferedStream);
             DataOutputStream out = new DataOutputStream(compressedStream);){
            out.writeInt(chunk.size());
            for (Map.Entry<StaticBuffer, InMemoryColumnValueStore> e : chunk) {
                out.writeInt(e.getKey().length());
                out.write((byte[])e.getKey().as(StaticBuffer.ARRAY_FACTORY));
                InMemoryColumnValueStore sbKcv = e.getValue();
                sbKcv.dumpTo(out);
            }
            if (log.isDebugEnabled()) {
                log.debug("finished writing chunk " + filePath + " " + Thread.currentThread().getName());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static InMemoryKeyColumnValueStore readFrom(Path storePath, String name, ForkJoinPool parallelOperationsExecutor) throws IOException {
        InMemoryKeyColumnValueStore store = new InMemoryKeyColumnValueStore(name);
        Files.list(storePath).map(p -> parallelOperationsExecutor.submit(() -> InMemoryKeyColumnValueStore.readChunkFrom(p, store))).collect(Collectors.toList()).stream().map(ForkJoinTask::join).collect(Collectors.toList());
        return store;
    }

    /*
     * Exception decompiling
     */
    private static int readChunkFrom(Path filePath, InMemoryKeyColumnValueStore store) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class RowIterator
    implements KeyIterator {
        private final Iterator<Map.Entry<StaticBuffer, InMemoryColumnValueStore>> rows;
        private final SliceQuery columnSlice;
        private final StoreTransaction transaction;
        private Map.Entry<StaticBuffer, InMemoryColumnValueStore> currentRow;
        private Map.Entry<StaticBuffer, InMemoryColumnValueStore> nextRow;
        private boolean isClosed;

        public RowIterator(Iterator<Map.Entry<StaticBuffer, InMemoryColumnValueStore>> rows, @Nullable SliceQuery columns, StoreTransaction transaction) {
            this.rows = Iterators.filter(rows, entry -> entry != null && !((InMemoryColumnValueStore)entry.getValue()).isEmpty(transaction));
            this.columnSlice = columns;
            this.transaction = transaction;
        }

        public RecordIterator<Entry> getEntries() {
            this.ensureOpen();
            if (this.columnSlice == null) {
                throw new IllegalStateException("getEntries() requires SliceQuery to be set.");
            }
            final KeySliceQuery keySlice = new KeySliceQuery(this.currentRow.getKey(), this.columnSlice);
            return new RecordIterator<Entry>(){
                private final Iterator<Entry> items;
                {
                    this.items = ((InMemoryColumnValueStore)currentRow.getValue()).getSlice(keySlice, transaction).iterator();
                }

                public boolean hasNext() {
                    this.ensureOpen();
                    return this.items.hasNext();
                }

                public Entry next() {
                    this.ensureOpen();
                    return this.items.next();
                }

                public void close() {
                    isClosed = true;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Column removal not supported");
                }
            };
        }

        public boolean hasNext() {
            this.ensureOpen();
            if (null != this.nextRow) {
                return true;
            }
            while (this.rows.hasNext()) {
                this.nextRow = this.rows.next();
                EntryList entries = this.nextRow.getValue().getSlice(new KeySliceQuery(this.nextRow.getKey(), this.columnSlice), this.transaction);
                if (null == entries || 0 >= entries.size()) continue;
                break;
            }
            return null != this.nextRow;
        }

        public StaticBuffer next() {
            this.ensureOpen();
            Preconditions.checkNotNull(this.nextRow);
            this.currentRow = this.nextRow;
            this.nextRow = null;
            return this.currentRow.getKey();
        }

        public void close() {
            this.isClosed = true;
        }

        private void ensureOpen() {
            if (this.isClosed) {
                throw new IllegalStateException("Iterator has been closed.");
            }
        }

        public void remove() {
            throw new UnsupportedOperationException("Key removal not supported");
        }
    }
}

