/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.inmemory;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.StoreMetaData;
import org.janusgraph.diskstorage.common.AbstractStoreTransaction;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.inmemory.InMemoryKeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.janusgraph.diskstorage.keycolumnvalue.StandardStoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class InMemoryStoreManager
implements KeyColumnValueStoreManager {
    private ConcurrentHashMap<String, InMemoryKeyColumnValueStore> stores = new ConcurrentHashMap();
    private final StoreFeatures features = new StandardStoreFeatures.Builder().orderedScan(true).unorderedScan(true).keyOrdered(true).persists(false).optimisticLocking(true).keyConsistent((Configuration)GraphDatabaseConfiguration.buildGraphConfiguration()).build();

    public InMemoryStoreManager() {
        this(Configuration.EMPTY);
    }

    public InMemoryStoreManager(Configuration configuration) {
    }

    public StoreTransaction beginTransaction(BaseTransactionConfig config) throws BackendException {
        return new InMemoryTransaction(config);
    }

    public void close() throws BackendException {
        for (InMemoryKeyColumnValueStore store : this.stores.values()) {
            store.close();
        }
        this.stores.clear();
    }

    public void clearStorage() throws BackendException {
        for (InMemoryKeyColumnValueStore store : this.stores.values()) {
            store.clear();
        }
        this.stores.clear();
    }

    public boolean exists() throws BackendException {
        return !this.stores.isEmpty();
    }

    public StoreFeatures getFeatures() {
        return this.features;
    }

    public KeyColumnValueStore openDatabase(String name, StoreMetaData.Container metaData) throws BackendException {
        if (!this.stores.containsKey(name)) {
            this.stores.putIfAbsent(name, new InMemoryKeyColumnValueStore(name));
        }
        KeyColumnValueStore store = this.stores.get(name);
        Preconditions.checkNotNull((Object)store);
        return store;
    }

    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> storeMut : mutations.entrySet()) {
            KeyColumnValueStore store = this.stores.get(storeMut.getKey());
            Preconditions.checkNotNull((Object)store);
            for (Map.Entry<StaticBuffer, KCVMutation> keyMut : storeMut.getValue().entrySet()) {
                store.mutate(keyMut.getKey(), keyMut.getValue().getAdditions(), keyMut.getValue().getDeletions(), txh);
            }
        }
    }

    public List<KeyRange> getLocalKeyPartition() throws BackendException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.toString();
    }

    public void makeSnapshot(File targetSnapshotDirectory, ForkJoinPool parallelOperationsExecutor) throws IOException {
        Files.createDirectory(Paths.get(targetSnapshotDirectory.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        this.stores.entrySet().stream().map(e -> parallelOperationsExecutor.submit(() -> {
            try {
                this.dumpStore((String)e.getKey(), (InMemoryKeyColumnValueStore)e.getValue(), targetSnapshotDirectory.getAbsolutePath(), parallelOperationsExecutor);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        })).collect(Collectors.toList()).stream().map(ForkJoinTask::join).collect(Collectors.toList());
    }

    private void dumpStore(String storeName, InMemoryKeyColumnValueStore store, String rootPath, ForkJoinPool parallelOperationsExecutor) throws IOException {
        Path filePath = Paths.get(rootPath, storeName);
        Files.createDirectory(filePath, new FileAttribute[0]);
        store.dumpTo(filePath, parallelOperationsExecutor);
    }

    public void restoreFromSnapshot(File sourceSnapshotDirectory, boolean rollbackIfFailed, ForkJoinPool parallelOperationsExecutor) throws IOException, BackendException {
        Path root = Paths.get(sourceSnapshotDirectory.getAbsolutePath(), new String[0]);
        if (!rollbackIfFailed) {
            this.clearStorage();
        }
        ConcurrentHashMap<String, InMemoryKeyColumnValueStore> newStores = rollbackIfFailed ? new ConcurrentHashMap<String, InMemoryKeyColumnValueStore>(this.stores.size()) : this.stores;
        Files.list(root).filter(path -> path.toFile().isDirectory()).map(storePath -> parallelOperationsExecutor.submit(() -> {
            try {
                newStores.put(storePath.getFileName().toString(), InMemoryKeyColumnValueStore.readFrom(storePath, storePath.getFileName().toString(), parallelOperationsExecutor));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        })).collect(Collectors.toList()).stream().map(ForkJoinTask::join).collect(Collectors.toList());
        if (rollbackIfFailed) {
            this.clearStorage();
            this.stores = newStores;
        }
    }

    private static class InMemoryTransaction
    extends AbstractStoreTransaction {
        public InMemoryTransaction(BaseTransactionConfig config) {
            super(config);
        }
    }
}

