/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.vector.PointVectorStrategy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransaction;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.BaseTransactionConfigurable;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexMutation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.diskstorage.lucene.LuceneCustomAnalyzer;
import org.janusgraph.diskstorage.lucene.NumericTranslationQueryParser;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.serialize.AttributeUtils;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.Not;
import org.janusgraph.graphdb.query.condition.Or;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.types.ParameterType;
import org.janusgraph.util.system.IOUtils;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndex
implements IndexProvider {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndex.class);
    static final String DOCID = "_____elementid";
    private static final String STRING_SUFFIX = "_____s";
    private static final String GEOID = "_____geo";
    private static final Set<String> FIELDS_TO_LOAD = Sets.newHashSet((Object[])new String[]{"_____elementid"});
    private static final IndexFeatures LUCENE_FEATURES = new IndexFeatures.Builder().setDefaultStringMapping(Mapping.TEXT).supportedStringMappings(new Mapping[]{Mapping.TEXT, Mapping.STRING, Mapping.TEXTSTRING}).supportsCardinality(Cardinality.SINGLE).supportsCardinality(Cardinality.LIST).supportsCardinality(Cardinality.SET).supportsCustomAnalyzer().supportsNanoseconds().supportsGeoContains().supportNotQueryNormalForm().build();
    public static final int DEFAULT_GEO_MAX_LEVELS = 20;
    public static final double DEFAULT_GEO_DIST_ERROR_PCT = 0.025;
    private static final Map<Geo, SpatialOperation> SPATIAL_PREDICATES = LuceneIndex.spatialPredicates();
    private final Map<String, IndexWriter> writers = new HashMap<String, IndexWriter>(4);
    private final ReentrantLock writerLock = new ReentrantLock();
    private final Map<String, SpatialStrategy> spatial = new ConcurrentHashMap<String, SpatialStrategy>(12);
    private final SpatialContext ctx = Geoshape.getSpatialContext();
    private final String basePath;
    private final Map<String, LuceneCustomAnalyzer> delegatingAnalyzers = new HashMap<String, LuceneCustomAnalyzer>();

    public LuceneIndex(Configuration config) {
        String dir = (String)config.get(GraphDatabaseConfiguration.INDEX_DIRECTORY, new String[0]);
        File directory = new File(dir);
        if (!directory.exists() && !directory.mkdirs() || !directory.isDirectory() || !directory.canWrite()) {
            throw new IllegalArgumentException("Cannot access or write to directory: " + dir);
        }
        this.basePath = directory.getAbsolutePath();
        log.debug("Configured Lucene to use base directory [{}]", (Object)this.basePath);
    }

    private Directory getStoreDirectory(String store) throws BackendException {
        Preconditions.checkArgument((boolean)StringUtils.isAlphanumeric((CharSequence)store), (String)"Invalid store name: %s", (Object)store);
        String dir = this.basePath + File.separator + store;
        try {
            File path = new File(dir);
            if (!path.exists() && !path.mkdirs() || !path.isDirectory() || !path.canWrite()) {
                throw new PermanentBackendException("Cannot access or write to directory: " + dir);
            }
            log.debug("Opening store directory [{}]", (Object)path);
            return FSDirectory.open((Path)path.toPath());
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not open directory: " + dir, (Throwable)e);
        }
    }

    private IndexWriter getWriter(String store, KeyInformation.IndexRetriever informations) throws BackendException {
        Preconditions.checkArgument((boolean)this.writerLock.isHeldByCurrentThread());
        IndexWriter writer = this.writers.get(store);
        if (writer == null) {
            LuceneCustomAnalyzer analyzer = this.delegatingAnalyzerFor(store, informations);
            IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            try {
                writer = new IndexWriter(this.getStoreDirectory(store), iwc);
                this.writers.put(store, writer);
            }
            catch (IOException e) {
                throw new PermanentBackendException("Could not create writer", (Throwable)e);
            }
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpatialStrategy getSpatialStrategy(String key, KeyInformation ki) {
        SpatialStrategy strategy = this.spatial.get(key);
        Mapping mapping = Mapping.getMapping((KeyInformation)ki);
        int maxLevels = (Integer)ParameterType.INDEX_GEO_MAX_LEVELS.findParameter(ki.getParameters(), (Object)20);
        double distErrorPct = (Double)ParameterType.INDEX_GEO_DIST_ERROR_PCT.findParameter(ki.getParameters(), (Object)0.025);
        if (strategy == null) {
            Map<String, SpatialStrategy> map = this.spatial;
            synchronized (map) {
                if (!this.spatial.containsKey(key)) {
                    if (mapping == Mapping.DEFAULT) {
                        strategy = PointVectorStrategy.newInstance((SpatialContext)this.ctx, (String)key);
                    } else {
                        QuadPrefixTree grid = new QuadPrefixTree(this.ctx, maxLevels);
                        strategy = new RecursivePrefixTreeStrategy((SpatialPrefixTree)grid, key);
                        ((PrefixTreeStrategy)strategy).setDistErrPct(distErrorPct);
                    }
                } else {
                    return this.spatial.get(key);
                }
                this.spatial.put(key, strategy);
            }
        }
        return strategy;
    }

    private static Map<Geo, SpatialOperation> spatialPredicates() {
        return Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<Geo, SpatialOperation>(Geo.WITHIN, SpatialOperation.IsWithin), new AbstractMap.SimpleEntry<Geo, SpatialOperation>(Geo.CONTAINS, SpatialOperation.Contains), new AbstractMap.SimpleEntry<Geo, SpatialOperation>(Geo.INTERSECT, SpatialOperation.Intersects), new AbstractMap.SimpleEntry<Geo, SpatialOperation>(Geo.DISJOINT, SpatialOperation.IsDisjointTo)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
    }

    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws BackendException {
        Class dataType = information.getDataType();
        Mapping map = Mapping.getMapping((KeyInformation)information);
        Preconditions.checkArgument((map == Mapping.DEFAULT || AttributeUtils.isString((Class)dataType) || map == Mapping.PREFIX_TREE && AttributeUtils.isGeo((Class)dataType) ? 1 : 0) != 0, (String)"Specified illegal mapping [%s] for data type [%s]", (Object)map, (Object)dataType);
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        Transaction ltx = (Transaction)tx;
        this.writerLock.lock();
        try {
            for (Map.Entry<String, Map<String, IndexMutation>> stores : mutations.entrySet()) {
                this.mutateStores(stores, information);
            }
            ltx.postCommit();
        }
        catch (IOException e) {
            throw new TemporaryBackendException("Could not update Lucene index", (Throwable)e);
        }
        finally {
            this.writerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mutateStores(Map.Entry<String, Map<String, IndexMutation>> stores, KeyInformation.IndexRetriever information) throws IOException, BackendException {
        DirectoryReader reader = null;
        try {
            String storeName = stores.getKey();
            IndexWriter writer = this.getWriter(storeName, information);
            reader = DirectoryReader.open((IndexWriter)writer, (boolean)true, (boolean)true);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            KeyInformation.StoreRetriever storeRetriever = information.get(storeName);
            for (Map.Entry<String, IndexMutation> entry : stores.getValue().entrySet()) {
                String documentId = entry.getKey();
                IndexMutation mutation = entry.getValue();
                if (mutation.isDeleted()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Deleted entire document [{}]", (Object)documentId);
                    }
                    writer.deleteDocuments(new Term[]{new Term(DOCID, documentId)});
                    continue;
                }
                Document doc = this.retrieveOrCreate(documentId, searcher);
                Preconditions.checkNotNull((Object)doc);
                for (IndexEntry del : mutation.getDeletions()) {
                    Preconditions.checkArgument((!del.hasMetaData() ? 1 : 0) != 0, (String)"Lucene index does not support indexing meta data: %s", (Object)del);
                    String fieldName = del.field;
                    if (log.isTraceEnabled()) {
                        log.trace("Removing field [{}] on document [{}]", (Object)fieldName, (Object)documentId);
                    }
                    KeyInformation ki = storeRetriever.get(fieldName);
                    this.removeField(doc, del, ki);
                }
                this.addToDocument(doc, mutation.getAdditions(), storeRetriever, false);
                writer.updateDocument(new Term(DOCID, documentId), (Iterable)doc);
            }
            writer.commit();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(Map<String, Map<String, List<IndexEntry>>> documents, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        this.writerLock.lock();
        try {
            for (Map.Entry<String, Map<String, List<IndexEntry>>> stores : documents.entrySet()) {
                DirectoryReader reader = null;
                try {
                    String store = stores.getKey();
                    IndexWriter writer = this.getWriter(store, information);
                    KeyInformation.StoreRetriever storeRetriever = information.get(store);
                    reader = DirectoryReader.open((IndexWriter)writer, (boolean)true, (boolean)true);
                    IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                    for (Map.Entry<String, List<IndexEntry>> entry : stores.getValue().entrySet()) {
                        String docID = entry.getKey();
                        List<IndexEntry> content = entry.getValue();
                        if (content == null || content.isEmpty()) {
                            if (log.isTraceEnabled()) {
                                log.trace("Deleting document [{}]", (Object)docID);
                            }
                            writer.deleteDocuments(new Term[]{new Term(DOCID, docID)});
                            continue;
                        }
                        Document doc = this.retrieveOrCreate(docID, searcher);
                        Iterators.removeIf((Iterator)doc.iterator(), field -> !field.name().equals(DOCID));
                        this.addToDocument(doc, content, storeRetriever, true);
                        writer.updateDocument(new Term(DOCID, docID), (Iterable)doc);
                    }
                    writer.commit();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)reader);
            }
            tx.commit();
        }
        catch (IOException e) {
            throw new TemporaryBackendException("Could not update Lucene index", (Throwable)e);
        }
        finally {
            this.writerLock.unlock();
        }
    }

    private Document retrieveOrCreate(String docID, IndexSearcher searcher) throws IOException {
        Document doc;
        TopDocs hits = searcher.search((Query)new TermQuery(new Term(DOCID, docID)), 10);
        if (hits.scoreDocs.length > 1) {
            throw new IllegalArgumentException("More than one document found for document id: " + docID);
        }
        if (hits.scoreDocs.length == 0) {
            if (log.isTraceEnabled()) {
                log.trace("Creating new document for [{}]", (Object)docID);
            }
            doc = new Document();
            doc.add((IndexableField)new StringField(DOCID, docID, Field.Store.YES));
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Updating existing document for [{}]", (Object)docID);
            }
            int docId = hits.scoreDocs[0].doc;
            doc = searcher.doc(docId);
        }
        return doc;
    }

    private void addToDocument(Document doc, List<IndexEntry> content, KeyInformation.StoreRetriever information, boolean isNew) {
        Preconditions.checkNotNull((Object)doc);
        for (IndexEntry e : content) {
            Preconditions.checkArgument((!e.hasMetaData() ? 1 : 0) != 0, (String)"Lucene index does not support indexing meta data: %s", (Object)e);
            if (log.isTraceEnabled()) {
                log.trace("Adding field [{}] on document [{}]", (Object)e.field, (Object)doc.get(DOCID));
            }
            KeyInformation ki = information.get(e.field);
            if (!isNew && ki.getCardinality() != Cardinality.LIST) {
                this.removeField(doc, e, ki);
            }
            doc.add((IndexableField)this.buildStoreField(e.field, e.value, Mapping.getMapping((KeyInformation)ki)));
            LuceneIndex.getDualFieldName(e.field, ki).ifPresent(dualFieldName -> doc.add((IndexableField)this.buildStoreField((String)dualFieldName, e.value, LuceneIndex.getDualMapping(ki))));
        }
        this.buildIndexFields(doc, information).forEach(arg_0 -> ((Document)doc).add(arg_0));
    }

    private void removeField(Document doc, IndexEntry e, KeyInformation ki) {
        this.removeFieldIfNeeded(doc, e.field, e.value, ki);
        LuceneIndex.getDualFieldName(e.field, ki).ifPresent(dualFieldName -> this.removeFieldIfNeeded(doc, (String)dualFieldName, e.value, ki));
    }

    private void removeFieldIfNeeded(Document doc, String fieldName, Object fieldValue, KeyInformation ki) {
        boolean isSingle = ki.getCardinality() == Cardinality.SINGLE;
        Iterator it = doc.iterator();
        while (it.hasNext()) {
            IndexableField field = (IndexableField)it.next();
            if (!fieldName.equals(field.name()) || !isSingle && !this.convertToStringValue(ki, fieldValue).equals(field.stringValue())) continue;
            it.remove();
            break;
        }
    }

    private String convertToStringValue(KeyInformation ki, Object value) {
        String converted;
        if (value instanceof Number) {
            converted = value.toString();
        } else if (AttributeUtils.isString((Object)value)) {
            Mapping mapping = Mapping.getMapping((KeyInformation)ki);
            converted = mapping == Mapping.DEFAULT || mapping == Mapping.TEXT || mapping == Mapping.TEXTSTRING ? ((String)value).toLowerCase() : (String)value;
        } else if (value instanceof Date) {
            converted = String.valueOf(((Date)value).getTime());
        } else if (value instanceof Instant) {
            converted = String.valueOf(((Instant)value).toEpochMilli());
        } else if (value instanceof Boolean) {
            converted = String.valueOf((Boolean)value != false ? 1 : 0);
        } else if (value instanceof UUID) {
            converted = value.toString();
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value);
        }
        return converted;
    }

    private Field buildStoreField(String fieldName, Object value, Mapping mapping) {
        StoredField field;
        if (value instanceof Number) {
            field = AttributeUtils.isWholeNumber((Number)((Number)value)) ? new StoredField(fieldName, ((Number)value).longValue()) : new StoredField(fieldName, ((Number)value).doubleValue());
        } else if (AttributeUtils.isString((Object)value)) {
            String str = (String)value;
            switch (mapping) {
                case DEFAULT: 
                case TEXTSTRING: 
                case TEXT: {
                    field = new TextField(fieldName, str.toLowerCase(), Field.Store.YES);
                    break;
                }
                case STRING: {
                    field = new TextField(fieldName, str, Field.Store.YES);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal mapping specified: " + mapping);
                }
            }
        } else if (value instanceof Geoshape) {
            field = new StoredField(fieldName, GEOID + value);
        } else if (value instanceof Date) {
            field = new StoredField(fieldName, ((Date)value).getTime());
        } else if (value instanceof Instant) {
            field = new StoredField(fieldName, ((Instant)value).toEpochMilli());
        } else if (value instanceof Boolean) {
            field = new StoredField(fieldName, (Boolean)value != false ? 1 : 0);
        } else if (value instanceof UUID) {
            field = new TextField(fieldName, value.toString(), Field.Store.YES);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value);
        }
        return field;
    }

    private List<IndexableField> buildIndexFields(Document doc, KeyInformation.StoreRetriever information) {
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
        for (IndexableField field : doc.getFields()) {
            long value;
            String fieldName = field.name();
            if (fieldName.equals(DOCID)) continue;
            KeyInformation ki = information.get(LuceneIndex.getOrigFieldName(fieldName));
            boolean isPossibleSortIndex = ki.getCardinality() == Cardinality.SINGLE;
            Class dataType = ki.getDataType();
            if (AttributeUtils.isWholeNumber((Class)dataType)) {
                value = field.numericValue().longValue();
                fields.add((IndexableField)new LongPoint(fieldName, new long[]{value}));
                if (!isPossibleSortIndex) continue;
                fields.add((IndexableField)new NumericDocValuesField(fieldName, value));
                continue;
            }
            if (AttributeUtils.isDecimal((Class)dataType)) {
                double value2 = field.numericValue().doubleValue();
                fields.add((IndexableField)new DoublePoint(fieldName, new double[]{value2}));
                if (!isPossibleSortIndex) continue;
                fields.add((IndexableField)new DoubleDocValuesField(fieldName, value2));
                continue;
            }
            if (AttributeUtils.isString((Class)dataType)) {
                Mapping mapping = Mapping.getMapping((KeyInformation)ki);
                if (mapping != Mapping.STRING && mapping != Mapping.TEXTSTRING || !isPossibleSortIndex) continue;
                fields.add((IndexableField)new SortedDocValuesField(fieldName, new BytesRef((CharSequence)field.stringValue())));
                continue;
            }
            if (AttributeUtils.isGeo((Class)dataType)) {
                Shape shape;
                if (log.isTraceEnabled()) {
                    log.trace("Updating geo-indexes for key {}", (Object)fieldName);
                }
                try {
                    shape = Geoshape.fromWkt((String)field.stringValue().substring(GEOID.length())).getShape();
                }
                catch (java.text.ParseException e) {
                    throw new IllegalArgumentException("Geoshape was not parsable", e);
                }
                SpatialStrategy spatialStrategy = this.getSpatialStrategy(fieldName, ki);
                Collections.addAll(fields, spatialStrategy.createIndexableFields(shape));
                continue;
            }
            if (dataType.equals(Date.class) || dataType.equals(Instant.class)) {
                value = field.numericValue().longValue();
                fields.add((IndexableField)new LongPoint(fieldName, new long[]{value}));
                if (!isPossibleSortIndex) continue;
                fields.add((IndexableField)new NumericDocValuesField(fieldName, value));
                continue;
            }
            if (!dataType.equals(Boolean.class)) continue;
            fields.add((IndexableField)new IntPoint(fieldName, new int[]{field.numericValue().intValue() == 1 ? 1 : 0}));
            if (!isPossibleSortIndex) continue;
            fields.add((IndexableField)new NumericDocValuesField(fieldName, (long)field.numericValue().intValue()));
        }
        return fields;
    }

    private static Sort getSortOrder(List<IndexQuery.OrderEntry> orders, KeyInformation.StoreRetriever information) {
        Sort sort = new Sort();
        if (!orders.isEmpty()) {
            SortField[] fields = new SortField[orders.size()];
            for (int i = 0; i < orders.size(); ++i) {
                IndexQuery.OrderEntry order = orders.get(i);
                SortField.Type sortType = null;
                Class dataType = order.getDatatype();
                if (AttributeUtils.isString((Class)dataType)) {
                    sortType = SortField.Type.STRING;
                } else if (AttributeUtils.isWholeNumber((Class)dataType)) {
                    sortType = SortField.Type.LONG;
                } else if (AttributeUtils.isDecimal((Class)dataType)) {
                    sortType = SortField.Type.DOUBLE;
                } else if (dataType.equals(Instant.class) || dataType.equals(Date.class)) {
                    sortType = SortField.Type.LONG;
                } else if (dataType.equals(Boolean.class)) {
                    sortType = SortField.Type.LONG;
                } else {
                    Preconditions.checkArgument((boolean)false, (String)"Unsupported order specified on field [%s] with datatype [%s]", (Object)order.getKey(), (Object)dataType);
                }
                KeyInformation ki = information.get(order.getKey());
                String fieldKey = Mapping.getMapping((KeyInformation)ki) == Mapping.TEXTSTRING ? LuceneIndex.getDualFieldName(order.getKey(), ki).orElse(order.getKey()) : order.getKey();
                fields[i] = new SortField(fieldKey, sortType, order.getOrder() == Order.DESC);
            }
            sort.setSort(fields);
        }
        return sort;
    }

    public Stream<String> query(IndexQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        String store = query.getStore();
        LuceneCustomAnalyzer delegatingAnalyzer = this.delegatingAnalyzerFor(store, information);
        SearchParams searchParams = this.convertQuery(query.getCondition(), information.get(store), delegatingAnalyzer);
        try {
            IndexSearcher searcher = ((Transaction)tx).getSearcher(query.getStore());
            if (searcher == null) {
                return Collections.unmodifiableList(new ArrayList()).stream();
            }
            Query q = searchParams.getQuery();
            if (null == q) {
                q = new MatchAllDocsQuery();
            }
            long time = System.currentTimeMillis();
            int limit = query.hasLimit() ? query.getLimit() : 0x7FFFFFFE;
            Object docs = query.getOrder().isEmpty() ? searcher.search(q, limit) : searcher.search(q, limit, LuceneIndex.getSortOrder(query.getOrder(), information.get(store)));
            log.debug("Executed query [{}] in {} ms", (Object)q, (Object)(System.currentTimeMillis() - time));
            ArrayList<String> result = new ArrayList<String>(docs.scoreDocs.length);
            for (int i = 0; i < docs.scoreDocs.length; ++i) {
                IndexableField field = searcher.doc(docs.scoreDocs[i].doc, FIELDS_TO_LOAD).getField(DOCID);
                result.add(field == null ? null : field.stringValue());
            }
            return result.stream();
        }
        catch (IOException e) {
            throw new TemporaryBackendException("Could not execute Lucene query", (Throwable)e);
        }
    }

    private static Query numericQuery(String key, Cmp relation, Number value) {
        switch (relation) {
            case EQUAL: {
                return AttributeUtils.isWholeNumber((Number)value) ? LongPoint.newRangeQuery((String)key, (long)value.longValue(), (long)value.longValue()) : DoublePoint.newRangeQuery((String)key, (double)value.doubleValue(), (double)value.doubleValue());
            }
            case NOT_EQUAL: {
                BooleanQuery.Builder q = new BooleanQuery.Builder();
                if (AttributeUtils.isWholeNumber((Number)value)) {
                    q.add(LongPoint.newRangeQuery((String)key, (long)Long.MIN_VALUE, (long)Math.addExact(value.longValue(), -1L)), BooleanClause.Occur.SHOULD);
                    q.add(LongPoint.newRangeQuery((String)key, (long)Math.addExact(value.longValue(), 1L), (long)Long.MAX_VALUE), BooleanClause.Occur.SHOULD);
                } else {
                    q.add(DoublePoint.newRangeQuery((String)key, (double)Double.MIN_VALUE, (double)DoublePoint.nextDown((double)value.doubleValue())), BooleanClause.Occur.SHOULD);
                    q.add(DoublePoint.newRangeQuery((String)key, (double)DoublePoint.nextUp((double)value.doubleValue()), (double)Double.MAX_VALUE), BooleanClause.Occur.SHOULD);
                }
                return q.build();
            }
            case LESS_THAN: {
                return AttributeUtils.isWholeNumber((Number)value) ? LongPoint.newRangeQuery((String)key, (long)Long.MIN_VALUE, (long)Math.addExact(value.longValue(), -1L)) : DoublePoint.newRangeQuery((String)key, (double)Double.MIN_VALUE, (double)DoublePoint.nextDown((double)value.doubleValue()));
            }
            case LESS_THAN_EQUAL: {
                return AttributeUtils.isWholeNumber((Number)value) ? LongPoint.newRangeQuery((String)key, (long)Long.MIN_VALUE, (long)value.longValue()) : DoublePoint.newRangeQuery((String)key, (double)Double.MIN_VALUE, (double)value.doubleValue());
            }
            case GREATER_THAN: {
                return AttributeUtils.isWholeNumber((Number)value) ? LongPoint.newRangeQuery((String)key, (long)Math.addExact(value.longValue(), 1L), (long)Long.MAX_VALUE) : DoublePoint.newRangeQuery((String)key, (double)DoublePoint.nextUp((double)value.doubleValue()), (double)Double.MAX_VALUE);
            }
            case GREATER_THAN_EQUAL: {
                return AttributeUtils.isWholeNumber((Number)value) ? LongPoint.newRangeQuery((String)key, (long)value.longValue(), (long)Long.MAX_VALUE) : DoublePoint.newRangeQuery((String)key, (double)value.doubleValue(), (double)Double.MAX_VALUE);
            }
        }
        throw new IllegalArgumentException("Unexpected relation: " + relation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<List<String>> customTokenize(Analyzer analyzer, String fieldName, String value) {
        HashMap<Integer, ArrayList<String>> stemsByOffset = new HashMap<Integer, ArrayList<String>>();
        try (CachingTokenFilter stream = new CachingTokenFilter(analyzer.tokenStream(fieldName, value));){
            OffsetAttribute offsetAtt = (OffsetAttribute)stream.getAttribute(OffsetAttribute.class);
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                int offset = offsetAtt.startOffset();
                String stem = termAtt.getBytesRef().utf8ToString();
                ArrayList<String> stemList = (ArrayList<String>)stemsByOffset.get(offset);
                if (stemList == null) {
                    stemList = new ArrayList<String>();
                    stemsByOffset.put(offset, stemList);
                }
                stemList.add(stem);
            }
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>(stemsByOffset.values());
            return arrayList;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tokenize(SearchParams params, Mapping mapping, LuceneCustomAnalyzer delegatingAnalyzer, String value, String key, JanusGraphPredicate janusgraphPredicate) {
        Analyzer analyzer = delegatingAnalyzer.getWrappedAnalyzer(key);
        List<List<String>> terms = this.customTokenize(analyzer, key, value);
        if (terms.isEmpty()) {
            void var9_11;
            if (janusgraphPredicate != Text.CONTAINS_PREFIX) return;
            if (mapping == Mapping.STRING) {
                Term term = new Term(key, value);
            } else {
                Term term = new Term(key, value.toLowerCase());
            }
            params.addQuery((Query)new PrefixQuery((Term)var9_11), BooleanClause.Occur.MUST);
            return;
        } else if (terms.size() == 1) {
            if (janusgraphPredicate == Cmp.EQUAL || janusgraphPredicate == Text.CONTAINS) {
                params.addQuery(this.combineTerms(key, terms.get(0), TermQuery::new));
                return;
            } else if (janusgraphPredicate == Cmp.NOT_EQUAL) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                builder.add(this.combineTerms(key, terms.get(0), TermQuery::new), BooleanClause.Occur.MUST_NOT);
                params.addQuery((Query)builder.build(), BooleanClause.Occur.MUST);
                SearchParams existParams = new SearchParams();
                this.addExistsQuery(existParams, key);
                params.addParams(existParams, BooleanClause.Occur.MUST);
                return;
            } else {
                void var9_15;
                if (janusgraphPredicate != Text.CONTAINS_PREFIX) throw new IllegalArgumentException("LuceneIndex does not support this predicate with 1 token : " + janusgraphPredicate);
                ArrayList arrayList = new ArrayList(terms.get(0));
                if (mapping != Mapping.STRING) {
                    List list = terms.get(0).stream().map(String::toLowerCase).collect(Collectors.toList());
                }
                params.addQuery(this.combineTerms(key, (List<String>)var9_15, PrefixQuery::new), BooleanClause.Occur.MUST);
            }
            return;
        } else {
            BooleanClause.Occur occur;
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            if (janusgraphPredicate == Cmp.NOT_EQUAL) {
                builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                occur = BooleanClause.Occur.MUST_NOT;
            } else {
                occur = BooleanClause.Occur.MUST;
            }
            for (List<String> stems : terms) {
                builder.add(this.combineTerms(key, stems, TermQuery::new), occur);
            }
            params.addQuery((Query)builder.build());
        }
    }

    private void addExistsQuery(SearchParams params, String key) {
        params.addQuery((Query)new DocValuesFieldExistsQuery(key), BooleanClause.Occur.SHOULD);
        params.addQuery((Query)new NormsFieldExistsQuery(key), BooleanClause.Occur.SHOULD);
    }

    private Query combineTerms(String key, List<String> terms, Function<Term, Query> queryCreator) {
        if (terms.size() > 1) {
            BooleanQuery.Builder q = new BooleanQuery.Builder();
            for (String term : terms) {
                q.add(queryCreator.apply(new Term(key, term)), BooleanClause.Occur.SHOULD);
            }
            return q.build();
        }
        if (terms.size() == 1) {
            return queryCreator.apply(new Term(key, terms.get(0)));
        }
        return new MatchNoDocsQuery("No terms for key " + key);
    }

    private LuceneCustomAnalyzer delegatingAnalyzerFor(String store, KeyInformation.IndexRetriever information2) {
        if (!this.delegatingAnalyzers.containsKey(store)) {
            this.delegatingAnalyzers.put(store, new LuceneCustomAnalyzer(store, information2, Analyzer.PER_FIELD_REUSE_STRATEGY));
        }
        return this.delegatingAnalyzers.get(store);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SearchParams convertQuery(Condition<?> condition, KeyInformation.StoreRetriever information, LuceneCustomAnalyzer delegatingAnalyzer) {
        SearchParams params = new SearchParams();
        if (condition instanceof PredicateCondition) {
            PredicateCondition atom = (PredicateCondition)condition;
            Object value = atom.getValue();
            String key = (String)atom.getKey();
            KeyInformation ki = information.get(key);
            JanusGraphPredicate janusgraphPredicate = atom.getPredicate();
            if (value == null && janusgraphPredicate == Cmp.NOT_EQUAL) {
                this.addExistsQuery(params, key);
                return params;
            }
            if (value instanceof Number) {
                Preconditions.checkArgument((boolean)(janusgraphPredicate instanceof Cmp), (String)"Relation not supported on numeric types: %s", (Object)janusgraphPredicate);
                params.addQuery(LuceneIndex.numericQuery(key, (Cmp)janusgraphPredicate, (Number)value));
                return params;
            }
            if (value instanceof String) {
                if (janusgraphPredicate == Cmp.LESS_THAN) {
                    params.addQuery((Query)TermRangeQuery.newStringRange((String)key, null, (String)value.toString(), (boolean)false, (boolean)false));
                    return params;
                } else if (janusgraphPredicate == Cmp.LESS_THAN_EQUAL) {
                    params.addQuery((Query)TermRangeQuery.newStringRange((String)key, null, (String)value.toString(), (boolean)false, (boolean)true));
                    return params;
                } else if (janusgraphPredicate == Cmp.GREATER_THAN) {
                    params.addQuery((Query)TermRangeQuery.newStringRange((String)key, (String)value.toString(), null, (boolean)false, (boolean)false));
                    return params;
                } else if (janusgraphPredicate == Cmp.GREATER_THAN_EQUAL) {
                    params.addQuery((Query)TermRangeQuery.newStringRange((String)key, (String)value.toString(), null, (boolean)true, (boolean)false));
                    return params;
                } else {
                    Mapping map = Mapping.getMapping((KeyInformation)ki);
                    String stringFieldKey = Mapping.getMapping((KeyInformation)ki) == Mapping.TEXTSTRING ? LuceneIndex.getDualFieldName(key, ki).orElse(key) : key;
                    if (!(map != Mapping.DEFAULT && map != Mapping.TEXT || Text.HAS_CONTAINS.contains(janusgraphPredicate))) {
                        throw new IllegalArgumentException("Text mapped string values only support CONTAINS queries and not: " + janusgraphPredicate);
                    }
                    if (map == Mapping.STRING && Text.HAS_CONTAINS.contains(janusgraphPredicate)) {
                        throw new IllegalArgumentException("String mapped string values do not support CONTAINS queries: " + janusgraphPredicate);
                    }
                    if (janusgraphPredicate == Text.CONTAINS) {
                        this.tokenize(params, map, delegatingAnalyzer, ((String)value).toLowerCase(), key, janusgraphPredicate);
                        return params;
                    } else if (janusgraphPredicate == Text.CONTAINS_PREFIX) {
                        this.tokenize(params, map, delegatingAnalyzer, (String)value, key, janusgraphPredicate);
                        return params;
                    } else if (janusgraphPredicate == Text.PREFIX) {
                        params.addQuery((Query)new PrefixQuery(new Term(stringFieldKey, (String)value)));
                        return params;
                    } else if (janusgraphPredicate == Text.REGEX) {
                        RegexpQuery rq = new RegexpQuery(new Term(stringFieldKey, (String)value));
                        params.addQuery((Query)rq);
                        return params;
                    } else if (janusgraphPredicate == Text.CONTAINS_REGEX) {
                        RegexpQuery rq = new RegexpQuery(new Term(key, ".*" + ((String)value).toLowerCase() + ".*"));
                        params.addQuery((Query)rq);
                        return params;
                    } else if (janusgraphPredicate == Cmp.EQUAL || janusgraphPredicate == Cmp.NOT_EQUAL) {
                        this.tokenize(params, map, delegatingAnalyzer, (String)value, stringFieldKey, janusgraphPredicate);
                        return params;
                    } else if (janusgraphPredicate == Text.FUZZY) {
                        params.addQuery((Query)new FuzzyQuery(new Term(stringFieldKey, (String)value), Text.getMaxEditDistance((String)((String)value))));
                        return params;
                    } else {
                        if (janusgraphPredicate != Text.CONTAINS_FUZZY) throw new IllegalArgumentException("Relation is not supported for string value: " + janusgraphPredicate);
                        value = ((String)value).toLowerCase();
                        BooleanQuery.Builder b = new BooleanQuery.Builder();
                        for (String term : Text.tokenize((String)((String)value))) {
                            b.add((Query)new FuzzyQuery(new Term(key, term), Text.getMaxEditDistance((String)term)), BooleanClause.Occur.MUST);
                        }
                        params.addQuery((Query)b.build());
                    }
                }
                return params;
            }
            if (value instanceof Geoshape) {
                Preconditions.checkArgument((boolean)(janusgraphPredicate instanceof Geo), (String)"Relation not supported on geo types: %s", (Object)janusgraphPredicate);
                Shape shape = ((Geoshape)value).getShape();
                SpatialOperation spatialOp = SPATIAL_PREDICATES.get(janusgraphPredicate);
                SpatialArgs args = new SpatialArgs(spatialOp, shape);
                params.addQuery(this.getSpatialStrategy(key, information.get(key)).makeQuery(args));
                return params;
            }
            if (value instanceof Date) {
                Preconditions.checkArgument((boolean)(janusgraphPredicate instanceof Cmp), (String)"Relation not supported on date types: %s", (Object)janusgraphPredicate);
                params.addQuery(LuceneIndex.numericQuery(key, (Cmp)janusgraphPredicate, ((Date)value).getTime()));
                return params;
            }
            if (value instanceof Instant) {
                Preconditions.checkArgument((boolean)(janusgraphPredicate instanceof Cmp), (String)"Relation not supported on instant types: %s", (Object)janusgraphPredicate);
                params.addQuery(LuceneIndex.numericQuery(key, (Cmp)janusgraphPredicate, ((Instant)value).toEpochMilli()));
                return params;
            }
            if (value instanceof Boolean) {
                Preconditions.checkArgument((boolean)(janusgraphPredicate instanceof Cmp), (String)"Relation not supported on boolean types: %s", (Object)janusgraphPredicate);
                switch ((Cmp)janusgraphPredicate) {
                    case EQUAL: {
                        int intValue = (Boolean)value != false ? 1 : 0;
                        params.addQuery(IntPoint.newRangeQuery((String)key, (int)intValue, (int)intValue));
                        return params;
                    }
                    case NOT_EQUAL: {
                        int intValue = (Boolean)value != false ? 0 : 1;
                        params.addQuery(IntPoint.newRangeQuery((String)key, (int)intValue, (int)intValue));
                        return params;
                    }
                    default: {
                        throw new IllegalArgumentException("Boolean types only support EQUAL or NOT_EQUAL");
                    }
                }
            }
            if (!(value instanceof UUID)) throw new IllegalArgumentException("Unsupported type: " + value);
            Preconditions.checkArgument((boolean)(janusgraphPredicate instanceof Cmp), (String)"Relation not supported on UUID types: %s", (Object)janusgraphPredicate);
            if (janusgraphPredicate == Cmp.EQUAL) {
                params.addQuery((Query)new TermQuery(new Term(key, value.toString())));
                return params;
            } else {
                if (janusgraphPredicate != Cmp.NOT_EQUAL) throw new IllegalArgumentException("Relation is not supported for UUID type: " + janusgraphPredicate);
                SearchParams existParams = new SearchParams();
                this.addExistsQuery(existParams, key);
                params.addParams(existParams, BooleanClause.Occur.MUST);
                BooleanQuery.Builder q = new BooleanQuery.Builder();
                q.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                q.add((Query)new TermQuery(new Term(key, value.toString())), BooleanClause.Occur.MUST_NOT);
                params.addQuery((Query)q.build());
            }
            return params;
        }
        if (condition instanceof Not) {
            SearchParams childParams = this.convertQuery(((Not)condition).getChild(), information, delegatingAnalyzer);
            params.addQuery((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            params.addParams(childParams, BooleanClause.Occur.MUST_NOT);
            return params;
        } else if (condition instanceof And) {
            for (Condition c : condition.getChildren()) {
                SearchParams childParams = this.convertQuery(c, information, delegatingAnalyzer);
                params.addParams(childParams, BooleanClause.Occur.MUST);
            }
            return params;
        } else {
            if (!(condition instanceof Or)) throw new IllegalArgumentException("Invalid condition: " + condition);
            for (Condition c : condition.getChildren()) {
                SearchParams childParams = this.convertQuery(c, information, delegatingAnalyzer);
                params.addParams(childParams, BooleanClause.Occur.SHOULD);
            }
        }
        return params;
    }

    private QueryParser getQueryParser(String store, KeyInformation.IndexRetriever information) {
        LuceneCustomAnalyzer analyzer = this.delegatingAnalyzerFor(store, information);
        NumericTranslationQueryParser parser = new NumericTranslationQueryParser(information.get(store), "_all", (Analyzer)analyzer);
        parser.setAllowLeadingWildcard(true);
        return parser;
    }

    public Stream<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        Query q;
        try {
            q = this.getQueryParser(query.getStore(), information).parse(query.getQuery());
        }
        catch (ParseException e) {
            throw new PermanentBackendException("Could not parse raw query: " + query.getQuery(), (Throwable)e);
        }
        try {
            int adjustedLimit;
            IndexSearcher searcher = ((Transaction)tx).getSearcher(query.getStore());
            if (searcher == null) {
                return Collections.unmodifiableList(new ArrayList()).stream();
            }
            long time = System.currentTimeMillis();
            int offset = query.getOffset();
            int n = adjustedLimit = query.hasLimit() ? query.getLimit() : 0x7FFFFFFE;
            adjustedLimit = adjustedLimit < 0x7FFFFFFE - offset ? (adjustedLimit += offset) : 0x7FFFFFFE;
            Object docs = query.getOrders().isEmpty() ? searcher.search(q, adjustedLimit) : searcher.search(q, adjustedLimit, LuceneIndex.getSortOrder((List<IndexQuery.OrderEntry>)query.getOrders(), information.get(query.getStore())));
            log.debug("Executed query [{}] in {} ms", (Object)q, (Object)(System.currentTimeMillis() - time));
            ArrayList<RawQuery.Result> result = new ArrayList<RawQuery.Result>(docs.scoreDocs.length);
            for (int i = offset; i < docs.scoreDocs.length; ++i) {
                IndexableField field = searcher.doc(docs.scoreDocs[i].doc, FIELDS_TO_LOAD).getField(DOCID);
                result.add(new RawQuery.Result((Object)(field == null ? null : field.stringValue()), (double)docs.scoreDocs[i].score));
            }
            return result.stream();
        }
        catch (IOException e) {
            throw new TemporaryBackendException("Could not execute Lucene query", (Throwable)e);
        }
    }

    public Long queryCount(IndexQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        String store = query.getStore();
        LuceneCustomAnalyzer delegatingAnalyzer = this.delegatingAnalyzerFor(store, information);
        SearchParams searchParams = this.convertQuery(query.getCondition(), information.get(store), delegatingAnalyzer);
        try {
            IndexSearcher searcher = ((Transaction)tx).getSearcher(query.getStore());
            if (searcher == null) {
                return 0L;
            }
            Query q = searchParams.getQuery();
            long time = System.currentTimeMillis();
            TopDocs docs = searcher.search(q, 1);
            log.debug("Executed query [{}] in {} ms", (Object)q, (Object)(System.currentTimeMillis() - time));
            return QueryUtil.applyQueryLimitAfterCount((long)docs.totalHits.value, (org.janusgraph.graphdb.query.Query)query);
        }
        catch (IOException e) {
            throw new TemporaryBackendException("Could not execute Lucene query", (Throwable)e);
        }
    }

    public Long totals(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        Query q;
        try {
            q = this.getQueryParser(query.getStore(), information).parse(query.getQuery());
        }
        catch (ParseException e) {
            throw new PermanentBackendException("Could not parse raw query: " + query.getQuery(), (Throwable)e);
        }
        try {
            IndexSearcher searcher = ((Transaction)tx).getSearcher(query.getStore());
            if (searcher == null) {
                return 0L;
            }
            long time = System.currentTimeMillis();
            query.setLimit(1);
            TopDocs docs = searcher.search(q, 1);
            log.debug("Executed query [{}] in {} ms", (Object)q, (Object)(System.currentTimeMillis() - time));
            return docs.totalHits.value;
        }
        catch (IOException e) {
            throw new TemporaryBackendException("Could not execute Lucene query", (Throwable)e);
        }
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) throws BackendException {
        return new Transaction(config);
    }

    public boolean supports(KeyInformation information, JanusGraphPredicate janusgraphPredicate) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (!(mapping == Mapping.DEFAULT || AttributeUtils.isString((Class)dataType) || mapping == Mapping.PREFIX_TREE && AttributeUtils.isGeo((Class)dataType))) {
            return false;
        }
        if (Number.class.isAssignableFrom(dataType)) {
            return janusgraphPredicate instanceof Cmp;
        }
        if (dataType == Geoshape.class) {
            if (information.getCardinality() != Cardinality.SINGLE) {
                return false;
            }
            return janusgraphPredicate == Geo.INTERSECT || janusgraphPredicate == Geo.WITHIN || janusgraphPredicate == Geo.CONTAINS;
        }
        if (AttributeUtils.isString((Class)dataType)) {
            switch (mapping) {
                case DEFAULT: 
                case TEXT: {
                    return janusgraphPredicate == Text.CONTAINS || janusgraphPredicate == Text.CONTAINS_PREFIX || janusgraphPredicate == Text.CONTAINS_FUZZY;
                }
                case STRING: {
                    return janusgraphPredicate instanceof Cmp || janusgraphPredicate == Text.PREFIX || janusgraphPredicate == Text.REGEX || janusgraphPredicate == Text.FUZZY;
                }
                case TEXTSTRING: {
                    return janusgraphPredicate instanceof Text || janusgraphPredicate instanceof Cmp;
                }
            }
        } else {
            if (dataType == Date.class || dataType == Instant.class) {
                return janusgraphPredicate instanceof Cmp;
            }
            if (dataType == Boolean.class) {
                return janusgraphPredicate == Cmp.EQUAL || janusgraphPredicate == Cmp.NOT_EQUAL;
            }
            if (dataType == UUID.class) {
                return janusgraphPredicate == Cmp.EQUAL || janusgraphPredicate == Cmp.NOT_EQUAL;
            }
        }
        return false;
    }

    public boolean supports(KeyInformation information) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (Number.class.isAssignableFrom(dataType) || dataType == Date.class || dataType == Instant.class || dataType == Boolean.class || dataType == UUID.class) {
            return mapping == Mapping.DEFAULT;
        }
        if (AttributeUtils.isString((Class)dataType)) {
            return mapping == Mapping.DEFAULT || mapping == Mapping.STRING || mapping == Mapping.TEXT || mapping == Mapping.TEXTSTRING;
        }
        if (AttributeUtils.isGeo((Class)dataType)) {
            return information.getCardinality() == Cardinality.SINGLE && (mapping == Mapping.DEFAULT || mapping == Mapping.PREFIX_TREE);
        }
        return false;
    }

    public String mapKey2Field(String key, KeyInformation information) {
        IndexProvider.checkKeyValidity((String)key);
        return key.replace(' ', '\u2022');
    }

    public IndexFeatures getFeatures() {
        return LUCENE_FEATURES;
    }

    public void close() throws BackendException {
        try {
            for (IndexWriter w : this.writers.values()) {
                w.close();
            }
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not close writers", (Throwable)e);
        }
    }

    public void clearStorage() throws BackendException {
        try {
            FileUtils.deleteDirectory((File)new File(this.basePath));
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not delete lucene directory: " + this.basePath, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists() throws BackendException {
        if (!Files.exists(Paths.get(this.basePath, new String[0]), new LinkOption[0])) return false;
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(this.basePath, new String[0]));){
            boolean bl = dirStream.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not read lucene directory: " + this.basePath, (Throwable)e);
        }
    }

    static String getOrigFieldName(String fieldName) {
        if (LuceneIndex.isDualFieldName(fieldName)) {
            return fieldName.replaceAll(STRING_SUFFIX, "");
        }
        return fieldName;
    }

    static boolean isDualFieldName(String fieldName) {
        return fieldName.endsWith(STRING_SUFFIX);
    }

    static Optional<String> getDualFieldName(String fieldKey, KeyInformation ki) {
        if (AttributeUtils.isString((Class)ki.getDataType()) && Mapping.getMapping((KeyInformation)ki) == Mapping.TEXTSTRING) {
            return Optional.of(fieldKey + STRING_SUFFIX);
        }
        return Optional.empty();
    }

    static Mapping getDualMapping(KeyInformation ki) {
        if (AttributeUtils.isString((Class)ki.getDataType()) && Mapping.getMapping((KeyInformation)ki) == Mapping.TEXTSTRING) {
            return Mapping.STRING;
        }
        return Mapping.DEFAULT;
    }

    private static class SearchParams {
        private final BooleanQuery.Builder qb = new BooleanQuery.Builder();

        private SearchParams() {
        }

        private void addQuery(Query newQuery) {
            this.addQuery(newQuery, BooleanClause.Occur.MUST);
        }

        private void addQuery(Query newQuery, BooleanClause.Occur occur) {
            this.qb.add(newQuery, occur);
        }

        private void addParams(SearchParams other, BooleanClause.Occur occur) {
            Query otherQuery = other.getQuery();
            if (null != otherQuery) {
                this.addQuery(otherQuery, occur);
            }
        }

        private Query getQuery() {
            BooleanQuery q = this.qb.build();
            if (0 == q.clauses().size()) {
                return null;
            }
            return q;
        }
    }

    private class Transaction
    implements BaseTransactionConfigurable {
        private final BaseTransactionConfig config;
        private final Set<String> updatedStores = Sets.newHashSet();
        private final Map<String, IndexSearcher> searchers = new HashMap<String, IndexSearcher>(4);

        private Transaction(BaseTransactionConfig config) {
            this.config = config;
        }

        private synchronized IndexSearcher getSearcher(String store) throws BackendException {
            IndexSearcher searcher = this.searchers.get(store);
            if (searcher == null) {
                try {
                    DirectoryReader reader = DirectoryReader.open((Directory)LuceneIndex.this.getStoreDirectory(store));
                    searcher = new IndexSearcher((IndexReader)reader);
                }
                catch (IndexNotFoundException e) {
                    searcher = null;
                }
                catch (IOException e) {
                    throw new PermanentBackendException("Could not open index reader on store: " + store, (Throwable)e);
                }
                this.searchers.put(store, searcher);
            }
            return searcher;
        }

        public void postCommit() throws BackendException {
            this.close();
            this.searchers.clear();
        }

        public void commit() throws BackendException {
            this.close();
        }

        public void rollback() throws BackendException {
            this.close();
        }

        private void close() throws BackendException {
            try {
                for (IndexSearcher searcher : this.searchers.values()) {
                    if (searcher == null) continue;
                    searcher.getIndexReader().close();
                }
            }
            catch (IOException e) {
                throw new PermanentBackendException("Could not close searcher", (Throwable)e);
            }
        }

        public BaseTransactionConfig getConfiguration() {
            return this.config;
        }
    }
}

