/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.mixed.utils.processor;

import java.util.HashSet;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.diskstorage.mixed.utils.CircleUtils;
import org.janusgraph.diskstorage.mixed.utils.processor.CircleProcessor;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.impl.PointImpl;

public abstract class ErrorDistanceCircleProcessor
implements CircleProcessor {
    private final boolean boundingBoxFallback;

    public ErrorDistanceCircleProcessor(boolean boundingBoxFallback) {
        this.boundingBoxFallback = boundingBoxFallback;
    }

    abstract double getErrorDistanceMeters(Geoshape var1);

    @Override
    public Geoshape process(Geoshape circle) {
        Shape resultShape;
        Shape shape = circle.getShape();
        if (!(shape instanceof Circle)) {
            throw new IllegalArgumentException("Cannot process non-circle shape but received " + shape.getClass().getName() + ". Shape: " + circle.toGeoJson());
        }
        SpatialContext ctx = shape.getContext();
        Circle circleShape = (Circle)shape;
        double circleDegree = circleShape.getRadius();
        if (circleDegree >= 180.0) {
            return Geoshape.geoshape((Shape)circleShape.getBoundingBox());
        }
        double radiusMeters = circle.getRadiusMeters();
        double errorDistanceMeters = this.getErrorDistanceMeters(circle);
        int numSides = CircleUtils.circleToPolygonNumSides(radiusMeters, errorDistanceMeters);
        Point center = circleShape.getCenter();
        Shape fallbackShape = this.fallbackShape(errorDistanceMeters, radiusMeters, this.boundingBoxFallback, center, circleShape.getBoundingBox());
        try {
            double[][] rawPolygon = CircleUtils.createRegularGeoShapePolygon(center.getLat(), center.getLon(), radiusMeters, numSides);
            int duplicatePoints = 0;
            ShapeFactory.PolygonBuilder builder = ctx.getShapeFactory().polygon();
            HashSet<PointImpl> addedPoints = new HashSet<PointImpl>(rawPolygon[0].length);
            for (int i = 0; i < rawPolygon[0].length; ++i) {
                PointImpl point = new PointImpl(rawPolygon[0][i], rawPolygon[1][i], ctx);
                if (!addedPoints.add(point)) {
                    ++duplicatePoints;
                }
                builder.pointXY(rawPolygon[0][i], rawPolygon[1][i]);
            }
            if (duplicatePoints < 2) {
                resultShape = builder.build();
            } else {
                if (fallbackShape == null) {
                    throw new IllegalArgumentException("Circle: " + circle.toString() + " cannot be converted to another shape following the specified error distance. The Polygon conversion logic produces " + duplicatePoints + " points which is most likely related to either small radius or increased math complexity for Polygon creation.");
                }
                resultShape = fallbackShape;
            }
        }
        catch (RuntimeException e) {
            if (fallbackShape == null) {
                if (e instanceof IllegalArgumentException) {
                    throw e;
                }
                throw new IllegalArgumentException("Circle: " + circle.toString() + " cannot be converted to another shape following the specified error distance. Reason: " + e.getMessage(), e);
            }
            resultShape = fallbackShape;
        }
        return Geoshape.geoshape((Shape)resultShape);
    }

    private Shape fallbackShape(double errorDistanceMeters, double radiusMeters, boolean boundingBoxFallback, Point center, Rectangle boundingBox) {
        if (errorDistanceMeters >= radiusMeters) {
            return center;
        }
        if (boundingBoxFallback) {
            return boundingBox;
        }
        return null;
    }
}

