/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.gremlin.server.auth;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.util.Map;
import org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential.CredentialTraversal;
import org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential.CredentialTraversalSource;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JanusGraphAbstractAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(JanusGraphAbstractAuthenticator.class);
    public static final String CONFIG_DEFAULT_USER = "defaultUsername";
    public static final String CONFIG_DEFAULT_PASSWORD = "defaultPassword";
    public static final String USERNAME_INDEX_NAME = "byUsername";
    private CredentialTraversalSource credentials;

    public boolean requireAuthentication() {
        return true;
    }

    public abstract Authenticator.SaslNegotiator newSaslNegotiator(InetAddress var1);

    public CredentialTraversalSource createCredentials(JanusGraph graph) {
        return (CredentialTraversalSource)graph.traversal(CredentialTraversalSource.class);
    }

    public JanusGraph openGraph(String conf) {
        return JanusGraphFactory.open((String)conf);
    }

    public void setup(Map<String, Object> config) {
        String defaultUser;
        logger.info("Initializing authentication with the {}", (Object)this.getClass().getName());
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (String)"Could not configure a %s - provide a 'config' in the 'authentication' settings", (Object)this.getClass().getName());
        Preconditions.checkState((boolean)config.containsKey("credentialsDb"), (String)"Credential configuration missing the %s key that points to a graph config file or graph name", (Object)"credentialsDb");
        Preconditions.checkState((boolean)config.containsKey(CONFIG_DEFAULT_USER), (String)"Credential configuration missing the %s key for the default user", (Object)CONFIG_DEFAULT_USER);
        Preconditions.checkState((boolean)config.containsKey(CONFIG_DEFAULT_PASSWORD), (String)"Credential configuration missing the %s key for the default password", (Object)CONFIG_DEFAULT_PASSWORD);
        JanusGraph graph = this.openGraph(config.get("credentialsDb").toString());
        this.credentials = this.createCredentials(graph);
        graph.tx().rollback();
        ManagementSystem mgmt = (ManagementSystem)graph.openManagement();
        if (!mgmt.containsGraphIndex(USERNAME_INDEX_NAME)) {
            PropertyKey username = mgmt.makePropertyKey("username").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            mgmt.buildIndex(USERNAME_INDEX_NAME, Vertex.class).addKey(username).unique().buildCompositeIndex();
            mgmt.commit();
            mgmt = (ManagementSystem)graph.openManagement();
            JanusGraphIndex index = mgmt.getGraphIndex(USERNAME_INDEX_NAME);
            if (!index.getIndexStatus(username).equals((Object)SchemaStatus.ENABLED)) {
                try {
                    mgmt = (ManagementSystem)graph.openManagement();
                    mgmt.updateIndex((Index)mgmt.getGraphIndex(USERNAME_INDEX_NAME), SchemaAction.REINDEX);
                    ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)USERNAME_INDEX_NAME).status(new SchemaStatus[]{SchemaStatus.ENABLED})).call();
                    mgmt.commit();
                }
                catch (InterruptedException rude) {
                    mgmt.rollback();
                    throw new RuntimeException("Timed out waiting for byUsername index to be created on credential graph", rude);
                }
            }
        }
        if (!this.userExists(defaultUser = config.get(CONFIG_DEFAULT_USER).toString())) {
            this.createUser(defaultUser, config.get(CONFIG_DEFAULT_PASSWORD).toString());
        }
    }

    protected Vertex findUser(String username) {
        Vertex v;
        this.credentials.tx().rollback();
        CredentialTraversal t = this.credentials.users(username, new String[0]);
        Vertex vertex = v = t.hasNext() ? (Vertex)t.next() : null;
        if (t.hasNext()) {
            throw new IllegalStateException(String.format("Multiple users with username %s", username));
        }
        return v;
    }

    private boolean userExists(String username) {
        return this.findUser(username) != null;
    }

    private void createUser(String username, String password) {
        this.credentials.tx().rollback();
        try {
            this.credentials.user(username, password).iterate();
            this.credentials.tx().commit();
        }
        catch (Exception ex) {
            this.credentials.tx().rollback();
            throw new RuntimeException(ex);
        }
    }
}

