/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.solr;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.janusgraph.diskstorage.solr.UncheckedSolrException;

class SolrResultIterator<E>
implements Iterator<E> {
    private final SolrClient solrClient;
    private final BlockingQueue<E> queue;
    private int count;
    private int numBatches;
    private final Long limit;
    private final int offset;
    private final int batchSize;
    private final String collection;
    private final SolrQuery solrQuery;
    private final Function<SolrDocument, E> getFieldValue;

    public SolrResultIterator(SolrClient solrClient, Integer limit, int offset, int nbDocByQuery, String collection, SolrQuery solrQuery, Function<SolrDocument, E> function) throws SolrServerException, IOException {
        this.solrClient = solrClient;
        this.count = 0;
        this.offset = offset;
        this.batchSize = nbDocByQuery;
        this.queue = new LinkedBlockingQueue();
        this.collection = collection;
        this.solrQuery = solrQuery;
        this.getFieldValue = function;
        long nbFound = solrClient.queryAndStreamResponse(collection, (SolrParams)solrQuery, new SolrCallbackHandler<E>(this, function)).getResults().getNumFound() - (long)offset;
        this.limit = limit != null ? Math.min(nbFound, (long)limit.intValue()) : nbFound;
        this.numBatches = 1;
    }

    public BlockingQueue<E> getQueue() {
        return this.queue;
    }

    @Override
    public boolean hasNext() {
        if (this.count != 0 && this.count % this.batchSize == 0 && (long)this.count < this.limit) {
            try {
                this.solrQuery.setStart(Integer.valueOf(this.numBatches * this.batchSize + this.offset));
                this.solrClient.queryAndStreamResponse(this.collection, (SolrParams)this.solrQuery, new SolrCallbackHandler<E>(this, this.getFieldValue));
                ++this.numBatches;
            }
            catch (SolrServerException e) {
                throw new UncheckedSolrException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }
        return (long)this.count < this.limit;
    }

    @Override
    public E next() {
        try {
            ++this.count;
            return this.queue.take();
        }
        catch (InterruptedException e) {
            throw new UncheckedIOException(new IOException("Interrupted waiting on queue", e));
        }
    }

    private static class SolrCallbackHandler<E>
    extends StreamingResponseCallback {
        private final SolrResultIterator<E> iterator;
        private final Function<SolrDocument, E> function;

        public SolrCallbackHandler(SolrResultIterator<E> iterator, Function<SolrDocument, E> function) {
            this.function = function;
            this.iterator = iterator;
        }

        public void streamDocListInfo(long nbFound, long start, Float aMaxScore) {
        }

        public void streamSolrDocument(SolrDocument doc) {
            this.iterator.getQueue().add(this.function.apply(doc));
        }
    }
}

