/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.extension.clearpass;

import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.validation.constraints.NotNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EncryptedMapDecorator
implements Map<String, String> {
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String SECRET_KEY_FACTORY_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final String DEFAULT_HASH_ALGORITHM = "SHA-512";
    private static final String DEFAULT_ENCRYPTION_ALGORITHM = "AES";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final Log log = LogFactory.getLog(this.getClass());
    @NotNull
    private final Map<String, String> decoratedMap;
    @NotNull
    private final MessageDigest messageDigest;
    @NotNull
    private final byte[] salt;
    @NotNull
    private final Key key;
    @NotNull
    private final String secretKeyAlgorithm;
    private boolean cloneNotSupported;
    private ConcurrentHashMap<Object, IvParameterSpec> algorithmParametersHashMap = new ConcurrentHashMap();

    public EncryptedMapDecorator(Map<String, String> decoratedMap) throws Exception {
        this(decoratedMap, EncryptedMapDecorator.getRandomSalt(8), EncryptedMapDecorator.getRandomSalt(32));
    }

    public EncryptedMapDecorator(Map<String, String> decoratedMap, String salt, String secretKey) throws Exception {
        this(decoratedMap, DEFAULT_HASH_ALGORITHM, salt, DEFAULT_ENCRYPTION_ALGORITHM, secretKey);
    }

    public EncryptedMapDecorator(Map<String, String> decoratedMap, String hashAlgorithm, String salt, String secretKeyAlgorithm, String secretKey) throws Exception {
        this(decoratedMap, hashAlgorithm, salt.getBytes(), secretKeyAlgorithm, EncryptedMapDecorator.getSecretKey(secretKeyAlgorithm, secretKey, salt));
    }

    public EncryptedMapDecorator(Map<String, String> decoratedMap, String hashAlgorithm, byte[] salt, String secretKeyAlgorithm, Key secretKey) throws NoSuchAlgorithmException {
        this.decoratedMap = decoratedMap;
        this.key = secretKey;
        this.salt = salt;
        this.secretKeyAlgorithm = secretKeyAlgorithm;
        this.messageDigest = MessageDigest.getInstance(hashAlgorithm);
    }

    private static String getRandomSalt(int size) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] bytes = new byte[size];
        secureRandom.nextBytes(bytes);
        return EncryptedMapDecorator.getFormattedText(bytes);
    }

    @Override
    public int size() {
        return this.decoratedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.decoratedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        String hashedKey = this.constructHashedKey(key.toString());
        return this.decoratedMap.containsKey(hashedKey);
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        String encryptedValue = this.encrypt((String)value);
        return this.decoratedMap.containsValue(encryptedValue);
    }

    @Override
    public String get(Object key) {
        String hashedKey = this.constructHashedKey(key == null ? null : key.toString());
        return this.decrypt(this.decoratedMap.get(hashedKey), hashedKey);
    }

    @Override
    public String put(String key, String value) {
        String hashedKey = this.constructHashedKey(key);
        String hashedValue = this.encrypt(value, hashedKey);
        String oldValue = this.decoratedMap.put(hashedKey, hashedValue);
        return this.decrypt(oldValue, hashedKey);
    }

    @Override
    public String remove(Object key) {
        String hashedKey = this.constructHashedKey(key.toString());
        return this.decrypt(this.decoratedMap.remove(hashedKey), hashedKey);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.decoratedMap.clear();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        throw new UnsupportedOperationException();
    }

    protected String constructHashedKey(String key) {
        if (key == null) {
            return null;
        }
        MessageDigest messageDigest = this.getMessageDigest();
        messageDigest.update(this.salt);
        messageDigest.update(key.getBytes());
        String hash = EncryptedMapDecorator.getFormattedText(messageDigest.digest());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Generated hash of value [%s] for key [%s].", hash, key));
        }
        return hash;
    }

    protected String decrypt(String value, String hashedKey) {
        if (value == null) {
            return null;
        }
        try {
            Cipher cipher = this.getCipherObject();
            byte[] ivByteArray = this.algorithmParametersHashMap.get(hashedKey).getIV();
            IvParameterSpec ivSpec = new IvParameterSpec(ivByteArray);
            cipher.init(2, this.key, ivSpec);
            byte[] valueByteArray = value.getBytes();
            byte[] decrypted64ByteValue = new Base64().decode(valueByteArray);
            byte[] decryptedByteArray = cipher.doFinal(decrypted64ByteValue);
            return new String(decryptedByteArray);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String encrypt(String value) {
        return this.encrypt(value, null);
    }

    protected String encrypt(String value, String hashedKey) {
        if (value == null) {
            return null;
        }
        try {
            Cipher cipher = this.getCipherObject();
            cipher.init(1, this.key);
            AlgorithmParameters params = cipher.getParameters();
            if (hashedKey != null) {
                this.algorithmParametersHashMap.put(hashedKey, params.getParameterSpec(IvParameterSpec.class));
            }
            byte[] valueByteArray = value.getBytes();
            byte[] encryptedByteArray = cipher.doFinal(valueByteArray);
            byte[] encrypted64ByteValue = new Base64().encode(encryptedByteArray);
            return new String(encrypted64ByteValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static String byte2char(byte[] bytes) throws UnsupportedEncodingException {
        return new String(bytes, "UTF-8");
    }

    protected static byte[] char2byte(String chars) throws UnsupportedEncodingException {
        return chars.getBytes("UTF-8");
    }

    protected MessageDigest getMessageDigest() {
        if (this.cloneNotSupported) {
            String algorithm = this.messageDigest.getAlgorithm();
            try {
                return MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("MessageDigest algorithm '" + algorithm + "' was supported when " + this.getClass().getSimpleName() + " was created but is not now. This should not be possible.", e);
            }
        }
        try {
            return (MessageDigest)this.messageDigest.clone();
        }
        catch (CloneNotSupportedException e) {
            this.cloneNotSupported = true;
            this.log.warn((Object)("Could not clone MessageDigest using algorithm '" + this.messageDigest.getAlgorithm() + "'. MessageDigest.getInstance will be used from now on which will be much more expensive."), (Throwable)e);
            return this.getMessageDigest();
        }
    }

    private static String getFormattedText(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
            ++n2;
        }
        return buf.toString();
    }

    private Cipher getCipherObject() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance(CIPHER_ALGORITHM);
    }

    private static Key getSecretKey(String secretKeyAlgorithm, String secretKey, String salt) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(SECRET_KEY_FACTORY_ALGORITHM);
        PBEKeySpec spec = new PBEKeySpec(secretKey.toCharArray(), EncryptedMapDecorator.char2byte(salt), 65536, 128);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), secretKeyAlgorithm);
        return secret;
    }

    public String getSecretKeyAlgorithm() {
        return this.secretKeyAlgorithm;
    }
}

