/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.extension.clearpass;

import java.util.Collection;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.jasig.cas.monitor.TicketRegistryState;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractTicketRegistry;
import org.jasig.cas.ticket.registry.TicketRegistry;

public final class TicketRegistryDecorator
extends AbstractTicketRegistry {
    @NotNull
    private final TicketRegistry ticketRegistry;
    @NotNull
    private final Map<String, String> cache;

    public TicketRegistryDecorator(TicketRegistry actualTicketRegistry, Map<String, String> cache) {
        this.ticketRegistry = actualTicketRegistry;
        this.cache = cache;
    }

    public void addTicket(Ticket ticket) {
        if (ticket instanceof TicketGrantingTicket) {
            TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)ticket;
            String ticketId = ticketGrantingTicket.getId();
            String userName = ticketGrantingTicket.getAuthentication().getPrincipal().getId();
            this.log.debug("Creating mapping ticket {} to user name {}", (Object)ticketId, (Object)userName);
            this.cache.put(ticketId, userName);
        }
        this.ticketRegistry.addTicket(ticket);
    }

    public Ticket getTicket(String ticketId) {
        return this.ticketRegistry.getTicket(ticketId);
    }

    public boolean deleteTicket(String ticketId) {
        String userName = this.cache.get(ticketId);
        if (userName != null) {
            this.log.debug("Removing mapping ticket {} for user name {}", (Object)ticketId, (Object)userName);
            this.cache.remove(userName);
        }
        return this.ticketRegistry.deleteTicket(ticketId);
    }

    public Collection<Ticket> getTickets() {
        return this.ticketRegistry.getTickets();
    }

    public int sessionCount() {
        if (this.ticketRegistry instanceof TicketRegistryState) {
            return ((TicketRegistryState)this.ticketRegistry).sessionCount();
        }
        this.log.debug("Ticket registry {} does not support report the sessionCount() operation of the registry state.", (Object)this.ticketRegistry.getClass().getName());
        return super.sessionCount();
    }

    public int serviceTicketCount() {
        if (this.ticketRegistry instanceof TicketRegistryState) {
            return ((TicketRegistryState)this.ticketRegistry).serviceTicketCount();
        }
        this.log.debug("Ticket registry {} does not support report the serviceTicketCount() operation of the registry state.", (Object)this.ticketRegistry.getClass().getName());
        return super.serviceTicketCount();
    }
}

