/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.notice;

import difflib.ChangeDelta;
import difflib.Chunk;
import difflib.DeleteDelta;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.InsertDelta;
import difflib.Patch;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jasig.maven.notice.AbstractNoticeMojo;
import org.jasig.maven.notice.util.ResourceFinder;

@Mojo(name="check", threadSafe=true, requiresDependencyCollection=ResolutionScope.TEST)
public class CheckNoticeMojo
extends AbstractNoticeMojo {
    @Override
    protected void handleNotice(ResourceFinder finder, String noticeContents) throws MojoFailureException {
        InputStreamReader existingNoticeContents;
        Log logger = this.getLog();
        File outputFile = this.getNoticeOutputFile();
        if (!outputFile.exists()) {
            throw new MojoFailureException("No NOTICE file exists at: " + outputFile);
        }
        try {
            FileInputStream outputFileInputStream = new FileInputStream(outputFile);
            existingNoticeContents = new InputStreamReader((InputStream)new BufferedInputStream(outputFileInputStream), this.encoding);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to read existing NOTICE File from: " + outputFile, (Throwable)e);
        }
        String diffText = this.generateDiff(logger, new StringReader(noticeContents), existingNoticeContents);
        if (diffText.length() != 0) {
            String buildDir = this.project.getBuild().getDirectory();
            File expectedNoticeFile = new File(new File(buildDir), "NOTICE.expected");
            try {
                FileUtils.writeStringToFile((File)expectedNoticeFile, (String)noticeContents, (String)this.encoding);
            }
            catch (IOException e) {
                logger.warn((CharSequence)("Failed to write expected NOTICE File to: " + expectedNoticeFile), (Throwable)e);
            }
            String msg = "Existing NOTICE file '" + outputFile + "' doesn't match expected NOTICE file: " + expectedNoticeFile;
            logger.error((CharSequence)(msg + "\n" + diffText));
            throw new MojoFailureException(msg);
        }
        logger.info((CharSequence)"NOTICE file is up to date");
    }

    protected String generateDiff(Log logger, Reader noticeContents, Reader existingNoticeContents) {
        StringBuilder diffText = new StringBuilder();
        try {
            List expectedLines = IOUtils.readLines((Reader)noticeContents);
            List existingLines = IOUtils.readLines((Reader)existingNoticeContents);
            Patch diff = DiffUtils.diff((List)expectedLines, (List)existingLines);
            for (Delta delta : diff.getDeltas()) {
                Chunk original = delta.getOriginal();
                Chunk revised = delta.getRevised();
                char changeType = delta instanceof DeleteDelta ? (char)'d' : (delta instanceof InsertDelta ? (char)'a' : (delta instanceof ChangeDelta ? (char)'c' : '?'));
                diffText.append(original.getPosition() + 1);
                if (original.getLines().size() > 1) {
                    diffText.append(",").append(original.getPosition() + original.getLines().size());
                }
                diffText.append(changeType);
                diffText.append(revised.getPosition() + 1);
                if (revised.getLines().size() > 1) {
                    diffText.append(",").append(revised.getPosition() + revised.getLines().size());
                }
                diffText.append("\n");
                for (Object line : original.getLines()) {
                    diffText.append("< ").append(line).append("\n");
                }
                diffText.append("---\n");
                for (Object line : revised.getLines()) {
                    diffText.append("> ").append(line).append("\n");
                }
            }
        }
        catch (IOException e) {
            logger.warn((CharSequence)"Failed to generate diff between existing and expected NOTICE files", (Throwable)e);
        }
        return diffText.toString();
    }
}

