/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.notice;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jasig.maven.notice.AbstractNoticeMojo;
import org.jasig.maven.notice.util.ResourceFinder;

@Mojo(name="generate", threadSafe=true, requiresDependencyCollection=ResolutionScope.TEST)
public class GenerateNoticeMojo
extends AbstractNoticeMojo {
    @Override
    protected void handleNotice(ResourceFinder finder, String noticeContents) throws MojoFailureException {
        File outputFile = this.getNoticeOutputFile();
        try {
            FileUtils.forceMkdir((File)outputFile.getParentFile());
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to create directory for NOTICE File: " + outputFile.getParent(), (Throwable)e);
        }
        try {
            FileUtils.writeStringToFile((File)outputFile, (String)noticeContents, (String)this.encoding);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to write NOTICE File to: " + outputFile, (Throwable)e);
        }
    }
}

