/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.notice.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jasig.maven.notice.util.CustomClassLoader;
import org.jasig.maven.notice.util.ResourceFinder;

public final class ResourceFinderImpl
implements ResourceFinder {
    private final MavenProject project;
    private CustomClassLoader compileClassPath;
    private CustomClassLoader pluginClassPath;

    public ResourceFinderImpl(MavenProject project) {
        this.project = project;
    }

    @Override
    public void setCompileClassPath(List<String> classpath) {
        this.compileClassPath = new CustomClassLoader();
        if (classpath != null) {
            for (String absolutePath : classpath) {
                this.compileClassPath.addFolder(absolutePath);
            }
        }
    }

    @Override
    public void setPluginClassPath(ClassLoader classLoader) {
        this.pluginClassPath = new CustomClassLoader(classLoader);
    }

    @Override
    public URL findResource(String resource) throws MojoFailureException {
        URL res = this.searchProjectTree(this.project, resource);
        if (res != null) {
            return res;
        }
        res = this.toURL(new File(resource));
        if (res != null) {
            return res;
        }
        String cpResource = resource.startsWith("/") ? resource.substring(1) : resource;
        res = this.compileClassPath.getResource(cpResource);
        if (res != null) {
            return res;
        }
        res = this.pluginClassPath.getResource(cpResource);
        if (res != null) {
            return res;
        }
        try {
            res = new URL(resource);
            res.openStream().close();
            return res;
        }
        catch (Exception exception) {
            throw new MojoFailureException("Resource not found in file system, classpath or URL: " + resource);
        }
    }

    private URL searchProjectTree(MavenProject project, String resource) {
        URL res = this.toURL(new File(project.getBasedir(), resource));
        if (res != null) {
            return res;
        }
        MavenProject parent = project.getParent();
        if (!project.isExecutionRoot() && parent != null && parent.getBasedir() != null) {
            return this.searchProjectTree(parent, resource);
        }
        return null;
    }

    private URL toURL(File file) {
        if (file.exists() && file.canRead()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }
}

