/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.plugin.sass;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class AbstractSassMojo
extends AbstractMojo {
    protected File sassSourceDirectory;
    protected String relativeOutputDirectory;
    protected String[] includes = new String[]{"**/scss"};
    protected String[] excludes;
    protected File buildDirectory;
    protected Map<String, String> sassOptions = new HashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)"unix_newlines", (Object)"true", (Object)"cache", (Object)"true", (Object)"always_update", (Object)"true", (Object)"style", (Object)":expanded"));

    protected void buildSassOptions(StringBuilder sassScript) throws MojoExecutionException {
        sassScript.append("require 'rubygems'\n");
        sassScript.append("require 'sass/plugin'\n");
        sassScript.append("Sass::Plugin.options.merge!(\n");
        if (!this.sassOptions.containsKey("cache_location")) {
            File sassCacheDir = this.newCanonicalFile(this.buildDirectory, "sass_cache");
            String sassCacheDirStr = sassCacheDir.toString();
            this.sassOptions.put("cache_location", "'" + this.escapePath(sassCacheDirStr) + "'");
        }
        Iterator<Map.Entry<String, String>> entryItr = this.sassOptions.entrySet().iterator();
        while (entryItr.hasNext()) {
            Map.Entry<String, String> optEntry = entryItr.next();
            String opt = optEntry.getKey();
            String value = optEntry.getValue();
            sassScript.append("    :").append(opt).append(" => ").append(value);
            if (entryItr.hasNext()) {
                sassScript.append(",");
            }
            sassScript.append("\n");
        }
        sassScript.append(")\n");
    }

    protected File newCanonicalFile(File parent, String child) throws MojoExecutionException {
        File f = new File(parent, child);
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create canonical File for: " + f, (Exception)e);
        }
    }

    protected Set<String> findSassDirs() {
        Log log = this.getLog();
        log.debug((CharSequence)("Looking in " + this.sassSourceDirectory + " for dirs that match " + Arrays.toString(this.includes) + " but not " + Arrays.toString(this.excludes)));
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setIncludes(this.includes);
        directoryScanner.setExcludes(this.excludes);
        directoryScanner.setBasedir(this.sassSourceDirectory);
        directoryScanner.scan();
        LinkedHashSet<String> sassDirectories = new LinkedHashSet<String>();
        for (String dirName : directoryScanner.getIncludedDirectories()) {
            sassDirectories.add(dirName);
        }
        return sassDirectories;
    }

    protected String escapePath(String originalPath) {
        if (originalPath == null || originalPath.isEmpty()) {
            throw new IllegalArgumentException("No path given.");
        }
        return originalPath.replace("\\", "/");
    }
}

