/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.plugin.sass;

import java.io.File;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.jasig.maven.plugin.sass.AbstractSassMojo;
import org.jasig.maven.plugin.sass.CompilationErrors;

public class UpdateStylesheetsMojo
extends AbstractSassMojo {
    private File baseOutputDirectory;
    private boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        String sassScript = this.buildSassScript();
        log.debug((CharSequence)("SASS Ruby Script:\n" + sassScript));
        log.info((CharSequence)"Compiling SASS Templates");
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine jruby = scriptEngineManager.getEngineByName("jruby");
        try {
            jruby.eval(sassScript);
            CompilationErrors compilationErrors = (CompilationErrors)jruby.getBindings(100).get("compilation_errors");
            if (compilationErrors.hasErrors()) {
                for (CompilationErrors.CompilationError error : compilationErrors) {
                    log.error((CharSequence)("Compilation of template " + error.filename + " failed: " + error.message));
                }
                if (this.failOnError) {
                    throw new MojoFailureException("SASS compilation encountered errors (see above for details).");
                }
            }
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("Failed to execute SASS ruby script:\n" + sassScript, (Exception)e);
        }
    }

    protected String buildSassScript() throws MojoExecutionException {
        Log log = this.getLog();
        StringBuilder sassScript = new StringBuilder();
        this.buildSassOptions(sassScript);
        sassScript.append("require 'java'\n");
        sassScript.append("java_import org.jasig.maven.plugin.sass.CompilationErrors\n");
        sassScript.append("$compilation_errors = CompilationErrors.new\n");
        sassScript.append("Sass::Plugin.on_compilation_error {|error, template, css| $compilation_errors.add(template, error.message) }\n");
        Set<String> sassDirectories = this.findSassDirs();
        for (String sassSubDir : sassDirectories) {
            File sassDir = this.newCanonicalFile(this.sassSourceDirectory, sassSubDir);
            File sassDestDir = this.newCanonicalFile(new File(this.baseOutputDirectory, sassSubDir), this.relativeOutputDirectory);
            String sassDirStr = this.escapePath(sassDir.toString());
            String sassDestDirStr = this.escapePath(sassDestDir.toString());
            int index = StringUtils.differenceAt((String)sassDirStr, (String)sassDestDirStr);
            log.info((CharSequence)("Queing SASS Template for compile: " + sassDirStr.substring(index) + " => " + sassDestDirStr.substring(index)));
            sassScript.append("Sass::Plugin.add_template_location('").append(sassDirStr).append("', '").append(sassDestDirStr).append("')\n");
        }
        sassScript.append("Sass::Plugin.update_stylesheets");
        return sassScript.toString();
    }
}

