/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.plugin.sass;

import java.io.File;
import java.util.LinkedList;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.jasig.maven.plugin.sass.AbstractSassMojo;

public class WatchMojo
extends AbstractSassMojo {
    private File outputDirectory;
    private String skin;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        String sassSubDir = this.findSassDir(this.skin);
        File sassDir = this.newCanonicalFile(this.sassSourceDirectory, sassSubDir);
        File sassDestDir = this.newCanonicalFile(new File(this.outputDirectory, sassSubDir), this.relativeOutputDirectory);
        String sassSourceDirStr = this.escapePath(sassDir.toString());
        String cssDestDirStr = this.escapePath(sassDestDir.toString());
        int index = StringUtils.differenceAt((String)sassSourceDirStr, (String)cssDestDirStr);
        String sassScript = this.buildSassScript(sassSourceDirStr, cssDestDirStr);
        log.debug((CharSequence)("SASS Ruby Script:\n" + sassScript));
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Started watching SASS Template: " + sassSourceDirStr + " => " + cssDestDirStr));
        } else {
            log.info((CharSequence)("Started watching SASS Template: " + sassSourceDirStr.substring(index) + " => " + cssDestDirStr.substring(index)));
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine jruby = scriptEngineManager.getEngineByName("jruby");
        try {
            jruby.eval(sassScript);
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("Failed to execute SASS Watch Script:\n" + sassScript, (Exception)e);
        }
    }

    protected String findSassDir(String skin) throws MojoFailureException {
        StringBuilder msg;
        LinkedList<String> matches = new LinkedList<String>();
        Set<String> sassDirectories = this.findSassDirs();
        for (String sassSubDir : sassDirectories) {
            if (!sassSubDir.contains(skin)) continue;
            matches.add(sassSubDir);
        }
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        if (matches.isEmpty()) {
            msg = new StringBuilder();
            msg.append("None of the SASS template directories match skin name: ").append(skin).append("\n");
            msg.append("\tSASS template directories:\n");
            for (String sassSubDir : sassDirectories) {
                msg.append("\t\t").append(sassSubDir).append("\n");
            }
            throw new MojoFailureException(msg.toString());
        }
        msg = new StringBuilder();
        msg.append("Multiple SASS template directories match skin name: ").append(skin).append("\n");
        msg.append("\tMatching SASS template directories:\n");
        for (String sassSubDir : matches) {
            msg.append("\t\t").append(sassSubDir).append("\n");
        }
        throw new MojoFailureException(msg.toString());
    }

    protected String buildSassScript(String sassSourceDir, String cssDestDir) throws MojoExecutionException {
        StringBuilder sassScript = new StringBuilder();
        this.sassOptions.put("template_location", "'" + sassSourceDir + "'");
        this.sassOptions.put("css_location", "'" + cssDestDir + "'");
        this.buildSassOptions(sassScript);
        sassScript.append("Sass::Plugin.watch");
        return sassScript.toString();
    }
}

