/*!
 * jQuery Validation Plugin v1.17.0
 *
 * https://jqueryvalidation.org/
 *
 * Copyright (c) 2017 Jörn Zaefferer
 * Released under the MIT license
 */
(function(a){if(typeof define==="function"&&define.amd){define(["jquery","./jquery.validate"],a)}else{if(typeof module==="object"&&module.exports){module.exports=a(require("jquery"))}else{a(jQuery)}}}(function(a){(function(){function b(c){return c.replace(/<.[^<>]*?>/g," ").replace(/&nbsp;|&#160;/gi," ").replace(/[.(),;:!?%#$'\"_+=\/\-“”’]*/g,"")}a.validator.addMethod("maxWords",function(d,c,e){return this.optional(c)||b(d).match(/\b\w+\b/g).length<=e},a.validator.format("Please enter {0} words or less."));a.validator.addMethod("minWords",function(d,c,e){return this.optional(c)||b(d).match(/\b\w+\b/g).length>=e},a.validator.format("Please enter at least {0} words."));a.validator.addMethod("rangeWords",function(f,c,g){var e=b(f),d=/\b\w+\b/g;return this.optional(c)||e.match(d).length>=g[0]&&e.match(d).length<=g[1]},a.validator.format("Please enter between {0} and {1} words."))}());a.validator.addMethod("accept",function(g,d,j){var h=typeof j==="string"?j.replace(/\s/g,""):"image/*",f=this.optional(d),c,b,e;if(f){return f}if(a(d).attr("type")==="file"){h=h.replace(/[\-\[\]\/\{\}\(\)\+\?\.\\\^\$\|]/g,"\\$&").replace(/,/g,"|").replace(/\/\*/g,"/.*");if(d.files&&d.files.length){e=new RegExp(".?("+h+")$","i");for(c=0;c<d.files.length;c++){b=d.files[c];if(!b.type.match(e)){return false}}}}return true},a.validator.format("Please enter a value with a valid mimetype."));a.validator.addMethod("alphanumeric",function(c,b){return this.optional(b)||/^\w+$/i.test(c)},"Letters, numbers, and underscores only please");a.validator.addMethod("bankaccountNL",function(g,d){if(this.optional(d)){return true}if(!(/^[0-9]{9}|([0-9]{2} ){3}[0-9]{3}$/.test(g))){return false}var f=g.replace(/ /g,""),e=0,b=f.length,i,c,h;for(i=0;i<b;i++){c=b-i;h=f.substring(i,i+1);e=e+c*h}return e%11===0},"Please specify a valid bank account number");a.validator.addMethod("bankorgiroaccountNL",function(c,b){return this.optional(b)||(a.validator.methods.bankaccountNL.call(this,c,b))||(a.validator.methods.giroaccountNL.call(this,c,b))},"Please specify a valid bank or giro account number");a.validator.addMethod("bic",function(c,b){return this.optional(b)||/^([A-Z]{6}[A-Z2-9][A-NP-Z1-9])(X{3}|[A-WY-Z0-9][A-Z0-9]{2})?$/.test(c.toUpperCase())},"Please specify a valid BIC code");a.validator.addMethod("cifES",function(p,l){if(this.optional(l)){return true}var g=new RegExp(/^([ABCDEFGHJKLMNPQRSUVW])(\d{7})([0-9A-J])$/gi);var f=p.substring(0,1),h=p.substring(1,8),k=p.substring(8,9),c=0,d=0,b=0,j,e,o,m;function q(i){return i%2===0}if(p.length!==9||!g.test(p)){return false}for(j=0;j<h.length;j++){e=parseInt(h[j],10);if(q(j)){e*=2;b+=e<10?e:e-9}else{d+=e}}c=d+b;o=(10-(c).toString().substr(-1)).toString();o=parseInt(o,10)>9?"0":o;m="JABCDEFGHI".substr(o,1).toString();if(f.match(/[ABEH]/)){return k===o}else{if(f.match(/[KPQS]/)){return k===m}}return k===o||k===m},"Please specify a valid CIF number.");a.validator.addMethod("cpfBR",function(g){g=g.replace(/([~!@#$%^&*()_+=`{}\[\]\-|\\:;'<>,.\/? ])+/g,"");if(g.length!==11){return false}var f=0,e,d,c,b;e=parseInt(g.substring(9,10),10);d=parseInt(g.substring(10,11),10);c=function(i,j){var h=(i*10)%11;if((h===10)||(h===11)){h=0}return(h===j)};if(g===""||g==="00000000000"||g==="11111111111"||g==="22222222222"||g==="33333333333"||g==="44444444444"||g==="55555555555"||g==="66666666666"||g==="77777777777"||g==="88888888888"||g==="99999999999"){return false}for(b=1;b<=9;b++){f=f+parseInt(g.substring(b-1,b),10)*(11-b)}if(c(f,e)){f=0;for(b=1;b<=10;b++){f=f+parseInt(g.substring(b-1,b),10)*(12-b)}return c(f,d)}return false},"Please specify a valid CPF number");a.validator.addMethod("creditcard",function(f,c){if(this.optional(c)){return"dependency-mismatch"}if(/[^0-9 \-]+/.test(f)){return false}var g=0,e=0,b=false,h,d;f=f.replace(/\D/g,"");if(f.length<13||f.length>19){return false}for(h=f.length-1;h>=0;h--){d=f.charAt(h);e=parseInt(d,10);if(b){if((e*=2)>9){e-=9}}g+=e;b=!b}return(g%10)===0},"Please enter a valid credit card number.");a.validator.addMethod("creditcardtypes",function(c,b,d){if(/[^0-9\-]+/.test(c)){return false}c=c.replace(/\D/g,"");var e=0;if(d.mastercard){e|=1}if(d.visa){e|=2}if(d.amex){e|=4}if(d.dinersclub){e|=8}if(d.enroute){e|=16}if(d.discover){e|=32}if(d.jcb){e|=64}if(d.unknown){e|=128}if(d.all){e=1|2|4|8|16|32|64|128}if(e&1&&/^(5[12345])/.test(c)){return c.length===16}if(e&2&&/^(4)/.test(c)){return c.length===16}if(e&4&&/^(3[47])/.test(c)){return c.length===15}if(e&8&&/^(3(0[012345]|[68]))/.test(c)){return c.length===14}if(e&16&&/^(2(014|149))/.test(c)){return c.length===15}if(e&32&&/^(6011)/.test(c)){return c.length===16}if(e&64&&/^(3)/.test(c)){return c.length===16}if(e&64&&/^(2131|1800)/.test(c)){return c.length===15}if(e&128){return true}return false},"Please enter a valid credit card number.");a.validator.addMethod("currency",function(g,d,h){var c=typeof h==="string",f=c?h:h[0],b=c?true:h[1],e;f=f.replace(/,/g,"");f=b?f+"]":f+"]?";e="^["+f+"([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}[0-9]{0,}(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$";e=new RegExp(e);return this.optional(d)||e.test(g)},"Please specify a valid currency");a.validator.addMethod("dateFA",function(c,b){return this.optional(b)||/^[1-4]\d{3}\/((0?[1-6]\/((3[0-1])|([1-2][0-9])|(0?[1-9])))|((1[0-2]|(0?[7-9]))\/(30|([1-2][0-9])|(0?[1-9]))))$/.test(c)},a.validator.messages.date);a.validator.addMethod("dateITA",function(f,d){var b=false,h=/^\d{1,2}\/\d{1,2}\/\d{4}$/,j,e,c,g,i;if(h.test(f)){j=f.split("/");e=parseInt(j[0],10);c=parseInt(j[1],10);g=parseInt(j[2],10);i=new Date(Date.UTC(g,c-1,e,12,0,0,0));if((i.getUTCFullYear()===g)&&(i.getUTCMonth()===c-1)&&(i.getUTCDate()===e)){b=true}else{b=false}}else{b=false}return this.optional(d)||b},a.validator.messages.date);a.validator.addMethod("dateNL",function(c,b){return this.optional(b)||/^(0?[1-9]|[12]\d|3[01])[\.\/\-](0?[1-9]|1[012])[\.\/\-]([12]\d)?(\d\d)$/.test(c)},a.validator.messages.date);a.validator.addMethod("extension",function(c,b,d){d=typeof d==="string"?d.replace(/,/g,"|"):"png|jpe?g|gif";return this.optional(b)||c.match(new RegExp("\\.("+d+")$","i"))},a.validator.format("Please enter a value with a valid extension."));a.validator.addMethod("giroaccountNL",function(c,b){return this.optional(b)||/^[0-9]{1,7}$/.test(c)},"Please specify a valid giro account number");a.validator.addMethod("iban",function(r,l){if(this.optional(l)){return true}var g=r.replace(/ /g,"").toUpperCase(),h="",m=true,t="",s="",d,f,e,q,n,b,k,j,c;var o=5;if(g.length<o){return false}d=g.substring(0,2);b={AL:"\\d{8}[\\dA-Z]{16}",AD:"\\d{8}[\\dA-Z]{12}",AT:"\\d{16}",AZ:"[\\dA-Z]{4}\\d{20}",BE:"\\d{12}",BH:"[A-Z]{4}[\\dA-Z]{14}",BA:"\\d{16}",BR:"\\d{23}[A-Z][\\dA-Z]",BG:"[A-Z]{4}\\d{6}[\\dA-Z]{8}",CR:"\\d{17}",HR:"\\d{17}",CY:"\\d{8}[\\dA-Z]{16}",CZ:"\\d{20}",DK:"\\d{14}",DO:"[A-Z]{4}\\d{20}",EE:"\\d{16}",FO:"\\d{14}",FI:"\\d{14}",FR:"\\d{10}[\\dA-Z]{11}\\d{2}",GE:"[\\dA-Z]{2}\\d{16}",DE:"\\d{18}",GI:"[A-Z]{4}[\\dA-Z]{15}",GR:"\\d{7}[\\dA-Z]{16}",GL:"\\d{14}",GT:"[\\dA-Z]{4}[\\dA-Z]{20}",HU:"\\d{24}",IS:"\\d{22}",IE:"[\\dA-Z]{4}\\d{14}",IL:"\\d{19}",IT:"[A-Z]\\d{10}[\\dA-Z]{12}",KZ:"\\d{3}[\\dA-Z]{13}",KW:"[A-Z]{4}[\\dA-Z]{22}",LV:"[A-Z]{4}[\\dA-Z]{13}",LB:"\\d{4}[\\dA-Z]{20}",LI:"\\d{5}[\\dA-Z]{12}",LT:"\\d{16}",LU:"\\d{3}[\\dA-Z]{13}",MK:"\\d{3}[\\dA-Z]{10}\\d{2}",MT:"[A-Z]{4}\\d{5}[\\dA-Z]{18}",MR:"\\d{23}",MU:"[A-Z]{4}\\d{19}[A-Z]{3}",MC:"\\d{10}[\\dA-Z]{11}\\d{2}",MD:"[\\dA-Z]{2}\\d{18}",ME:"\\d{18}",NL:"[A-Z]{4}\\d{10}",NO:"\\d{11}",PK:"[\\dA-Z]{4}\\d{16}",PS:"[\\dA-Z]{4}\\d{21}",PL:"\\d{24}",PT:"\\d{21}",RO:"[A-Z]{4}[\\dA-Z]{16}",SM:"[A-Z]\\d{10}[\\dA-Z]{12}",SA:"\\d{2}[\\dA-Z]{18}",RS:"\\d{18}",SK:"\\d{20}",SI:"\\d{15}",ES:"\\d{20}",SE:"\\d{20}",CH:"\\d{5}[\\dA-Z]{12}",TN:"\\d{20}",TR:"\\d{5}[\\dA-Z]{17}",AE:"\\d{3}\\d{16}",GB:"[A-Z]{4}\\d{14}",VG:"[\\dA-Z]{4}\\d{16}"};n=b[d];if(typeof n!=="undefined"){k=new RegExp("^[A-Z]{2}\\d{2}"+n+"$","");if(!(k.test(g))){return false}}f=g.substring(4,g.length)+g.substring(0,4);for(j=0;j<f.length;j++){e=f.charAt(j);if(e!=="0"){m=false}if(!m){h+="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(e)}}for(c=0;c<h.length;c++){q=h.charAt(c);s=""+t+""+q;t=s%97}return t===1},"Please specify a valid IBAN");a.validator.addMethod("integer",function(c,b){return this.optional(b)||/^-?\d+$/.test(c)},"A positive or negative non-decimal number please");a.validator.addMethod("ipv4",function(c,b){return this.optional(b)||/^(25[0-5]|2[0-4]\d|[01]?\d\d?)\.(25[0-5]|2[0-4]\d|[01]?\d\d?)\.(25[0-5]|2[0-4]\d|[01]?\d\d?)\.(25[0-5]|2[0-4]\d|[01]?\d\d?)$/i.test(c)},"Please enter a valid IP v4 address.");a.validator.addMethod("ipv6",function(c,b){return this.optional(b)||/^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(c)},"Please enter a valid IP v6 address.");a.validator.addMethod("lettersonly",function(c,b){return this.optional(b)||/^[a-z]+$/i.test(c)},"Letters only please");a.validator.addMethod("letterswithbasicpunc",function(c,b){return this.optional(b)||/^[a-z\-.,()'"\s]+$/i.test(c)},"Letters or punctuation only please");a.validator.addMethod("mobileNL",function(c,b){return this.optional(b)||/^((\+|00(\s|\s?\-\s?)?)31(\s|\s?\-\s?)?(\(0\)[\-\s]?)?|0)6((\s|\s?\-\s?)?[0-9]){8}$/.test(c)
},"Please specify a valid mobile number");a.validator.addMethod("mobileUK",function(b,c){b=b.replace(/\(|\)|\s+|-/g,"");return this.optional(c)||b.length>9&&b.match(/^(?:(?:(?:00\s?|\+)44\s?|0)7(?:[1345789]\d{2}|624)\s?\d{3}\s?\d{3})$/)},"Please specify a valid mobile number");a.validator.addMethod("netmask",function(c,b){return this.optional(b)||/^(254|252|248|240|224|192|128)\.0\.0\.0|255\.(254|252|248|240|224|192|128|0)\.0\.0|255\.255\.(254|252|248|240|224|192|128|0)\.0|255\.255\.255\.(254|252|248|240|224|192|128|0)/i.test(c)},"Please enter a valid netmask.");a.validator.addMethod("nieES",function(g,c){if(this.optional(c)){return true}var f=new RegExp(/^[MXYZ]{1}[0-9]{7,8}[TRWAGMYFPDXBNJZSQVHLCKET]{1}$/gi);var b="TRWAGMYFPDXBNJZSQVHLCKET",e=g.substr(g.length-1).toUpperCase(),d;g=g.toString().toUpperCase();if(g.length>10||g.length<9||!f.test(g)){return false}g=g.replace(/^[X]/,"0").replace(/^[Y]/,"1").replace(/^[Z]/,"2");d=g.length===9?g.substr(0,8):g.substr(0,9);return b.charAt(parseInt(d,10)%23)===e},"Please specify a valid NIE number.");a.validator.addMethod("nifES",function(c,b){if(this.optional(b)){return true}c=c.toUpperCase();if(!c.match("((^[A-Z]{1}[0-9]{7}[A-Z0-9]{1}$|^[T]{1}[A-Z0-9]{8}$)|^[0-9]{8}[A-Z]{1}$)")){return false}if(/^[0-9]{8}[A-Z]{1}$/.test(c)){return("TRWAGMYFPDXBNJZSQVHLCKE".charAt(c.substring(8,0)%23)===c.charAt(8))}if(/^[KLM]{1}/.test(c)){return(c[8]==="TRWAGMYFPDXBNJZSQVHLCKE".charAt(c.substring(8,1)%23))}return false},"Please specify a valid NIF number.");a.validator.addMethod("nipPL",function(f){f=f.replace(/[^0-9]/g,"");if(f.length!==10){return false}var e=[6,5,7,2,3,4,5,6,7];var b=0;for(var c=0;c<9;c++){b+=e[c]*f[c]}var g=b%11;var d=(g===10)?0:g;return(d===parseInt(f[9],10))},"Please specify a valid NIP number.");a.validator.addMethod("notEqualTo",function(c,b,d){return this.optional(b)||!a.validator.methods.equalTo.call(this,c,b,d)},"Please enter a different value, values must not be the same.");a.validator.addMethod("nowhitespace",function(c,b){return this.optional(b)||/^\S+$/i.test(c)},"No white space please");a.validator.addMethod("pattern",function(c,b,d){if(this.optional(b)){return true}if(typeof d==="string"){d=new RegExp("^(?:"+d+")$")}return d.test(c)},"Invalid format.");a.validator.addMethod("phoneNL",function(c,b){return this.optional(b)||/^((\+|00(\s|\s?\-\s?)?)31(\s|\s?\-\s?)?(\(0\)[\-\s]?)?|0)[1-9]((\s|\s?\-\s?)?[0-9]){8}$/.test(c)},"Please specify a valid phone number.");a.validator.addMethod("phonesUK",function(b,c){b=b.replace(/\(|\)|\s+|-/g,"");return this.optional(c)||b.length>9&&b.match(/^(?:(?:(?:00\s?|\+)44\s?|0)(?:1\d{8,9}|[23]\d{9}|7(?:[1345789]\d{8}|624\d{6})))$/)},"Please specify a valid uk phone number");a.validator.addMethod("phoneUK",function(b,c){b=b.replace(/\(|\)|\s+|-/g,"");return this.optional(c)||b.length>9&&b.match(/^(?:(?:(?:00\s?|\+)44\s?)|(?:\(?0))(?:\d{2}\)?\s?\d{4}\s?\d{4}|\d{3}\)?\s?\d{3}\s?\d{3,4}|\d{4}\)?\s?(?:\d{5}|\d{3}\s?\d{3})|\d{5}\)?\s?\d{4,5})$/)},"Please specify a valid phone number");a.validator.addMethod("phoneUS",function(b,c){b=b.replace(/\s+/g,"");return this.optional(c)||b.length>9&&b.match(/^(\+?1-?)?(\([2-9]([02-9]\d|1[02-9])\)|[2-9]([02-9]\d|1[02-9]))-?[2-9]([02-9]\d|1[02-9])-?\d{4}$/)},"Please specify a valid phone number");a.validator.addMethod("postalcodeBR",function(c,b){return this.optional(b)||/^\d{2}.\d{3}-\d{3}?$|^\d{5}-?\d{3}?$/.test(c)},"Informe um CEP válido.");a.validator.addMethod("postalCodeCA",function(c,b){return this.optional(b)||/^[ABCEGHJKLMNPRSTVXY]\d[ABCEGHJKLMNPRSTVWXYZ] *\d[ABCEGHJKLMNPRSTVWXYZ]\d$/i.test(c)},"Please specify a valid postal code");a.validator.addMethod("postalcodeIT",function(c,b){return this.optional(b)||/^\d{5}$/.test(c)},"Please specify a valid postal code");a.validator.addMethod("postalcodeNL",function(c,b){return this.optional(b)||/^[1-9][0-9]{3}\s?[a-zA-Z]{2}$/.test(c)},"Please specify a valid postal code");a.validator.addMethod("postcodeUK",function(c,b){return this.optional(b)||/^((([A-PR-UWYZ][0-9])|([A-PR-UWYZ][0-9][0-9])|([A-PR-UWYZ][A-HK-Y][0-9])|([A-PR-UWYZ][A-HK-Y][0-9][0-9])|([A-PR-UWYZ][0-9][A-HJKSTUW])|([A-PR-UWYZ][A-HK-Y][0-9][ABEHMNPRVWXY]))\s?([0-9][ABD-HJLNP-UW-Z]{2})|(GIR)\s?(0AA))$/i.test(c)},"Please specify a valid UK postcode");a.validator.addMethod("require_from_group",function(f,e,c){var b=a(c[1],e.form),h=b.eq(0),d=h.data("valid_req_grp")?h.data("valid_req_grp"):a.extend({},this),g=b.filter(function(){return d.elementValue(this)}).length>=c[0];h.data("valid_req_grp",d);if(!a(e).data("being_validated")){b.data("being_validated",true);b.each(function(){d.element(this)});b.data("being_validated",false)}return g},a.validator.format("Please fill at least {0} of these fields."));a.validator.addMethod("skip_or_fill_minimum",function(f,e,c){var b=a(c[1],e.form),i=b.eq(0),d=i.data("valid_skip")?i.data("valid_skip"):a.extend({},this),h=b.filter(function(){return d.elementValue(this)}).length,g=h===0||h>=c[0];i.data("valid_skip",d);if(!a(e).data("being_validated")){b.data("being_validated",true);b.each(function(){d.element(this)});b.data("being_validated",false)}return g},a.validator.format("Please either skip these fields or fill at least {0} of them."));a.validator.addMethod("stateUS",function(h,e,d){var g=typeof d==="undefined",b=(g||typeof d.caseSensitive==="undefined")?false:d.caseSensitive,i=(g||typeof d.includeTerritories==="undefined")?false:d.includeTerritories,c=(g||typeof d.includeMilitary==="undefined")?false:d.includeMilitary,f;if(!i&&!c){f="^(A[KLRZ]|C[AOT]|D[CE]|FL|GA|HI|I[ADLN]|K[SY]|LA|M[ADEINOST]|N[CDEHJMVY]|O[HKR]|PA|RI|S[CD]|T[NX]|UT|V[AT]|W[AIVY])$"}else{if(i&&c){f="^(A[AEKLPRSZ]|C[AOT]|D[CE]|FL|G[AU]|HI|I[ADLN]|K[SY]|LA|M[ADEINOPST]|N[CDEHJMVY]|O[HKR]|P[AR]|RI|S[CD]|T[NX]|UT|V[AIT]|W[AIVY])$"}else{if(i){f="^(A[KLRSZ]|C[AOT]|D[CE]|FL|G[AU]|HI|I[ADLN]|K[SY]|LA|M[ADEINOPST]|N[CDEHJMVY]|O[HKR]|P[AR]|RI|S[CD]|T[NX]|UT|V[AIT]|W[AIVY])$"}else{f="^(A[AEKLPRZ]|C[AOT]|D[CE]|FL|GA|HI|I[ADLN]|K[SY]|LA|M[ADEINOST]|N[CDEHJMVY]|O[HKR]|PA|RI|S[CD]|T[NX]|UT|V[AT]|W[AIVY])$"}}}f=b?new RegExp(f):new RegExp(f,"i");return this.optional(e)||f.test(h)},"Please specify a valid state");a.validator.addMethod("strippedminlength",function(c,b,d){return a(c).text().length>=d},a.validator.format("Please enter at least {0} characters"));a.validator.addMethod("time",function(c,b){return this.optional(b)||/^([01]\d|2[0-3]|[0-9])(:[0-5]\d){1,2}$/.test(c)},"Please enter a valid time, between 00:00 and 23:59");a.validator.addMethod("time12h",function(c,b){return this.optional(b)||/^((0?[1-9]|1[012])(:[0-5]\d){1,2}(\ ?[AP]M))$/i.test(c)},"Please enter a valid time in 12-hour am/pm format");a.validator.addMethod("url2",function(c,b){return this.optional(b)||/^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)*(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(c)},a.validator.messages.url);a.validator.addMethod("vinUS",function(p){if(p.length!==17){return false}var e=["A","B","C","D","E","F","G","H","J","K","L","M","N","P","R","S","T","U","V","W","X","Y","Z"],o=[1,2,3,4,5,6,7,8,1,2,3,4,5,7,9,2,3,4,5,6,7,8,9],g=[8,7,6,5,4,3,2,10,0,9,8,7,6,5,4,3,2],h=0,j,c,m,k,b,l;for(j=0;j<17;j++){k=g[j];m=p.slice(j,j+1);if(j===8){l=m}if(!isNaN(m)){m*=k}else{for(c=0;c<e.length;c++){if(m.toUpperCase()===e[c]){m=o[c];m*=k;if(isNaN(l)&&c===8){l=e[c]}break}}}h+=m}b=h%11;if(b===10){b="X"}if(b===l){return true}return false},"The specified vehicle identification number (VIN) is invalid.");a.validator.addMethod("zipcodeUS",function(c,b){return this.optional(b)||/^\d{5}(-\d{4})?$/.test(c)},"The specified US ZIP Code is invalid");a.validator.addMethod("ziprange",function(c,b){return this.optional(b)||/^90[2-5]\d\{2\}-\d{4}$/.test(c)},"Your ZIP-code must be in the range 902xx-xxxx to 905xx-xxxx");return a}));