/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resource.aggr.mojo;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.jasig.resource.aggr.AggregationRequest;
import org.jasig.resource.aggr.ResourcesAggregator;
import org.jasig.resource.aggr.ResourcesAggregatorImpl;
import org.jasig.resource.aggr.mojo.CommonsLogToMavenLog;

public abstract class AbstractSkinResourcesAggregatorMojo
extends AbstractMojo {
    protected int cssLineBreakColumnNumber = 10000;
    protected boolean disableJsOptimizations = false;
    protected boolean displayJsWarnings = true;
    protected int jsLineBreakColumnNumber = 10000;
    protected boolean obfuscateJs = true;
    protected boolean preserveAllSemiColons = true;
    protected String digestAlgorithm = "MD5";
    protected String encoding;
    protected File baseOutputDirectory;
    protected String sharedJavaScriptDirectory;
    protected boolean useGeneratedSources = false;

    protected ResourcesAggregator createResourcesAggregator() {
        Log log = this.getLog();
        CommonsLogToMavenLog logWrapper = new CommonsLogToMavenLog(log);
        ResourcesAggregatorImpl aggr = new ResourcesAggregatorImpl((org.apache.commons.logging.Log)logWrapper, this.encoding);
        aggr.setCssLineBreakColumnNumber(this.cssLineBreakColumnNumber);
        aggr.setDisableJsOptimizations(this.disableJsOptimizations);
        aggr.setDisplayJsWarnings(this.displayJsWarnings);
        aggr.setJsLineBreakColumnNumber(this.jsLineBreakColumnNumber);
        aggr.setObfuscateJs(this.obfuscateJs);
        aggr.setPreserveAllSemiColons(this.preserveAllSemiColons);
        aggr.setDigestAlgorithm(this.digestAlgorithm);
        return aggr;
    }

    protected void doAggregation(ResourcesAggregator aggr, File skinConfigurationFile, File skinOutputDirectory) throws IOException {
        Log log = this.getLog();
        AggregationRequest aggregationRequest = new AggregationRequest();
        aggregationRequest.setResourcesXml(skinConfigurationFile).setOutputBaseDirectory(skinOutputDirectory);
        if (this.sharedJavaScriptDirectory != null) {
            File fullSharedJavaScriptDirectory = new File(this.baseOutputDirectory, this.sharedJavaScriptDirectory);
            aggregationRequest.setSharedJavaScriptDirectory(fullSharedJavaScriptDirectory);
        }
        if (this.useGeneratedSources) {
            aggregationRequest.addAdditionalSourceDirectory(skinOutputDirectory);
        }
        log.debug((CharSequence)("Aggregating: " + aggregationRequest));
        aggr.aggregate(aggregationRequest);
    }
}

