/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.saml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.jasig.portal.security.provider.saml.SAMLDelegatedAuthenticationService;
import org.jasig.portal.security.provider.saml.SAMLSession;

public final class HttpRequestPostprocessor
implements HttpResponseInterceptor {
    private SAMLSession samlSession;
    private static SAMLDelegatedAuthenticationService samlService = new SAMLDelegatedAuthenticationService();

    public HttpRequestPostprocessor(SAMLSession samlSession) {
        this.samlSession = samlSession;
    }

    public void process(HttpResponse res, HttpContext ctx) throws HttpException, IOException {
        Header[] contentTypes;
        for (Header contentType : contentTypes = res.getHeaders("Content-Type")) {
            Header[] headers;
            if (!contentType.getValue().equals("application/vnd.paos+xml")) continue;
            HttpEntity entity = res.getEntity();
            int contentLength = (int)entity.getContentLength();
            ByteArrayOutputStream os = new ByteArrayOutputStream(contentLength);
            entity.writeTo((OutputStream)os);
            os.close();
            byte[] paosBytes = os.toByteArray();
            HttpResponse authnResponse = samlService.authenticate(this.samlSession, paosBytes);
            for (Header header : headers = res.getAllHeaders()) {
                res.removeHeader(header);
            }
            for (Header header : headers = authnResponse.getAllHeaders()) {
                res.addHeader(header);
            }
            res.setEntity(authnResponse.getEntity());
            res.setStatusLine(authnResponse.getStatusLine());
            res.setLocale(authnResponse.getLocale());
            break;
        }
    }
}

