/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.saml;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.jasig.portal.security.provider.saml.SAMLSession;
import org.jasig.portal.security.provider.saml.SSLSecurityImpl;
import org.jasig.portal.security.provider.saml.SSLSecurityWrapper;

public class Resource {
    private String resourceUrl = "";
    private String resource = "";
    private SSLSecurityWrapper wspSSL = new SSLSecurityImpl();

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public void setWSPClientPrivateKeyAndCert(String pkFile, String certFile) {
        this.wspSSL.setSSLClientPrivateKeyAndCert(pkFile, certFile);
    }

    public void setWSPClientKeystore(String ks, String pass) {
        this.wspSSL.setSSLClientKeystore(ks, pass);
    }

    public void setWSPClientTrustStore(String ks, String pass) {
        this.wspSSL.setSSLTrustStore(ks, pass);
    }

    public SSLSocketFactory getWSPSocketFactory() {
        return this.wspSSL.getSSLSocketFactory();
    }

    public void setupWSPClientConnection(SAMLSession samlSession) throws MalformedURLException {
        URL url = new URL(this.resourceUrl);
        String protocol = url.getProtocol();
        int port = url.getPort();
        if (protocol.equalsIgnoreCase("https")) {
            SSLSocketFactory socketFactory = this.getWSPSocketFactory();
            if (port == -1) {
                port = 443;
            }
            Scheme sch = new Scheme(protocol, (SocketFactory)socketFactory, port);
            samlSession.getHttpClient().getConnectionManager().getSchemeRegistry().unregister(protocol);
            samlSession.getHttpClient().getConnectionManager().getSchemeRegistry().register(sch);
        }
    }
}

