/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.xerces.parsers.DOMParser;
import org.jasig.portal.security.provider.saml.AssertionIdpResolverImpl;
import org.jasig.portal.security.provider.saml.DelegatedAuthenticationRuntimeException;
import org.jasig.portal.security.provider.saml.DelegatedSAMLAuthenticationState;
import org.jasig.portal.security.provider.saml.Resource;
import org.jasig.portal.security.provider.saml.SAMLNamespaceContext;
import org.jasig.portal.security.provider.saml.SAMLSession;
import org.jasig.portal.security.provider.saml.XPathExpressionExecutor;
import org.jasig.portal.security.provider.saml.XPathExpressionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAMLDelegatedAuthenticationService {
    private static final SAMLNamespaceContext NAMESPACE_CONTEXT = new SAMLNamespaceContext();
    private static final XPathExpressionExecutor EXPRESSION_POOL = new XPathExpressionPool(NAMESPACE_CONTEXT);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DOMImplementationLS domLoadSaveImpl = null;
    private static final String SOAP_PREFIX = "soap";

    public SAMLDelegatedAuthenticationService() {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            this.domLoadSaveImpl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        }
        catch (ClassCastException ex) {
            this.logger.error("Unable to initialize XML serializer implementation.  Make sure that the correct jar files are present.", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            this.logger.error("Unable to initialize XML serializer implementation.  Make sure that the correct jar files are present.", (Throwable)ex);
        }
        catch (InstantiationException ex) {
            this.logger.error("Unable to initialize XML serializer implementation.  Make sure that the correct jar files are present.", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            this.logger.error("Unable to initialize XML serializer implementation.  Make sure that the correct jar files are present.", (Throwable)ex);
        }
    }

    public HttpResponse authenticate(SAMLSession samlSession, Resource resource) {
        if (samlSession.getSamlAssertion() == null) {
            String message = "SAML assertion not present.";
            this.logger.error(message);
            throw new DelegatedAuthenticationRuntimeException(message);
        }
        if (samlSession.getPortalEntityID() == null) {
            String message = "Portal entity ID not present.";
            this.logger.error(message);
            throw new DelegatedAuthenticationRuntimeException(message);
        }
        DelegatedSAMLAuthenticationState authnState = new DelegatedSAMLAuthenticationState();
        if (this.getSOAPRequest(samlSession, resource, authnState)) {
            return this.authenticate(samlSession, authnState);
        }
        return null;
    }

    public HttpResponse authenticate(SAMLSession samlSession, byte[] paosBytes) {
        if (samlSession.getSamlAssertion() == null) {
            String message = "SAML assertion not present.";
            this.logger.error(message);
            throw new DelegatedAuthenticationRuntimeException(message);
        }
        if (samlSession.getPortalEntityID() == null) {
            String message = "Portal entity ID not present.";
            this.logger.error(message);
            throw new DelegatedAuthenticationRuntimeException(message);
        }
        DelegatedSAMLAuthenticationState authnState = new DelegatedSAMLAuthenticationState();
        authnState.setSoapRequest(paosBytes);
        return this.authenticate(samlSession, authnState);
    }

    private HttpResponse authenticate(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        if (this.getIDP(samlSession, authnState) && this.validateIDP(samlSession, authnState) && this.processSOAPRequest(samlSession, authnState) && this.getSOAPResponse(samlSession, authnState) && this.processSOAPResponse(samlSession, authnState)) {
            HttpResponse response = this.sendSOAPResponse(samlSession, authnState);
            return response;
        }
        return null;
    }

    private boolean getSOAPRequest(SAMLSession samlSession, Resource resource, DelegatedSAMLAuthenticationState authnState) {
        this.logger.debug("getSOAPRequest from {}", (Object)resource.getResourceUrl());
        HttpGet method = new HttpGet(resource.getResourceUrl());
        try {
            resource.setupWSPClientConnection(samlSession);
            HttpResponse response = samlSession.getHttpClient().execute((HttpUriRequest)method);
            HttpEntity entity = response.getEntity();
            long contentLength = entity.getContentLength();
            ByteArrayOutputStream os = new ByteArrayOutputStream((int)contentLength);
            entity.writeTo((OutputStream)os);
            os.close();
            byte[] paosBytes = os.toByteArray();
            authnState.setSoapRequest(paosBytes);
        }
        catch (Exception ex) {
            this.logger.error("Exception caught when trying to retrieve the resource.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught when trying to retrieve the resource.", ex);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateIDP(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        this.logger.debug("Step 2 of 5: Validate against SOAP request");
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(authnState.getSoapRequest());
            InputSource source = new InputSource(is);
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.parse(source);
            Document doc = parser.getDocument();
            if (samlSession.isSkipValidateIdp()) {
                this.logger.debug("skipValidateIdp is set to true, setting soap request DOM");
                authnState.setSoapRequestDom(doc);
                boolean bl = true;
                return bl;
            }
            String expression = "/S:Envelope/S:Header/ecp:Request/samlp:IDPList/samlp:IDPEntry[@ProviderID='" + authnState.getIdp() + "']";
            NodeList nodes = (NodeList)EXPRESSION_POOL.evaluate(expression, doc, XPathConstants.NODESET);
            if (nodes.getLength() > 0) {
                this.logger.debug("Found matching IDP using expression {}", (Object)expression);
                authnState.setSoapRequestDom(doc);
                boolean bl = true;
                return bl;
            }
            this.logger.debug("No matching IDP found using expression {}", (Object)expression);
            return false;
        }
        catch (XPathExpressionException ex) {
            this.logger.error("Programming error.  Invalid XPath expression.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Programming error.  Invalid XPath expression.", ex);
        }
        catch (SAXException ex) {
            this.logger.error("XML error.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("XML error.", ex);
        }
        catch (IOException ex) {
            this.logger.error("Unexpected error.  This method performs no I/O!", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Unexpected error.  This method performs no I/O!", ex);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private boolean getIDP(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        this.logger.debug("Step 1 of 5: get IDP from SAML Assertion");
        InputStream is = null;
        try {
            String expression;
            Node node;
            if (samlSession.getSamlAssertionDom() == null) {
                is = new ByteArrayInputStream(samlSession.getSamlAssertion().getBytes());
                InputSource source = new InputSource(is);
                DOMParser parser = new DOMParser();
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                parser.parse(source);
                Document doc = parser.getDocument();
                samlSession.setSamlAssertionDom(doc);
            }
            if ((node = (Node)EXPRESSION_POOL.evaluate(expression = "/saml2:Assertion/saml2:Issuer", samlSession.getSamlAssertionDom(), XPathConstants.NODE)) != null) {
                String idp = node.getTextContent();
                this.logger.debug("Found IDP {} using expression {}", (Object)idp, (Object)expression);
                authnState.setIdp(idp);
                if (samlSession.getIdpResolver() == null) {
                    samlSession.setIdpResolver(new AssertionIdpResolverImpl(EXPRESSION_POOL));
                }
                samlSession.getIdpResolver().resolve(samlSession, authnState);
                boolean bl = true;
                return bl;
            }
            this.logger.debug("No IDP found using expression {}", (Object)expression);
        }
        catch (XPathExpressionException ex) {
            this.logger.error("Programming error.  Invalid XPath expression.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Programming error.  Invalid XPath expression.", ex);
        }
        catch (SAXException ex) {
            this.logger.error("XML error.", (Throwable)ex);
            this.logger.trace("XML parsing error when parsing the SAML assertion.  The assertion was: [" + samlSession.getSamlAssertion() + "].");
            throw new DelegatedAuthenticationRuntimeException("XML error.", ex);
        }
        catch (IOException ex) {
            this.logger.error("Unexpected error.  This method performs no I/O!", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Unexpected error.  This method performs no I/O!", ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        return false;
    }

    private boolean processSOAPRequest(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        this.logger.debug("Step 3 of 5: Process SOAP Request");
        try {
            String expression = "/S:Envelope/S:Header/paos:Request";
            Document dom = authnState.getSoapRequestDom();
            Node node = (Node)EXPRESSION_POOL.evaluate(expression, dom, XPathConstants.NODE);
            if (node != null) {
                String responseConsumerURL = node.getAttributes().getNamedItem("responseConsumerURL").getTextContent();
                this.logger.debug("Loaded response consumer URL {}", (Object)responseConsumerURL);
                authnState.setResponseConsumerURL(responseConsumerURL);
                Node paosMessageID = node.getAttributes().getNamedItem("messageID");
                if (paosMessageID != null) {
                    authnState.setPaosMessageID(paosMessageID.getTextContent());
                } else {
                    authnState.setPaosMessageID(null);
                }
                node.getParentNode().removeChild(node);
                expression = "/S:Envelope/S:Header/ecp:RelayState";
                node = (Node)EXPRESSION_POOL.evaluate(expression, dom, XPathConstants.NODE);
                Element relayStateElement = (Element)node;
                authnState.setRelayStateElement(relayStateElement);
                node.getParentNode().removeChild(node);
                expression = "/S:Envelope/S:Header/ecp:Request";
                node = (Node)EXPRESSION_POOL.evaluate(expression, dom, XPathConstants.NODE);
                node.getParentNode().removeChild(node);
                expression = "/S:Envelope/S:Header";
                Element soapHeader = (Element)EXPRESSION_POOL.evaluate(expression, dom, XPathConstants.NODE);
                Element newElement = dom.createElementNS(NAMESPACE_CONTEXT.getNamespaceURI("sbf"), "sbf:Framework");
                newElement.setAttribute("version", "2.0");
                soapHeader.appendChild(newElement);
                newElement = dom.createElementNS(NAMESPACE_CONTEXT.getNamespaceURI("sb"), "sb:Sender");
                newElement.setAttribute("providerID", samlSession.getPortalEntityID());
                soapHeader.appendChild(newElement);
                newElement = dom.createElementNS(NAMESPACE_CONTEXT.getNamespaceURI("wsa"), "wsa:MessageID");
                String messageID = this.generateMessageID();
                newElement.setTextContent(messageID);
                soapHeader.appendChild(newElement);
                newElement = dom.createElementNS(NAMESPACE_CONTEXT.getNamespaceURI("wsa"), "wsa:Action");
                newElement.setTextContent("urn:liberty:ssos:2006-08:AuthnRequest");
                soapHeader.appendChild(newElement);
                Element securityElement = dom.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
                securityElement.setAttribute("S:mustUnderstand", "1");
                Element createdElement = dom.createElement("wsu:Created");
                TimeZone zuluTimeZone = TimeZone.getTimeZone("Zulu");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
                sdf.setTimeZone(zuluTimeZone);
                createdElement.setTextContent(sdf.format(new Date()));
                newElement = dom.createElementNS("http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
                newElement.appendChild(createdElement);
                securityElement.appendChild(newElement);
                Node samlAssertionNode = dom.importNode(samlSession.getSamlAssertionDom().getDocumentElement(), true);
                securityElement.appendChild(samlAssertionNode);
                soapHeader.appendChild(securityElement);
                String modifiedSOAPRequest = this.writeDomToString(dom);
                authnState.setModifiedSOAPRequest(modifiedSOAPRequest);
                this.logger.debug("Completed processing of SOAP request");
                return true;
            }
            this.logger.debug("Failed to process SOAP request using expression {}", (Object)expression);
        }
        catch (XPathExpressionException ex) {
            this.logger.error("Programming error.  Invalid XPath expression.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Programming error.  Invalid XPath expression.", ex);
        }
        return false;
    }

    private String generateMessageID() {
        UUID uuid = UUID.randomUUID();
        String messageID = "urn:uuid:" + uuid.toString();
        return messageID;
    }

    private boolean getSOAPResponse(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        this.logger.debug("Step 4 of 5: Get SOAP response from IDP");
        String result = null;
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        params.setParameter("SOAPAction", (Object)"urn:liberty:ssos:2006-08:AuthnRequest");
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        try {
            this.logger.debug("Getting SOAP response from {} with POST body:\n{}", (Object)authnState.getIdpEndpoint(), (Object)authnState.getModifiedSOAPRequest());
            this.setupIdPClientConnection((HttpClient)client, samlSession, authnState);
            HttpPost method = new HttpPost(authnState.getIdpEndpoint());
            StringEntity postData = new StringEntity(authnState.getModifiedSOAPRequest(), "UTF-8");
            method.setEntity((HttpEntity)postData);
            HttpResponse httpResponse = client.execute((HttpUriRequest)method);
            int resultCode = httpResponse.getStatusLine().getStatusCode();
            if (resultCode >= 200 && resultCode < 300) {
                HttpEntity httpEntity = httpResponse.getEntity();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                httpEntity.writeTo((OutputStream)output);
                result = output.toString();
                this.logger.debug("Got SOAP response:\n{}", (Object)result);
                authnState.setSoapResponse(result);
                boolean bl = true;
                return bl;
            }
            try {
                this.logger.error("Unsupported HTTP result code when retrieving the resource: " + resultCode + ".");
                throw new DelegatedAuthenticationRuntimeException("Unsupported HTTP result code when retrieving the resource: " + resultCode + ".");
            }
            catch (Exception ex) {
                this.logger.error("Exception caught when trying to retrieve the resource.", (Throwable)ex);
                throw new DelegatedAuthenticationRuntimeException("Exception caught when trying to retrieve the resource.", ex);
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private boolean processSOAPResponse(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        this.logger.debug("Step 5 of 5: Processing SOAP response");
        try {
            String expression = "/soap:Envelope/soap:Header/ecp:Response";
            ByteArrayInputStream is = new ByteArrayInputStream(authnState.getSoapResponse().getBytes());
            InputSource source = new InputSource(is);
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.parse(source);
            Document doc = parser.getDocument();
            Node node = (Node)EXPRESSION_POOL.evaluate(expression, doc, XPathConstants.NODE);
            if (node != null) {
                String responseConsumerURL = node.getAttributes().getNamedItem("AssertionConsumerServiceURL").getTextContent();
                this.logger.debug("Found {} node found in SOAP response.", (Object)expression);
                if (responseConsumerURL != null && responseConsumerURL.equals(authnState.getResponseConsumerURL())) {
                    this.logger.debug("responseConsumerURL {} matches {}", (Object)responseConsumerURL, (Object)authnState.getResponseConsumerURL());
                    String soapPrefix = node.getParentNode().getPrefix();
                    Element ecpResponse = (Element)node;
                    Element soapHeader = (Element)ecpResponse.getParentNode();
                    this.removeAllChildren(soapHeader);
                    Element paosResponse = doc.createElementNS("urn:liberty:paos:2003-08", "paos:Response");
                    paosResponse.setAttribute(soapPrefix + ":mustUnderstand", "1");
                    paosResponse.setAttribute(soapPrefix + ":actor", "http://schemas.xmlsoap.org/soap/actor/next");
                    if (authnState.getPaosMessageID() != null) {
                        paosResponse.setAttribute("refToMessageID", authnState.getPaosMessageID());
                    }
                    soapHeader.appendChild(paosResponse);
                    if (authnState.getRelayStateElement() != null) {
                        Node relayState = doc.importNode(authnState.getRelayStateElement(), true);
                        soapHeader.appendChild(relayState);
                    }
                    String modifiedSOAPResponse = this.writeDomToString(doc);
                    authnState.setModifiedSOAPResponse(modifiedSOAPResponse);
                    return true;
                }
                this.logger.debug("responseConsumerURL {} does not match {}", (Object)responseConsumerURL, (Object)authnState.getResponseConsumerURL());
                Document soapFaultMessage = this.createSOAPFaultDocument("AssertionConsumerServiceURL attribute missing or not matching the expected value.");
                Element soapHeader = (Element)soapFaultMessage.getFirstChild().getFirstChild();
                Element paosResponse = soapFaultMessage.createElementNS("urn:liberty:paos:2003-08", "paos:Response");
                paosResponse.setAttribute("soap:mustUnderstand", "1");
                paosResponse.setAttribute("soap:actor", "http://schemas.xmlsoap.org/soap/actor/next");
                if (authnState.getPaosMessageID() != null) {
                    paosResponse.setAttribute("refToMessageID", authnState.getPaosMessageID());
                }
                soapHeader.appendChild(paosResponse);
                if (authnState.getRelayStateElement() != null) {
                    Node relayState = soapFaultMessage.importNode(authnState.getRelayStateElement(), true);
                    soapHeader.appendChild(relayState);
                }
                String modifiedSOAPResponse = this.writeDomToString(soapFaultMessage);
                authnState.setModifiedSOAPResponse(modifiedSOAPResponse);
                this.sendSOAPFault(samlSession, authnState);
                return false;
            }
            String errorMessage = this.getSOAPFaultAsString(is);
            this.logger.warn("No {} node found in SOAP response. Error: {}", (Object)expression, (Object)errorMessage);
            if (errorMessage != null) {
                throw new DelegatedAuthenticationRuntimeException(errorMessage);
            }
            return false;
        }
        catch (XPathExpressionException ex) {
            this.logger.error("XPath programming error.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("XPath programming error.", ex);
        }
        catch (SAXNotRecognizedException ex) {
            this.logger.error("Exception caught when trying to process the SOAP esponse from the IdP.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("XPath programming error.", ex);
        }
        catch (SAXNotSupportedException ex) {
            this.logger.error("Exception caught when trying to process the SOAP esponse from the IdP.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught when trying to process the SOAP esponse from the IdP.", ex);
        }
        catch (SAXException ex) {
            this.logger.error("Exception caught when trying to process the SOAP esponse from the IdP.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught when trying to process the SOAP esponse from the IdP.", ex);
        }
        catch (DOMException ex) {
            this.logger.error("Exception caught when trying to process the SOAP esponse from the IdP.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught when trying to process the SOAP esponse from the IdP.", ex);
        }
        catch (IOException ex) {
            this.logger.error("This exception should not ever really occur, as the only I/O this method performs is on a ByteArrayInputStream.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("This exception should not ever really occur, as the only I/O this method performs is on a ByteArrayInputStream.", ex);
        }
        catch (SOAPException ex) {
            this.logger.error("Error processing a SOAP message.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Error processing a SOAP message.", ex);
        }
    }

    private String writeDomToString(Document doc) {
        LSSerializer writer = this.domLoadSaveImpl.createLSSerializer();
        DOMConfiguration domConfig = writer.getDomConfig();
        domConfig.setParameter("xml-declaration", false);
        String xmlString = writer.writeToString(doc);
        return xmlString;
    }

    private HttpResponse sendSOAPResponse(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        HttpPost method = new HttpPost(authnState.getResponseConsumerURL());
        method.setHeader("Content-Type", "application/vnd.paos+xml");
        try {
            StringEntity postData = new StringEntity(authnState.getModifiedSOAPResponse(), "UTF-8");
            method.setEntity((HttpEntity)postData);
            HttpParams params = method.getParams();
            boolean redirecting = HttpClientParams.isRedirecting((HttpParams)params);
            if (redirecting) {
                HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
                method.setParams(params);
            }
            HttpResponse response = samlSession.getHttpClient().execute((HttpUriRequest)method);
            if (redirecting) {
                HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
                method.setParams(params);
            }
            return response;
        }
        catch (Exception ex) {
            this.logger.error("Exception caught when trying to retrieve the resource.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught while sending the delegated authentication assertion to the service provider.", ex);
        }
    }

    private boolean sendSOAPFault(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        HttpPost method = new HttpPost(authnState.getResponseConsumerURL());
        method.setHeader("Content-Type", "application/vnd.paos+xml");
        try {
            StringEntity postData = new StringEntity(authnState.getModifiedSOAPResponse(), "UTF-8");
            method.setEntity((HttpEntity)postData);
            HttpResponse response = samlSession.getHttpClient().execute((HttpUriRequest)method);
            response.getStatusLine().getStatusCode();
            return true;
        }
        catch (Exception ex) {
            this.logger.error("Exception caught when trying to retrieve the resource.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught while sending the delegated authentication assertion to the service provider.", ex);
        }
    }

    private void removeAllChildren(Element element) {
        Node child = element.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            element.removeChild(child);
            child = next;
        }
    }

    private String getSOAPFaultAsString(InputStream is) throws IOException, SOAPException {
        is.reset();
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage message = factory.createMessage(null, is);
        SOAPBody body = message.getSOAPBody();
        if (body.hasFault()) {
            SOAPFault fault = body.getFault();
            String code = fault.getFaultCode();
            String string = fault.getFaultString();
            String actor = fault.getFaultActor();
            String formatedMessage = "SOAP transaction resulted in a SOAP fault.";
            if (code != null) {
                formatedMessage = formatedMessage + "  Code=\"" + code + ".\"";
            }
            if (string != null) {
                formatedMessage = formatedMessage + "  String=\"" + string + ".\"";
            }
            if (actor != null) {
                formatedMessage = formatedMessage + "  Actor=\"" + actor + ".\"";
            }
            return formatedMessage;
        }
        return null;
    }

    private Document createSOAPFaultDocument(String faultString) throws SOAPException {
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage message = factory.createMessage();
        SOAPPart sp = message.getSOAPPart();
        SOAPEnvelope se = sp.getEnvelope();
        se.setPrefix(SOAP_PREFIX);
        se.getHeader().detachNode();
        se.addHeader();
        se.getBody().detachNode();
        SOAPBody body = se.addBody();
        SOAPFault fault = body.addFault();
        Name faultCode = se.createName("Client", null, "http://schemas.xmlsoap.org/soap/envelope/");
        fault.setFaultCode(faultCode);
        fault.setFaultString(faultString);
        return se.getOwnerDocument();
    }

    private void setupIdPClientConnection(HttpClient client, SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) throws MalformedURLException {
        URL url = new URL(authnState.getIdpEndpoint());
        String protocol = url.getProtocol();
        int port = url.getPort();
        if (protocol.equalsIgnoreCase("https")) {
            SSLSocketFactory socketFactory = samlSession.getIdPSocketFactory();
            if (port == -1) {
                port = 443;
            }
            Scheme sch = new Scheme(protocol, (SocketFactory)socketFactory, port);
            client.getConnectionManager().getSchemeRegistry().unregister(protocol);
            client.getConnectionManager().getSchemeRegistry().register(sch);
        }
    }
}

