/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.saml;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;

public class SAMLNamespaceContext
implements NamespaceContext {
    private static final String[] PREFIXES = new String[]{"saml2", "ds", "S", "soap", "env", "paos", "ecp", "samlp", "wsa", "sbf", "sb", "disco"};
    private static final String[] URIS = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "http://www.w3.org/2000/09/xmldsig#", "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/2003/05/soap-envelope", "urn:liberty:paos:2003-08", "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp", "urn:oasis:names:tc:SAML:2.0:protocol", "http://www.w3.org/2005/08/addressing", "urn:liberty:sb", "urn:liberty:sb:2006-08", "urn:liberty:disco:2006-08"};
    private static final Map<String, String> PREFIX_TO_URI = new LinkedHashMap<String, String>(PREFIXES.length);
    private static final Map<String, String> URI_TO_PREFIX = new LinkedHashMap<String, String>(PREFIXES.length);

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if ("".equals(prefix)) {
            return "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String uri = PREFIX_TO_URI.get(prefix);
        if (uri != null) {
            return uri;
        }
        return "";
    }

    @Override
    public String getPrefix(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        if ("".equals(uri)) {
            return "";
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            return "xmlns";
        }
        return URI_TO_PREFIX.get(uri);
    }

    @Override
    public Iterator<String> getPrefixes(String uri) {
        String prefix = this.getPrefix(uri);
        if (prefix == null) {
            Set s = Collections.emptySet();
            return s.iterator();
        }
        return Collections.singleton(prefix).iterator();
    }

    static {
        for (int i = 0; i < PREFIXES.length; ++i) {
            PREFIX_TO_URI.put(PREFIXES[i], URIS[i]);
            URI_TO_PREFIX.put(URIS[i], PREFIXES[i]);
        }
    }
}

