/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate3.encryptor;

import java.security.Provider;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate3.encryptor.HibernatePBEEncryptorRegistry;
import org.jasypt.salt.SaltGenerator;

public final class HibernatePBEStringEncryptor {
    private String registeredName = null;
    private PBEStringEncryptor encryptor = null;
    private boolean encryptorSet = false;

    public HibernatePBEStringEncryptor() {
        this.encryptor = new StandardPBEStringEncryptor();
        this.encryptorSet = false;
    }

    HibernatePBEStringEncryptor(String registeredName, PBEStringEncryptor encryptor) {
        this.encryptor = encryptor;
        this.registeredName = registeredName;
        this.encryptorSet = true;
    }

    public synchronized PBEStringEncryptor getEncryptor() {
        return this.encryptor;
    }

    public synchronized void setEncryptor(PBEStringEncryptor encryptor) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        this.encryptor = encryptor;
        this.encryptorSet = true;
    }

    public void setPassword(String password) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEStringEncryptor standardPBEStringEncryptor = (StandardPBEStringEncryptor)this.encryptor;
        standardPBEStringEncryptor.setPassword(password);
    }

    public void setPasswordCharArray(char[] password) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEStringEncryptor standardPBEStringEncryptor = (StandardPBEStringEncryptor)this.encryptor;
        standardPBEStringEncryptor.setPasswordCharArray(password);
    }

    public void setAlgorithm(String algorithm) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEStringEncryptor standardPBEStringEncryptor = (StandardPBEStringEncryptor)this.encryptor;
        standardPBEStringEncryptor.setAlgorithm(algorithm);
    }

    public void setKeyObtentionIterations(int keyObtentionIterations) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEStringEncryptor standardPBEStringEncryptor = (StandardPBEStringEncryptor)this.encryptor;
        standardPBEStringEncryptor.setKeyObtentionIterations(keyObtentionIterations);
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEStringEncryptor standardPBEStringEncryptor = (StandardPBEStringEncryptor)this.encryptor;
        standardPBEStringEncryptor.setSaltGenerator(saltGenerator);
    }

    public void setProviderName(String providerName) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEStringEncryptor standardPBEStringEncryptor = (StandardPBEStringEncryptor)this.encryptor;
        standardPBEStringEncryptor.setProviderName(providerName);
    }

    public void setProvider(Provider provider) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEStringEncryptor standardPBEStringEncryptor = (StandardPBEStringEncryptor)this.encryptor;
        standardPBEStringEncryptor.setProvider(provider);
    }

    public void setStringOutputType(String stringOutputType) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEStringEncryptor standardPBEStringEncryptor = (StandardPBEStringEncryptor)this.encryptor;
        standardPBEStringEncryptor.setStringOutputType(stringOutputType);
    }

    public void setConfig(PBEConfig config) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEStringEncryptor standardPBEStringEncryptor = (StandardPBEStringEncryptor)this.encryptor;
        standardPBEStringEncryptor.setConfig(config);
    }

    public String encrypt(String message) {
        if (this.encryptor == null) {
            throw new EncryptionInitializationException("Encryptor has not been set into Hibernate wrapper");
        }
        return this.encryptor.encrypt(message);
    }

    public String decrypt(String encryptedMessage) {
        if (this.encryptor == null) {
            throw new EncryptionInitializationException("Encryptor has not been set into Hibernate wrapper");
        }
        return this.encryptor.decrypt(encryptedMessage);
    }

    public void setRegisteredName(String registeredName) {
        if (this.registeredName != null) {
            HibernatePBEEncryptorRegistry.getInstance().unregisterHibernatePBEStringEncryptor(this.registeredName);
        }
        this.registeredName = registeredName;
        HibernatePBEEncryptorRegistry.getInstance().registerHibernatePBEStringEncryptor(this);
    }

    public String getRegisteredName() {
        return this.registeredName;
    }
}

