/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring31.properties;

import org.jasypt.commons.CommonUtils;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.jasypt.util.text.TextEncryptor;
import org.springframework.beans.factory.config.PreferencesPlaceholderConfigurer;

public final class EncryptablePreferencesPlaceholderConfigurer
extends PreferencesPlaceholderConfigurer {
    private final StringEncryptor stringEncryptor;
    private final TextEncryptor textEncryptor;

    public EncryptablePreferencesPlaceholderConfigurer(StringEncryptor stringEncryptor) {
        CommonUtils.validateNotNull((Object)stringEncryptor, (String)"Encryptor cannot be null");
        this.stringEncryptor = stringEncryptor;
        this.textEncryptor = null;
    }

    public EncryptablePreferencesPlaceholderConfigurer(TextEncryptor textEncryptor) {
        CommonUtils.validateNotNull((Object)textEncryptor, (String)"Encryptor cannot be null");
        this.stringEncryptor = null;
        this.textEncryptor = textEncryptor;
    }

    protected String convertPropertyValue(String originalValue) {
        if (!PropertyValueEncryptionUtils.isEncryptedValue((String)originalValue)) {
            return originalValue;
        }
        if (this.stringEncryptor != null) {
            return PropertyValueEncryptionUtils.decrypt((String)originalValue, (StringEncryptor)this.stringEncryptor);
        }
        return PropertyValueEncryptionUtils.decrypt((String)originalValue, (TextEncryptor)this.textEncryptor);
    }
}

