/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioops.impl;

import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.audioops.impl.LFODelayOp;

public class ChorusOp
implements AudioOp {
    private final LFODelayOp lfoDelay = new LFODelayOp();
    private float depth;

    public ChorusOp() {
        this.lfoDelay.setRange(0.5f);
    }

    public void setDepth(float depth) {
        this.lfoDelay.setDelay(depth / 1000.0f);
        this.depth = depth;
    }

    public float getDepth() {
        return this.depth;
    }

    public void setRate(float rate) {
        this.lfoDelay.setRate(rate);
    }

    public float getRate() {
        return this.lfoDelay.getRate();
    }

    public void setFeedback(float feedback) {
        this.lfoDelay.setFeedback(feedback);
    }

    public float getFeedback() {
        return this.lfoDelay.getFeedback();
    }

    public void setPhase(float phase) {
        this.lfoDelay.setPhase(phase);
    }

    public float getPhase() {
        return this.lfoDelay.getPhase();
    }

    public void reset(int skipped) {
        this.lfoDelay.reset(skipped);
    }

    public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
        this.lfoDelay.processReplace(buffersize, outputs, inputs);
    }

    public void processAdd(int buffersize, float[][] outputs, float[][] inputs) {
        this.lfoDelay.processAdd(buffersize, outputs, inputs);
    }

    public boolean isInputRequired(boolean outputRequired) {
        return this.lfoDelay.isInputRequired(outputRequired);
    }

    public void initialize(float samplerate, int maxBufferSize) {
        this.lfoDelay.initialize(samplerate, maxBufferSize);
    }
}

