/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioops.impl;

import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.audioops.impl.VariableDelayOp;

public class CombOp
implements AudioOp {
    public static final float MIN_FREQ = 20.0f;
    public static final float MAX_FREQ = 20000.0f;
    private static final float MAX_TIME = 0.1f;
    private float frequency;
    private VariableDelayOp delay = new VariableDelayOp(0.1f);

    public CombOp() {
        this.setFrequency(20.0f);
    }

    public void setFrequency(float frequency) {
        if (frequency < 20.0f || frequency > 20000.0f) {
            throw new IllegalArgumentException();
        }
        this.delay.setDelay(1.0f / frequency);
        this.frequency = frequency;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public void setFeedback(float feedback) {
        this.delay.setFeedback(feedback);
    }

    public float getFeedback() {
        return this.delay.getFeedback();
    }

    public void reset(int samples) {
        this.delay.reset(samples);
    }

    public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
        this.delay.processReplace(buffersize, outputs, inputs);
    }

    public void processAdd(int buffersize, float[][] outputs, float[][] inputs) {
        this.delay.processAdd(buffersize, outputs, inputs);
    }

    public void initialize(float samplerate, int maxBufferSize) {
        this.delay.initialize(samplerate, maxBufferSize);
    }

    public boolean isInputRequired(boolean outputRequired) {
        return this.delay.isInputRequired(outputRequired);
    }
}

