/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioops.impl;

import org.jaudiolibs.audioops.AudioOp;

public class ContainerOp
implements AudioOp {
    private AudioOp op;
    private float mix;
    private float oldMix;
    private boolean resetNeeded;
    private float[][] scratchContainer;
    private float[] scratchBuffer;

    public ContainerOp(AudioOp op) {
        if (op == null) {
            throw new NullPointerException();
        }
        this.op = op;
        this.scratchContainer = new float[1][];
    }

    public void setMix(float mix) {
        if (mix < 0.0f || mix > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.mix = mix;
    }

    public float getMix() {
        return this.mix;
    }

    public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
        if (this.mix != 0.0f || this.oldMix != 0.0f) {
            this.processOp(buffersize, inputs);
            float[] in = inputs[0];
            float[] out = outputs[0];
            float[] scr = this.scratchBuffer;
            float m = this.oldMix;
            float delta = (this.mix - m) / (float)buffersize;
            for (int i = 0; i < buffersize; ++i) {
                out[i] = m * scr[i] + (1.0f - m) * in[i];
                m += delta;
            }
            this.oldMix = this.mix;
        } else {
            float[] in = inputs[0];
            float[] out = outputs[0];
            for (int i = 0; i < buffersize; ++i) {
                out[i] = in[i];
            }
            this.resetNeeded = true;
        }
    }

    public void processAdd(int buffersize, float[][] outputs, float[][] inputs) {
        if (this.mix != 0.0f || this.oldMix != 0.0f) {
            this.processOp(buffersize, inputs);
            float[] in = inputs[0];
            float[] out = outputs[0];
            float[] scr = this.scratchBuffer;
            float m = this.oldMix;
            float delta = (this.mix - m) / (float)buffersize;
            for (int i = 0; i < buffersize; ++i) {
                int n = i;
                out[n] = out[n] + (m * scr[i] + (1.0f - m) * in[i]);
                m += delta;
            }
            this.oldMix = this.mix;
        } else {
            float[] in = inputs[0];
            float[] out = outputs[0];
            for (int i = 0; i < buffersize; ++i) {
                int n = i;
                out[n] = out[n] + in[i];
            }
            this.resetNeeded = true;
        }
    }

    private void processOp(int buffersize, float[][] inputs) {
        if (this.resetNeeded) {
            this.op.reset(-1);
            this.resetNeeded = false;
        }
        this.scratchContainer[0] = this.scratchBuffer;
        this.op.processReplace(buffersize, this.scratchContainer, inputs);
    }

    public void initialize(float samplerate, int maxBufferSize) {
        this.op.initialize(samplerate, maxBufferSize);
        this.resetNeeded = false;
        this.scratchBuffer = new float[maxBufferSize];
    }

    public void reset(int samples) {
        this.op.reset(samples);
        this.resetNeeded = false;
    }

    public boolean isInputRequired(boolean outputRequired) {
        return outputRequired;
    }
}

