/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioops.impl;

import java.util.Arrays;
import org.jaudiolibs.audioops.AudioOp;

public class DelayOp
implements AudioOp {
    private static final float DEF_SRATE = 44100.0f;
    private static final float DEF_MAX_DELAY = 2.0f;
    private float[] delaybuffer;
    private int rovepos = 0;
    private float gain;
    private float samplerate;
    private float delaytime;
    private float maxdelay;
    private float lastdelay;
    private float feedback;

    public DelayOp() {
        this(2.0f);
    }

    public DelayOp(float maxdelay) {
        if (maxdelay > 0.0f) {
            this.maxdelay = maxdelay;
        }
        this.samplerate = 44100.0f;
        this.gain = 1.0f;
        this.feedback = 0.0f;
    }

    public void setDelay(float time) {
        if (time < 0.0f || time > this.maxdelay) {
            throw new IllegalArgumentException();
        }
        this.delaytime = time;
    }

    public float getDelay() {
        return this.delaytime;
    }

    public float getMaxDelay() {
        return this.maxdelay;
    }

    public void setFeedback(float feedback) {
        if (feedback < 0.0f || feedback > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.feedback = feedback;
    }

    public float getFeedback() {
        return this.feedback;
    }

    public void setGain(float gain) {
        if (gain < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.gain = gain;
    }

    public float getGain() {
        return this.gain;
    }

    public void reset(int samples) {
        if (this.delaybuffer != null) {
            Arrays.fill(this.delaybuffer, 0.0f);
        }
    }

    public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
        this.process(buffersize, outputs, inputs, true);
    }

    public void processAdd(int buffersize, float[][] outputs, float[][] inputs) {
        this.process(buffersize, outputs, inputs, false);
    }

    private void process(int buffersize, float[][] outputs, float[][] inputs, boolean replace) {
        float[] buf = this.delaybuffer;
        if (buf == null) {
            throw new IllegalStateException();
        }
        float[] in = inputs[0];
        float[] out = outputs[0];
        float srate = this.samplerate;
        float g = this.gain;
        float delay = this.delaytime * srate;
        float fb = this.feedback;
        int len = buffersize;
        int rnlen = buf.length;
        int pos = this.rovepos;
        if (replace) {
            for (int i = 0; i < len; ++i) {
                float r = (float)pos - (delay + 2.0f) + (float)rnlen;
                int ri = (int)r;
                float s = r - (float)ri;
                float a = buf[ri % rnlen];
                float b = buf[(ri + 1) % rnlen];
                float o = a * (1.0f - s) + b * s;
                buf[pos] = in[i] + o * fb;
                out[i] = o * g;
                pos = (pos + 1) % rnlen;
            }
        } else {
            int i = 0;
            while (i < len) {
                float r = (float)pos - (delay + 2.0f) + (float)rnlen;
                int ri = (int)r;
                float s = r - (float)ri;
                float a = buf[ri % rnlen];
                float b = buf[(ri + 1) % rnlen];
                float o = a * (1.0f - s) + b * s;
                buf[pos] = in[i] + o * fb;
                int n = i++;
                out[n] = out[n] + o * g;
                pos = (pos + 1) % rnlen;
            }
        }
        this.rovepos = pos;
        this.lastdelay = delay;
    }

    public void initialize(float samplerate, int maxBufferSize) {
        if (samplerate < 1.0f) {
            throw new IllegalArgumentException();
        }
        this.samplerate = samplerate;
        int bufferSize = (int)(this.maxdelay * samplerate) + 10;
        this.delaybuffer = new float[bufferSize];
        this.rovepos = 0;
        this.lastdelay = 0.0f;
    }

    public boolean isInputRequired(boolean outputRequired) {
        return outputRequired;
    }
}

