/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioops.impl;

import java.util.Arrays;
import org.jaudiolibs.audioops.AudioOp;

public final class FreeverbOp
implements AudioOp {
    private static final float muted = 0.0f;
    private static final float fixedgain = 0.03f;
    private static final float scalewet = 3.0f;
    private static final float scaledry = 2.0f;
    private static final float scaledamp = 0.4f;
    private static final float scaleroom = 0.28f;
    private static final float offsetroom = 0.7f;
    private static final float initialroom = 0.5f;
    private static final float initialdamp = 0.5f;
    private static final float initialwet = 0.33333334f;
    private static final float initialdry = 1.0f;
    private static final float initialwidth = 1.0f;
    private static final float freezemode = 0.5f;
    private float gain;
    private float roomsize;
    private float roomsize1;
    private float damp;
    private float damp1;
    private float wet;
    private float wet1;
    private float wet2;
    private float dry;
    private float width;
    private float mode;
    private boolean dirty;
    private int numcombs;
    private Comb[] combL;
    private Comb[] combR;
    private int numallpasses;
    private Allpass[] allpassL;
    private Allpass[] allpassR;
    private float[] inScratch = null;
    private float[] outScratchL = null;
    private float[] outScratchR = null;

    public FreeverbOp() {
        this.setWet(0.33333334f);
        this.setRoomSize(0.5f);
        this.setDry(1.0f);
        this.setDamp(0.5f);
        this.setWidth(1.0f);
    }

    public void initialize(float samplerate, int maxBufferSize) {
        float freqscale = samplerate / 44100.0f;
        int stereospread = 23;
        int combtuningL1 = (int)(freqscale * 1116.0f);
        int combtuningR1 = (int)(freqscale * (float)(1116 + stereospread));
        int combtuningL2 = (int)(freqscale * 1188.0f);
        int combtuningR2 = (int)(freqscale * (float)(1188 + stereospread));
        int combtuningL3 = (int)(freqscale * 1277.0f);
        int combtuningR3 = (int)(freqscale * (float)(1277 + stereospread));
        int combtuningL4 = (int)(freqscale * 1356.0f);
        int combtuningR4 = (int)(freqscale * (float)(1356 + stereospread));
        int combtuningL5 = (int)(freqscale * 1422.0f);
        int combtuningR5 = (int)(freqscale * (float)(1422 + stereospread));
        int combtuningL6 = (int)(freqscale * 1491.0f);
        int combtuningR6 = (int)(freqscale * (float)(1491 + stereospread));
        int combtuningL7 = (int)(freqscale * 1557.0f);
        int combtuningR7 = (int)(freqscale * (float)(1557 + stereospread));
        int combtuningL8 = (int)(freqscale * 1617.0f);
        int combtuningR8 = (int)(freqscale * (float)(1617 + stereospread));
        this.numcombs = 8;
        this.combL = new Comb[this.numcombs];
        this.combR = new Comb[this.numcombs];
        this.combL[0] = new Comb(combtuningL1);
        this.combR[0] = new Comb(combtuningR1);
        this.combL[1] = new Comb(combtuningL2);
        this.combR[1] = new Comb(combtuningR2);
        this.combL[2] = new Comb(combtuningL3);
        this.combR[2] = new Comb(combtuningR3);
        this.combL[3] = new Comb(combtuningL4);
        this.combR[3] = new Comb(combtuningR4);
        this.combL[4] = new Comb(combtuningL5);
        this.combR[4] = new Comb(combtuningR5);
        this.combL[5] = new Comb(combtuningL6);
        this.combR[5] = new Comb(combtuningR6);
        this.combL[6] = new Comb(combtuningL7);
        this.combR[6] = new Comb(combtuningR7);
        this.combL[7] = new Comb(combtuningL8);
        this.combR[7] = new Comb(combtuningR8);
        int allpasstuningL1 = (int)(freqscale * 556.0f);
        int allpasstuningR1 = (int)(freqscale * (float)(556 + stereospread));
        int allpasstuningL2 = (int)(freqscale * 441.0f);
        int allpasstuningR2 = (int)(freqscale * (float)(441 + stereospread));
        int allpasstuningL3 = (int)(freqscale * 341.0f);
        int allpasstuningR3 = (int)(freqscale * (float)(341 + stereospread));
        int allpasstuningL4 = (int)(freqscale * 225.0f);
        int allpasstuningR4 = (int)(freqscale * (float)(225 + stereospread));
        this.numallpasses = 4;
        this.allpassL = new Allpass[this.numallpasses];
        this.allpassR = new Allpass[this.numallpasses];
        this.allpassL[0] = new Allpass(allpasstuningL1);
        this.allpassR[0] = new Allpass(allpasstuningR1);
        this.allpassL[1] = new Allpass(allpasstuningL2);
        this.allpassR[1] = new Allpass(allpasstuningR2);
        this.allpassL[2] = new Allpass(allpasstuningL3);
        this.allpassR[2] = new Allpass(allpasstuningR3);
        this.allpassL[3] = new Allpass(allpasstuningL4);
        this.allpassR[3] = new Allpass(allpasstuningR4);
        for (int i = 0; i < this.numallpasses; ++i) {
            this.allpassL[i].setfeedback(0.5f);
            this.allpassR[i].setfeedback(0.5f);
        }
        this.inScratch = new float[maxBufferSize];
        this.outScratchL = new float[maxBufferSize];
        this.outScratchR = new float[maxBufferSize];
        this.dirty = true;
    }

    public void setRoomSize(float value) {
        this.roomsize = value * 0.28f + 0.7f;
        this.dirty = true;
    }

    public float getRoomSize() {
        return (this.roomsize - 0.7f) / 0.28f;
    }

    public void setDamp(float value) {
        this.damp = value * 0.4f;
        this.dirty = true;
    }

    public float getDamp() {
        return this.damp / 0.4f;
    }

    public void setWet(float value) {
        this.wet = value * 3.0f;
        this.dirty = true;
    }

    public float getWet() {
        return this.wet / 3.0f;
    }

    public void setDry(float value) {
        this.dry = value * 2.0f;
        this.dirty = true;
    }

    public float getDry() {
        return this.dry / 2.0f;
    }

    public void setWidth(float value) {
        this.width = value;
        this.dirty = true;
    }

    public float getWidth() {
        return this.width;
    }

    public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
        this.processImpl(buffersize, outputs, inputs, true);
    }

    public void processAdd(int buffersize, float[][] outputs, float[][] inputs) {
        this.processImpl(buffersize, outputs, inputs, false);
    }

    private void processImpl(int buffersize, float[][] outputs, float[][] inputs, boolean replace) {
        block19: {
            int i;
            float[] inL;
            int channels;
            block18: {
                float[] outR;
                float[] outL;
                float[] inR;
                if (this.dirty) {
                    this.update();
                    this.dirty = false;
                }
                if ((channels = outputs.length) == 1) {
                    inL = inputs[0];
                    inR = null;
                    outL = outputs[0];
                    outR = null;
                } else if (channels == 2) {
                    inL = inputs[0];
                    inR = inputs[1];
                    outL = outputs[0];
                    outR = outputs[1];
                } else {
                    throw new IllegalArgumentException("FreeverbOp can only work with 1 or 2 channels");
                }
                float again = this.gain / (float)channels;
                for (i = 0; i < buffersize; ++i) {
                    this.inScratch[i] = inL[i] * again;
                }
                if (channels == 2) {
                    for (i = 0; i < buffersize; ++i) {
                        int n = i;
                        this.inScratch[n] = this.inScratch[n] + inR[i] * again;
                    }
                }
                Arrays.fill(this.outScratchL, 0.0f);
                Arrays.fill(this.outScratchR, 0.0f);
                for (i = 0; i < this.numcombs; ++i) {
                    this.combL[i].processMix(this.inScratch, this.outScratchL, buffersize);
                    this.combR[i].processMix(this.inScratch, this.outScratchR, buffersize);
                }
                for (i = 0; i < this.numallpasses; ++i) {
                    this.allpassL[i].processReplace(this.outScratchL, this.outScratchL, buffersize);
                    this.allpassR[i].processReplace(this.outScratchR, this.outScratchR, buffersize);
                }
                if (channels != 2) break block18;
                if (this.dry == 0.0f) {
                    for (i = 0; i < buffersize; ++i) {
                        outL[i] = this.outScratchL[i] * this.wet1 + this.outScratchR[i] * this.wet2;
                        outR[i] = this.outScratchR[i] * this.wet1 + this.outScratchL[i] * this.wet2;
                    }
                } else {
                    for (i = 0; i < buffersize; ++i) {
                        outL[i] = this.outScratchL[i] * this.wet1 + this.outScratchR[i] * this.wet2 + inL[i] * this.dry;
                        outR[i] = this.outScratchR[i] * this.wet1 + this.outScratchL[i] * this.wet2 + inR[i] * this.dry;
                    }
                }
                break block19;
            }
            if (channels != 1) break block19;
            if (this.dry == 0.0f) {
                for (i = 0; i < buffersize; ++i) {
                    outL[i] = this.outScratchL[i] * this.wet1 + this.outScratchR[i] * this.wet2;
                }
            } else {
                for (i = 0; i < buffersize; ++i) {
                    outL[i] = this.outScratchL[i] * this.wet1 + this.outScratchR[i] * this.wet2 + inL[i] * this.dry;
                }
            }
        }
    }

    public void reset(int skipped) {
        this.mute();
    }

    public boolean isInputRequired(boolean outputRequired) {
        return outputRequired;
    }

    private void mute() {
        int i;
        for (i = 0; i < this.numcombs; ++i) {
            this.combL[i].mute();
            this.combR[i].mute();
        }
        for (i = 0; i < this.numallpasses; ++i) {
            this.allpassL[i].mute();
            this.allpassR[i].mute();
        }
    }

    private void update() {
        int i;
        this.wet1 = this.wet * (this.width / 2.0f + 0.5f);
        this.wet2 = this.wet * ((1.0f - this.width) / 2.0f);
        if (this.mode >= 0.5f) {
            this.roomsize1 = 1.0f;
            this.damp1 = 0.0f;
            this.gain = 0.0f;
        } else {
            this.roomsize1 = this.roomsize;
            this.damp1 = this.damp;
            this.gain = 0.03f;
        }
        for (i = 0; i < this.numcombs; ++i) {
            this.combL[i].setfeedback(this.roomsize1);
            this.combR[i].setfeedback(this.roomsize1);
        }
        for (i = 0; i < this.numcombs; ++i) {
            this.combL[i].setdamp(this.damp1);
            this.combR[i].setdamp(this.damp1);
        }
    }

    private class Allpass {
        float feedback;
        float[] buffer;
        int bufsize;
        int bufidx = 0;

        public Allpass(int size) {
            this.buffer = new float[size];
            this.bufsize = size;
        }

        public void setbuffer(float[] buf, int size) {
            this.buffer = buf;
            this.bufsize = size;
        }

        public void mute() {
            Arrays.fill(this.buffer, 0.0f);
        }

        public void setfeedback(float value) {
            this.feedback = value;
        }

        public float getfeedback() {
            return this.feedback;
        }

        public void processReplace(float[] inputs, float[] outputs, int buffersize) {
            for (int i = 0; i < buffersize; ++i) {
                float bufout = this.buffer[this.bufidx];
                if ((double)bufout > 0.0 && (double)bufout < 1.0E-10) {
                    bufout = 0.0f;
                }
                if ((double)bufout < 0.0 && (double)bufout > -1.0E-10) {
                    bufout = 0.0f;
                }
                float input = inputs[i];
                outputs[i] = -input + bufout;
                this.buffer[this.bufidx] = input + bufout * this.feedback;
                if (++this.bufidx < this.bufsize) continue;
                this.bufidx = 0;
            }
        }
    }

    private class Comb {
        float feedback;
        float filterstore = 0.0f;
        float damp1;
        float damp2;
        float[] buffer;
        int bufsize;
        int bufidx = 0;

        public Comb(int size) {
            this.buffer = new float[size];
            this.bufsize = size;
        }

        public void processMix(float[] inputs, float[] outputs, int buffersize) {
            int i = 0;
            while (i < buffersize) {
                float output = this.buffer[this.bufidx];
                if ((double)output > 0.0 && (double)output < 1.0E-10) {
                    output = 0.0f;
                }
                if ((double)output < 0.0 && (double)output > -1.0E-10) {
                    output = 0.0f;
                }
                this.filterstore = output * this.damp2 + this.filterstore * this.damp1;
                if ((double)this.filterstore > 0.0 && (double)this.filterstore < 1.0E-10) {
                    this.filterstore = 0.0f;
                }
                if ((double)this.filterstore < 0.0 && (double)this.filterstore > -1.0E-10) {
                    this.filterstore = 0.0f;
                }
                this.buffer[this.bufidx] = inputs[i] + this.filterstore * this.feedback;
                if (++this.bufidx >= this.bufsize) {
                    this.bufidx = 0;
                }
                int n = i++;
                outputs[n] = outputs[n] + output;
            }
        }

        public void setbuffer(float[] buf, int size) {
            this.buffer = buf;
            this.bufsize = size;
        }

        public void mute() {
            Arrays.fill(this.buffer, 0.0f);
        }

        public void setdamp(float val) {
            this.damp1 = val;
            this.damp2 = 1.0f - val;
        }

        public float getdamp() {
            return this.damp1;
        }

        public void setfeedback(float val) {
            this.feedback = val;
        }

        public float getfeedback() {
            return this.feedback;
        }
    }
}

