/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioops.impl;

import org.jaudiolibs.audioops.AudioOp;

public class GainOp
implements AudioOp {
    private float gain = 1.0f;
    private float oldGain = 0.0f;

    public void setGain(float gain) {
        if (gain < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.gain = gain;
    }

    public float getGain() {
        return this.gain;
    }

    public void reset(int samples) {
        this.oldGain = 0.0f;
    }

    public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
        if (this.gain != 0.0f || this.oldGain != 0.0f) {
            float[] in = inputs[0];
            float[] out = outputs[0];
            float g = this.oldGain;
            float delta = (this.gain - g) / (float)buffersize;
            for (int i = 0; i < buffersize; ++i) {
                out[i] = g * in[i];
                g += delta;
            }
            this.oldGain = this.gain;
        } else {
            float[] out = outputs[0];
            for (int i = 0; i < buffersize; ++i) {
                out[i] = 0.0f;
            }
        }
    }

    public void processAdd(int buffersize, float[][] outputs, float[][] inputs) {
        if (this.gain != 0.0f || this.oldGain != 0.0f) {
            float[] in = inputs[0];
            float[] out = outputs[0];
            float g = this.oldGain;
            float delta = (this.gain - g) / (float)buffersize;
            for (int i = 0; i < buffersize; ++i) {
                int n = i;
                out[n] = out[n] + g * in[i];
                g += delta;
            }
            this.oldGain = this.gain;
        }
    }

    public void initialize(float samplerate, int maxBufferSize) {
    }

    public boolean isInputRequired(boolean outputRequired) {
        if (outputRequired) {
            return this.gain != 0.0f || this.oldGain != 0.0f;
        }
        return false;
    }
}

