/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioops.impl;

import org.jaudiolibs.audioops.AudioOp;

public class IIRFilterOp
implements AudioOp {
    private Type filtertype = Type.LP6;
    private double samplerate;
    private double x1;
    private double x2;
    private double y1;
    private double y2;
    private double xx1;
    private double xx2;
    private double yy1;
    private double yy2;
    private double a0;
    private double a1;
    private double a2;
    private double b1;
    private double b2;
    private double q;
    private double gain = 1.0;
    private double wet = 0.0;
    private double last_wet = 0.0;
    private double last_a0;
    private double last_a1;
    private double last_a2;
    private double last_b1;
    private double last_b2;
    private double last_q;
    private double last_gain;
    private boolean last_set = false;
    private double cutoff = 44100.0;
    private double resonancedB = 0.0;
    private boolean dirty = true;

    public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
        switch (this.filtertype) {
            case LP6: {
                this.filter1Replace(buffersize, inputs[0], outputs[0]);
                break;
            }
            case LP12: 
            case HP12: 
            case NP12: 
            case BP12: {
                this.filter2Replace(buffersize, inputs[0], outputs[0]);
                break;
            }
            case LP24: 
            case HP24: {
                this.filter4Replace(buffersize, inputs[0], outputs[0]);
            }
        }
    }

    public void processAdd(int buffersize, float[][] outputs, float[][] inputs) {
        switch (this.filtertype) {
            case LP6: {
                this.filter1Add(buffersize, inputs[0], outputs[0]);
                break;
            }
            case LP12: 
            case HP12: 
            case NP12: 
            case BP12: {
                this.filter2Add(buffersize, inputs[0], outputs[0]);
                break;
            }
            case LP24: 
            case HP24: {
                this.filter4Add(buffersize, inputs[0], outputs[0]);
            }
        }
    }

    public void initialize(float samplerate, int maxBufferSize) {
        if (samplerate < 1.0f || maxBufferSize < 1) {
            throw new IllegalArgumentException();
        }
        this.samplerate = samplerate;
        this.reset(-1);
    }

    public void reset(int samples) {
        this.dirty = true;
        this.last_set = false;
        this.x1 = 0.0;
        this.x2 = 0.0;
        this.y1 = 0.0;
        this.y2 = 0.0;
        this.xx1 = 0.0;
        this.xx2 = 0.0;
        this.yy1 = 0.0;
        this.yy2 = 0.0;
        this.wet = 0.0;
        this.gain = 1.0;
        this.a0 = 0.0;
        this.a1 = 0.0;
        this.a2 = 0.0;
        this.b1 = 0.0;
        this.b2 = 0.0;
    }

    public boolean isInputRequired(boolean outputRequired) {
        return outputRequired;
    }

    public void setFrequency(float cent) {
        if (this.cutoff == (double)cent) {
            return;
        }
        this.cutoff = cent;
        this.dirty = true;
    }

    public float getFrequency() {
        return (float)this.cutoff;
    }

    public void setResonance(float db) {
        if (this.resonancedB == (double)db) {
            return;
        }
        this.resonancedB = db;
        this.dirty = true;
    }

    public float getResonance() {
        return (float)this.resonancedB;
    }

    public void setFilterType(Type filtertype) {
        if (filtertype == null) {
            throw new NullPointerException();
        }
        this.filtertype = filtertype;
        this.dirty = true;
    }

    public Type getFilterType() {
        return this.filtertype;
    }

    protected void filter4Replace(int len, float[] in, float[] out) {
        if (this.dirty) {
            this.filter2calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_a1 = this.a1;
            this.last_a2 = this.a2;
            this.last_b1 = this.b1;
            this.last_b2 = this.b2;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0 || this.last_wet > 0.0) {
            double _a0 = this.last_a0;
            double _a1 = this.last_a1;
            double _a2 = this.last_a2;
            double _b1 = this.last_b1;
            double _b2 = this.last_b2;
            double _gain = this.last_gain;
            double _wet = this.last_wet;
            double a0_delta = (this.a0 - this.last_a0) / (double)len;
            double a1_delta = (this.a1 - this.last_a1) / (double)len;
            double a2_delta = (this.a2 - this.last_a2) / (double)len;
            double b1_delta = (this.b1 - this.last_b1) / (double)len;
            double b2_delta = (this.b2 - this.last_b2) / (double)len;
            double gain_delta = (this.gain - this.last_gain) / (double)len;
            double wet_delta = (this.wet - this.last_wet) / (double)len;
            double _x1 = this.x1;
            double _x2 = this.x2;
            double _y1 = this.y1;
            double _y2 = this.y2;
            double _xx1 = this.xx1;
            double _xx2 = this.xx2;
            double _yy1 = this.yy1;
            double _yy2 = this.yy2;
            if (wet_delta != 0.0) {
                for (int i = 0; i < len; ++i) {
                    double x = in[i];
                    double y = (_a0 += a0_delta) * x + (_a1 += a1_delta) * _x1 + (_a2 += a2_delta) * _x2 - (_b1 += b1_delta) * _y1 - (_b2 += b2_delta) * _y2;
                    double xx = y * (_gain += gain_delta) * (_wet += wet_delta) + x * (1.0 - _wet);
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                    double yy = _a0 * xx + _a1 * _xx1 + _a2 * _xx2 - _b1 * _yy1 - _b2 * _yy2;
                    out[i] = (float)(yy * _gain * _wet + xx * (1.0 - _wet));
                    _xx2 = _xx1;
                    _xx1 = xx;
                    _yy2 = _yy1;
                    _yy1 = yy;
                }
            } else if (a0_delta == 0.0 && a1_delta == 0.0 && a2_delta == 0.0 && b1_delta == 0.0 && b2_delta == 0.0) {
                for (int i = 0; i < len; ++i) {
                    double x = in[i];
                    double y = _a0 * x + _a1 * _x1 + _a2 * _x2 - _b1 * _y1 - _b2 * _y2;
                    double xx = y * _gain * _wet + x * (1.0 - _wet);
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                    double yy = _a0 * xx + _a1 * _xx1 + _a2 * _xx2 - _b1 * _yy1 - _b2 * _yy2;
                    out[i] = (float)(yy * _gain * _wet + xx * (1.0 - _wet));
                    _xx2 = _xx1;
                    _xx1 = xx;
                    _yy2 = _yy1;
                    _yy1 = yy;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    double x = in[i];
                    double y = (_a0 += a0_delta) * x + (_a1 += a1_delta) * _x1 + (_a2 += a2_delta) * _x2 - (_b1 += b1_delta) * _y1 - (_b2 += b2_delta) * _y2;
                    double xx = y * (_gain += gain_delta) * _wet + x * (1.0 - _wet);
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                    double yy = _a0 * xx + _a1 * _xx1 + _a2 * _xx2 - _b1 * _yy1 - _b2 * _yy2;
                    out[i] = (float)(yy * _gain * _wet + xx * (1.0 - _wet));
                    _xx2 = _xx1;
                    _xx1 = xx;
                    _yy2 = _yy1;
                    _yy1 = yy;
                }
            }
            if (Math.abs(_x1) < 1.0E-8) {
                _x1 = 0.0;
            }
            if (Math.abs(_x2) < 1.0E-8) {
                _x2 = 0.0;
            }
            if (Math.abs(_y1) < 1.0E-8) {
                _y1 = 0.0;
            }
            if (Math.abs(_y2) < 1.0E-8) {
                _y2 = 0.0;
            }
            this.x1 = _x1;
            this.x2 = _x2;
            this.y1 = _y1;
            this.y2 = _y2;
            this.xx1 = _xx1;
            this.xx2 = _xx2;
            this.yy1 = _yy1;
            this.yy2 = _yy2;
        } else if (in != out) {
            for (int i = 0; i < len; ++i) {
                out[i] = in[i];
            }
        }
        this.last_a0 = this.a0;
        this.last_a1 = this.a1;
        this.last_a2 = this.a2;
        this.last_b1 = this.b1;
        this.last_b2 = this.b2;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }

    protected void filter4Add(int len, float[] in, float[] out) {
        if (this.dirty) {
            this.filter2calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_a1 = this.a1;
            this.last_a2 = this.a2;
            this.last_b1 = this.b1;
            this.last_b2 = this.b2;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0 || this.last_wet > 0.0) {
            double _a0 = this.last_a0;
            double _a1 = this.last_a1;
            double _a2 = this.last_a2;
            double _b1 = this.last_b1;
            double _b2 = this.last_b2;
            double _gain = this.last_gain;
            double _wet = this.last_wet;
            double a0_delta = (this.a0 - this.last_a0) / (double)len;
            double a1_delta = (this.a1 - this.last_a1) / (double)len;
            double a2_delta = (this.a2 - this.last_a2) / (double)len;
            double b1_delta = (this.b1 - this.last_b1) / (double)len;
            double b2_delta = (this.b2 - this.last_b2) / (double)len;
            double gain_delta = (this.gain - this.last_gain) / (double)len;
            double wet_delta = (this.wet - this.last_wet) / (double)len;
            double _x1 = this.x1;
            double _x2 = this.x2;
            double _y1 = this.y1;
            double _y2 = this.y2;
            double _xx1 = this.xx1;
            double _xx2 = this.xx2;
            double _yy1 = this.yy1;
            double _yy2 = this.yy2;
            if (wet_delta != 0.0) {
                int i = 0;
                while (i < len) {
                    double x = in[i];
                    double y = (_a0 += a0_delta) * x + (_a1 += a1_delta) * _x1 + (_a2 += a2_delta) * _x2 - (_b1 += b1_delta) * _y1 - (_b2 += b2_delta) * _y2;
                    double xx = y * (_gain += gain_delta) * (_wet += wet_delta) + x * (1.0 - _wet);
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                    double yy = _a0 * xx + _a1 * _xx1 + _a2 * _xx2 - _b1 * _yy1 - _b2 * _yy2;
                    int n = i++;
                    out[n] = (float)((double)out[n] + (yy * _gain * _wet + xx * (1.0 - _wet)));
                    _xx2 = _xx1;
                    _xx1 = xx;
                    _yy2 = _yy1;
                    _yy1 = yy;
                }
            } else if (a0_delta == 0.0 && a1_delta == 0.0 && a2_delta == 0.0 && b1_delta == 0.0 && b2_delta == 0.0) {
                int i = 0;
                while (i < len) {
                    double x = in[i];
                    double y = _a0 * x + _a1 * _x1 + _a2 * _x2 - _b1 * _y1 - _b2 * _y2;
                    double xx = y * _gain * _wet + x * (1.0 - _wet);
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                    double yy = _a0 * xx + _a1 * _xx1 + _a2 * _xx2 - _b1 * _yy1 - _b2 * _yy2;
                    int n = i++;
                    out[n] = (float)((double)out[n] + (yy * _gain * _wet + xx * (1.0 - _wet)));
                    _xx2 = _xx1;
                    _xx1 = xx;
                    _yy2 = _yy1;
                    _yy1 = yy;
                }
            } else {
                int i = 0;
                while (i < len) {
                    double x = in[i];
                    double y = (_a0 += a0_delta) * x + (_a1 += a1_delta) * _x1 + (_a2 += a2_delta) * _x2 - (_b1 += b1_delta) * _y1 - (_b2 += b2_delta) * _y2;
                    double xx = y * (_gain += gain_delta) * _wet + x * (1.0 - _wet);
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                    double yy = _a0 * xx + _a1 * _xx1 + _a2 * _xx2 - _b1 * _yy1 - _b2 * _yy2;
                    int n = i++;
                    out[n] = (float)((double)out[n] + (yy * _gain * _wet + xx * (1.0 - _wet)));
                    _xx2 = _xx1;
                    _xx1 = xx;
                    _yy2 = _yy1;
                    _yy1 = yy;
                }
            }
            if (Math.abs(_x1) < 1.0E-8) {
                _x1 = 0.0;
            }
            if (Math.abs(_x2) < 1.0E-8) {
                _x2 = 0.0;
            }
            if (Math.abs(_y1) < 1.0E-8) {
                _y1 = 0.0;
            }
            if (Math.abs(_y2) < 1.0E-8) {
                _y2 = 0.0;
            }
            this.x1 = _x1;
            this.x2 = _x2;
            this.y1 = _y1;
            this.y2 = _y2;
            this.xx1 = _xx1;
            this.xx2 = _xx2;
            this.yy1 = _yy1;
            this.yy2 = _yy2;
        } else {
            for (int i = 0; i < len; ++i) {
                int n = i;
                out[n] = out[n] + in[i];
            }
        }
        this.last_a0 = this.a0;
        this.last_a1 = this.a1;
        this.last_a2 = this.a2;
        this.last_b1 = this.b1;
        this.last_b2 = this.b2;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }

    private double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) * 0.5;
    }

    protected void filter2calc() {
        double _b2;
        double _b1;
        double _a2;
        double _a1;
        double _a0;
        double _q;
        double resonance;
        double csq;
        double c;
        double cf;
        double _a22;
        double _a12;
        double _a02;
        double _b22;
        double _b12;
        double _b0;
        double alpha;
        double sn;
        double cs;
        double omega;
        double bandwidth;
        double r;
        double rdB = this.resonancedB;
        if (rdB < 0.0) {
            rdB = 0.0;
        }
        if (rdB > 30.0) {
            rdB = 30.0;
        }
        if (this.filtertype == Type.LP24 || this.filtertype == Type.HP24) {
            rdB *= 0.6;
        }
        if (this.filtertype == Type.BP12) {
            this.wet = 1.0;
            r = this.cutoff / this.samplerate;
            if (r > 0.45) {
                r = 0.45;
            }
            bandwidth = Math.PI * Math.pow(10.0, -(rdB / 20.0));
            omega = Math.PI * 2 * r;
            cs = Math.cos(omega);
            sn = Math.sin(omega);
            _b0 = alpha = sn * this.sinh(Math.log(2.0) * bandwidth * omega / (sn * 2.0));
            _b12 = 0.0;
            _b22 = -alpha;
            _a02 = 1.0 + alpha;
            _a12 = -2.0 * cs;
            _a22 = 1.0 - alpha;
            cf = 1.0 / _a02;
            this.b1 = _a12 * cf;
            this.b2 = _a22 * cf;
            this.a0 = _b0 * cf;
            this.a1 = _b12 * cf;
            this.a2 = _b22 * cf;
        }
        if (this.filtertype == Type.NP12) {
            this.wet = 1.0;
            r = this.cutoff / this.samplerate;
            if (r > 0.45) {
                r = 0.45;
            }
            bandwidth = Math.PI * Math.pow(10.0, -(rdB / 20.0));
            omega = Math.PI * 2 * r;
            cs = Math.cos(omega);
            sn = Math.sin(omega);
            alpha = sn * this.sinh(Math.log(2.0) * bandwidth * omega / (sn * 2.0));
            _b0 = 1.0;
            _b12 = -2.0 * cs;
            _b22 = 1.0;
            _a02 = 1.0 + alpha;
            _a12 = -2.0 * cs;
            _a22 = 1.0 - alpha;
            cf = 1.0 / _a02;
            this.b1 = _a12 * cf;
            this.b2 = _a22 * cf;
            this.a0 = _b0 * cf;
            this.a1 = _b12 * cf;
            this.a2 = _b22 * cf;
        }
        if (this.filtertype == Type.LP12 || this.filtertype == Type.LP24) {
            r = this.cutoff / this.samplerate;
            if (r > 0.45) {
                if (this.wet == 0.0) {
                    this.wet = rdB < 1.0E-5 ? 0.0 : 1.0;
                }
                r = 0.45;
            } else {
                this.wet = 1.0;
            }
            c = 1.0 / Math.tan(Math.PI * r);
            csq = c * c;
            resonance = Math.pow(10.0, -(rdB / 20.0));
            _q = Math.sqrt(2.0) * resonance;
            _a0 = 1.0 / (1.0 + _q * c + csq);
            _a1 = 2.0 * _a0;
            _a2 = _a0;
            _b1 = 2.0 * _a0 * (1.0 - csq);
            _b2 = _a0 * (1.0 - _q * c + csq);
            this.a0 = _a0;
            this.a1 = _a1;
            this.a2 = _a2;
            this.b1 = _b1;
            this.b2 = _b2;
        }
        if (this.filtertype == Type.HP12 || this.filtertype == Type.HP24) {
            r = this.cutoff / this.samplerate;
            if (r > 0.45) {
                r = 0.45;
            }
            if (r < 1.0E-4) {
                r = 1.0E-4;
            }
            this.wet = 1.0;
            c = Math.tan(Math.PI * r);
            csq = c * c;
            resonance = Math.pow(10.0, -(rdB / 20.0));
            _q = Math.sqrt(2.0) * resonance;
            _a0 = 1.0 / (1.0 + _q * c + csq);
            _a1 = -2.0 * _a0;
            _a2 = _a0;
            _b1 = 2.0 * _a0 * (csq - 1.0);
            _b2 = _a0 * (1.0 - _q * c + csq);
            this.a0 = _a0;
            this.a1 = _a1;
            this.a2 = _a2;
            this.b1 = _b1;
            this.b2 = _b2;
        }
    }

    protected void filter2Replace(int len, float[] in, float[] out) {
        if (this.dirty) {
            this.filter2calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_a1 = this.a1;
            this.last_a2 = this.a2;
            this.last_b1 = this.b1;
            this.last_b2 = this.b2;
            this.last_q = this.q;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0 || this.last_wet > 0.0) {
            double _a0 = this.last_a0;
            double _a1 = this.last_a1;
            double _a2 = this.last_a2;
            double _b1 = this.last_b1;
            double _b2 = this.last_b2;
            double _gain = this.last_gain;
            double _wet = this.last_wet;
            double a0_delta = (this.a0 - this.last_a0) / (double)len;
            double a1_delta = (this.a1 - this.last_a1) / (double)len;
            double a2_delta = (this.a2 - this.last_a2) / (double)len;
            double b1_delta = (this.b1 - this.last_b1) / (double)len;
            double b2_delta = (this.b2 - this.last_b2) / (double)len;
            double gain_delta = (this.gain - this.last_gain) / (double)len;
            double wet_delta = (this.wet - this.last_wet) / (double)len;
            double _x1 = this.x1;
            double _x2 = this.x2;
            double _y1 = this.y1;
            double _y2 = this.y2;
            if (wet_delta != 0.0) {
                for (int i = 0; i < len; ++i) {
                    double x = in[i];
                    double y = (_a0 += a0_delta) * x + (_a1 += a1_delta) * _x1 + (_a2 += a2_delta) * _x2 - (_b1 += b1_delta) * _y1 - (_b2 += b2_delta) * _y2;
                    out[i] = (float)(y * (_gain += gain_delta) * (_wet += wet_delta) + x * (1.0 - _wet));
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                }
            } else if (a0_delta == 0.0 && a1_delta == 0.0 && a2_delta == 0.0 && b1_delta == 0.0 && b2_delta == 0.0) {
                for (int i = 0; i < len; ++i) {
                    double x = in[i];
                    double y = _a0 * x + _a1 * _x1 + _a2 * _x2 - _b1 * _y1 - _b2 * _y2;
                    out[i] = (float)(y * _gain);
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    double x = in[i];
                    double y = (_a0 += a0_delta) * x + (_a1 += a1_delta) * _x1 + (_a2 += a2_delta) * _x2 - (_b1 += b1_delta) * _y1 - (_b2 += b2_delta) * _y2;
                    out[i] = (float)(y * (_gain += gain_delta));
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                }
            }
            if (Math.abs(_x1) < 1.0E-8) {
                _x1 = 0.0;
            }
            if (Math.abs(_x2) < 1.0E-8) {
                _x2 = 0.0;
            }
            if (Math.abs(_y1) < 1.0E-8) {
                _y1 = 0.0;
            }
            if (Math.abs(_y2) < 1.0E-8) {
                _y2 = 0.0;
            }
            this.x1 = _x1;
            this.x2 = _x2;
            this.y1 = _y1;
            this.y2 = _y2;
        } else if (in != out) {
            for (int i = 0; i < len; ++i) {
                out[i] = in[i];
            }
        }
        this.last_a0 = this.a0;
        this.last_a1 = this.a1;
        this.last_a2 = this.a2;
        this.last_b1 = this.b1;
        this.last_b2 = this.b2;
        this.last_q = this.q;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }

    protected void filter2Add(int len, float[] in, float[] out) {
        if (this.dirty) {
            this.filter2calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_a1 = this.a1;
            this.last_a2 = this.a2;
            this.last_b1 = this.b1;
            this.last_b2 = this.b2;
            this.last_q = this.q;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0 || this.last_wet > 0.0) {
            double _a0 = this.last_a0;
            double _a1 = this.last_a1;
            double _a2 = this.last_a2;
            double _b1 = this.last_b1;
            double _b2 = this.last_b2;
            double _gain = this.last_gain;
            double _wet = this.last_wet;
            double a0_delta = (this.a0 - this.last_a0) / (double)len;
            double a1_delta = (this.a1 - this.last_a1) / (double)len;
            double a2_delta = (this.a2 - this.last_a2) / (double)len;
            double b1_delta = (this.b1 - this.last_b1) / (double)len;
            double b2_delta = (this.b2 - this.last_b2) / (double)len;
            double gain_delta = (this.gain - this.last_gain) / (double)len;
            double wet_delta = (this.wet - this.last_wet) / (double)len;
            double _x1 = this.x1;
            double _x2 = this.x2;
            double _y1 = this.y1;
            double _y2 = this.y2;
            if (wet_delta != 0.0) {
                int i = 0;
                while (i < len) {
                    double x = in[i];
                    double y = (_a0 += a0_delta) * x + (_a1 += a1_delta) * _x1 + (_a2 += a2_delta) * _x2 - (_b1 += b1_delta) * _y1 - (_b2 += b2_delta) * _y2;
                    int n = i++;
                    out[n] = (float)((double)out[n] + (y * (_gain += gain_delta) * (_wet += wet_delta) + x * (1.0 - _wet)));
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                }
            } else if (a0_delta == 0.0 && a1_delta == 0.0 && a2_delta == 0.0 && b1_delta == 0.0 && b2_delta == 0.0) {
                int i = 0;
                while (i < len) {
                    double x = in[i];
                    double y = _a0 * x + _a1 * _x1 + _a2 * _x2 - _b1 * _y1 - _b2 * _y2;
                    int n = i++;
                    out[n] = (float)((double)out[n] + y * _gain);
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                }
            } else {
                int i = 0;
                while (i < len) {
                    double x = in[i];
                    double y = (_a0 += a0_delta) * x + (_a1 += a1_delta) * _x1 + (_a2 += a2_delta) * _x2 - (_b1 += b1_delta) * _y1 - (_b2 += b2_delta) * _y2;
                    int n = i++;
                    out[n] = (float)((double)out[n] + y * (_gain += gain_delta));
                    _x2 = _x1;
                    _x1 = x;
                    _y2 = _y1;
                    _y1 = y;
                }
            }
            if (Math.abs(_x1) < 1.0E-8) {
                _x1 = 0.0;
            }
            if (Math.abs(_x2) < 1.0E-8) {
                _x2 = 0.0;
            }
            if (Math.abs(_y1) < 1.0E-8) {
                _y1 = 0.0;
            }
            if (Math.abs(_y2) < 1.0E-8) {
                _y2 = 0.0;
            }
            this.x1 = _x1;
            this.x2 = _x2;
            this.y1 = _y1;
            this.y2 = _y2;
        } else {
            for (int i = 0; i < len; ++i) {
                int n = i;
                out[n] = out[n] + in[i];
            }
        }
        this.last_a0 = this.a0;
        this.last_a1 = this.a1;
        this.last_a2 = this.a2;
        this.last_b1 = this.b1;
        this.last_b2 = this.b2;
        this.last_q = this.q;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }

    protected void filter1calc() {
        double c;
        if (this.cutoff < 120.0) {
            this.cutoff = 120.0;
        }
        if ((c = 7.3303828583761845 * this.cutoff / this.samplerate) > 1.0) {
            c = 1.0;
        }
        this.a0 = Math.sqrt(1.0 - Math.cos(c)) * Math.sqrt(1.5707963267948966);
        if (this.resonancedB < 0.0) {
            this.resonancedB = 0.0;
        }
        if (this.resonancedB > 20.0) {
            this.resonancedB = 20.0;
        }
        this.q = Math.sqrt(0.5) * Math.pow(10.0, -(this.resonancedB / 20.0));
        this.gain = Math.pow(10.0, -this.resonancedB / 40.0);
        if (this.wet == 0.0 && (this.resonancedB > 1.0E-5 || c < 0.9999999)) {
            this.wet = 1.0;
        }
    }

    protected void filter1Replace(int len, float[] in, float[] out) {
        if (this.dirty) {
            this.filter1calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_q = this.q;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0 || this.last_wet > 0.0) {
            double _a0 = this.last_a0;
            double _q = this.last_q;
            double _gain = this.last_gain;
            double _wet = this.last_wet;
            double a0_delta = (this.a0 - this.last_a0) / (double)len;
            double q_delta = (this.q - this.last_q) / (double)len;
            double gain_delta = (this.gain - this.last_gain) / (double)len;
            double wet_delta = (this.wet - this.last_wet) / (double)len;
            double _y2 = this.y2;
            double _y1 = this.y1;
            if (wet_delta != 0.0) {
                for (int i = 0; i < len; ++i) {
                    _y1 = (1.0 - (_q += q_delta) * (_a0 += a0_delta)) * _y1 - _a0 * _y2 + _a0 * (double)in[i];
                    _y2 = (1.0 - _q * _a0) * _y2 + _a0 * _y1;
                    out[i] = (float)(_y2 * (_gain += gain_delta) * (_wet += wet_delta) + (double)in[i] * (1.0 - _wet));
                }
            } else if (a0_delta == 0.0 && q_delta == 0.0) {
                for (int i = 0; i < len; ++i) {
                    _y1 = (1.0 - _q * _a0) * _y1 - _a0 * _y2 + _a0 * (double)in[i];
                    _y2 = (1.0 - _q * _a0) * _y2 + _a0 * _y1;
                    out[i] = (float)(_y2 * _gain);
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    _y1 = (1.0 - (_q += q_delta) * (_a0 += a0_delta)) * _y1 - _a0 * _y2 + _a0 * (double)in[i];
                    _y2 = (1.0 - _q * _a0) * _y2 + _a0 * _y1;
                    out[i] = (float)(_y2 * (_gain += gain_delta));
                }
            }
            if (Math.abs(_y2) < 1.0E-8) {
                _y2 = 0.0;
            }
            if (Math.abs(_y1) < 1.0E-8) {
                _y1 = 0.0;
            }
            this.y2 = _y2;
            this.y1 = _y1;
        } else if (in != out) {
            for (int i = 0; i < len; ++i) {
                out[i] = in[i];
            }
        }
        this.last_a0 = this.a0;
        this.last_q = this.q;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }

    protected void filter1Add(int len, float[] in, float[] out) {
        if (this.dirty) {
            this.filter1calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_q = this.q;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0 || this.last_wet > 0.0) {
            double _a0 = this.last_a0;
            double _q = this.last_q;
            double _gain = this.last_gain;
            double _wet = this.last_wet;
            double a0_delta = (this.a0 - this.last_a0) / (double)len;
            double q_delta = (this.q - this.last_q) / (double)len;
            double gain_delta = (this.gain - this.last_gain) / (double)len;
            double wet_delta = (this.wet - this.last_wet) / (double)len;
            double _y2 = this.y2;
            double _y1 = this.y1;
            if (wet_delta != 0.0) {
                for (int i = 0; i < len; ++i) {
                    _y1 = (1.0 - (_q += q_delta) * (_a0 += a0_delta)) * _y1 - _a0 * _y2 + _a0 * (double)in[i];
                    _y2 = (1.0 - _q * _a0) * _y2 + _a0 * _y1;
                    int n = i;
                    out[n] = (float)((double)out[n] + (_y2 * (_gain += gain_delta) * (_wet += wet_delta) + (double)in[i] * (1.0 - _wet)));
                }
            } else if (a0_delta == 0.0 && q_delta == 0.0) {
                int i = 0;
                while (i < len) {
                    _y1 = (1.0 - _q * _a0) * _y1 - _a0 * _y2 + _a0 * (double)in[i];
                    _y2 = (1.0 - _q * _a0) * _y2 + _a0 * _y1;
                    int n = i++;
                    out[n] = (float)((double)out[n] + _y2 * _gain);
                }
            } else {
                int i = 0;
                while (i < len) {
                    _y1 = (1.0 - (_q += q_delta) * (_a0 += a0_delta)) * _y1 - _a0 * _y2 + _a0 * (double)in[i];
                    _y2 = (1.0 - _q * _a0) * _y2 + _a0 * _y1;
                    int n = i++;
                    out[n] = (float)((double)out[n] + _y2 * (_gain += gain_delta));
                }
            }
            if (Math.abs(_y2) < 1.0E-8) {
                _y2 = 0.0;
            }
            if (Math.abs(_y1) < 1.0E-8) {
                _y1 = 0.0;
            }
            this.y2 = _y2;
            this.y1 = _y1;
        } else {
            for (int i = 0; i < len; ++i) {
                int n = i;
                out[n] = out[n] + in[i];
            }
        }
        this.last_a0 = this.a0;
        this.last_q = this.q;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }

    public static enum Type {
        LP6,
        LP12,
        HP12,
        BP12,
        NP12,
        LP24,
        HP24;

    }
}

