/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioops.impl;

import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.audioops.impl.VariableDelayOp;

public class LFODelayOp
implements AudioOp {
    private static final float PI2 = (float)Math.PI * 2;
    private final float max_delay;
    private final VariableDelayOp delayOp = new VariableDelayOp(2.0f);
    private float delay = 0.0f;
    private float range = 0.0f;
    private float rate = 0.0f;
    private float phase = 0.0f;
    private int lfocount;
    private float samplerate;

    public LFODelayOp() {
        this.max_delay = 1.0f;
    }

    public void initialize(float samplerate, int maxBufferSize) {
        this.delayOp.initialize(samplerate, maxBufferSize);
        this.samplerate = samplerate;
    }

    public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
        this.processImpl(buffersize, outputs, inputs, true);
    }

    public void processAdd(int buffersize, float[][] outputs, float[][] inputs) {
        this.processImpl(buffersize, outputs, inputs, false);
    }

    private void processImpl(int buffersize, float[][] outputs, float[][] inputs, boolean replace) {
        if ((double)this.rate > 1.0E-4 && this.range > 0.0f) {
            this.lfocount += buffersize;
            float lfolength = this.samplerate / this.rate;
            this.lfocount %= (int)lfolength;
            float r = (float)this.lfocount / lfolength;
            r *= (float)Math.PI * 2;
            if ((r += this.phase * ((float)Math.PI * 2)) > (float)Math.PI * 2) {
                r -= (float)Math.PI * 2;
            }
            r = this.delay * this.range * (float)Math.sin(r);
            this.delayOp.setDelay(this.delay + r);
        } else {
            this.lfocount = 0;
            this.delayOp.setDelay(this.delay);
        }
        if (replace) {
            this.delayOp.processReplace(buffersize, outputs, inputs);
        } else {
            this.delayOp.processAdd(buffersize, outputs, inputs);
        }
    }

    public void reset(int skipped) {
        this.delayOp.reset(skipped);
        this.lfocount = 0;
    }

    public boolean isInputRequired(boolean outputRequired) {
        return outputRequired;
    }

    public void setDelay(float depth) {
        if (depth < 0.0f || depth > this.max_delay) {
            throw new IllegalArgumentException();
        }
        this.delay = depth;
    }

    public float getDelay() {
        return this.delay;
    }

    public void setRange(float range) {
        if (range < 0.0f || range > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.range = range;
    }

    public float getRange() {
        return this.range;
    }

    public void setRate(float rate) {
        if (rate < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.rate = rate;
    }

    public float getRate() {
        return this.rate;
    }

    public void setPhase(float phase) {
        if (phase < 0.0f || phase > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.phase = phase;
    }

    public float getPhase() {
        return this.phase;
    }

    public void setFeedback(float feedback) {
        this.delayOp.setFeedback(feedback);
    }

    public float getFeedback() {
        return this.delayOp.getFeedback();
    }
}

