/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import java.io.IOException;
import java.net.URI;
import java.util.ServiceLoader;

public class AudioTable {
    private final float[] data;
    private final double sampleRate;
    private final int channels;
    private final int size;

    private AudioTable(float[] data, double sampleRate, int channels, int size) {
        this.data = data;
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.size = size;
    }

    public boolean hasSampleRate() {
        return this.sampleRate > 0.5;
    }

    public double sampleRate() {
        return this.sampleRate;
    }

    public int channels() {
        return this.channels;
    }

    public int size() {
        return this.size;
    }

    public void set(int channel, int index, double value) {
        this.data[index * this.channels + channel] = (float)value;
    }

    public double get(int channel, int idx) {
        return this.data[idx * this.channels + channel];
    }

    public double get(int channel, double pos) {
        double frac;
        int iPos = (int)pos;
        if (iPos < 1) {
            iPos = 1;
            frac = 0.0;
        } else if (iPos > this.size() - 3) {
            iPos = this.size() - 3;
            frac = 1.0;
        } else {
            frac = pos - (double)iPos;
        }
        double a = this.get(channel, iPos - 1);
        double b = this.get(channel, iPos);
        double c = this.get(channel, iPos + 1);
        double d = this.get(channel, iPos + 2);
        double cminusb = c - b;
        return b + frac * (cminusb - 0.5 * (frac - 1.0) * ((a - d + 3.0 * cminusb) * frac + (b - a - cminusb)));
    }

    public static AudioTable generate(int size, int channels) {
        return new AudioTable(new float[size * channels], 0.0, channels, size);
    }

    public static AudioTable wrap(AudioTable original, int size) {
        if (size < 0 || size > original.size) {
            throw new IllegalArgumentException();
        }
        return new AudioTable(original.data, original.sampleRate, original.channels, size);
    }

    public static AudioTable wrap(float[] data, double sampleRate, int channels) {
        return new AudioTable(data, sampleRate, channels, data.length / channels);
    }

    public static AudioTable load(URI source) throws IOException {
        ServiceLoader<Loader> loaders = ServiceLoader.load(Loader.class);
        Exception ex = null;
        for (Loader loader : loaders) {
            try {
                AudioTable table = loader.load(source);
                if (table == null) continue;
                return table;
            }
            catch (Exception exx) {
                ex = exx;
            }
        }
        if (ex != null) {
            throw new IOException(ex);
        }
        throw new IOException("No loader found for " + source);
    }

    public static interface Loader {
        public AudioTable load(URI var1) throws Exception;
    }
}

