/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.audioops.impl.CombOp;
import org.jaudiolibs.pipes.OpHolder;
import org.jaudiolibs.pipes.units.Utils;

public final class CombFilter
extends OpHolder {
    private final CombOp op;

    public CombFilter() {
        this(new CombOp());
    }

    CombFilter(CombOp op) {
        super((AudioOp)op, 1);
        this.op = op;
        this.reset();
    }

    public CombFilter frequency(double frequency) {
        this.op.setFrequency((float)Utils.constrain(frequency, 20.0, 20000.0));
        return this;
    }

    public double frequency() {
        return this.op.getFrequency();
    }

    public CombFilter feedback(double feedback) {
        this.op.setFeedback((float)Utils.constrain(feedback, 0.0, 1.0));
        return this;
    }

    public double feedback() {
        return this.op.getFeedback();
    }

    public void reset() {
        this.op.setFrequency(20.0f);
        this.op.setFeedback(0.0f);
    }
}

