/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.audioops.impl.VariableDelayOp;
import org.jaudiolibs.pipes.OpHolder;
import org.jaudiolibs.pipes.units.Utils;

public final class Delay
extends OpHolder {
    private final OpImpl op;

    public Delay() {
        this(new OpImpl(2.0f));
    }

    Delay(OpImpl op) {
        super((AudioOp)op, 1);
        this.op = op;
        this.reset();
    }

    public Delay time(double time) {
        this.op.setDelay((float)Utils.constrain(time, 0.0, 2.0));
        return this;
    }

    public double time() {
        return this.op.getDelay();
    }

    public Delay feedback(double fb) {
        this.op.setFeedback((float)Utils.constrain(fb, 0.0, 1.0));
        return this;
    }

    public double feedback() {
        return this.op.getFeedback();
    }

    public Delay level(double level) {
        this.op.setGain((float)Utils.constrain(level, 0.0, 1.0));
        return this;
    }

    public double level() {
        return this.op.getGain();
    }

    public Delay passthrough(boolean passthrough) {
        this.op.passthrough = passthrough;
        return this;
    }

    public boolean passthrough() {
        return this.op.passthrough;
    }

    public double maxDelay() {
        return this.op.getMaxDelay();
    }

    public void reset() {
        this.op.setDelay(0.0f);
        this.op.setGain(1.0f);
        this.op.setFeedback(0.0f);
        this.op.passthrough = true;
    }

    private static class OpImpl
    extends VariableDelayOp {
        private boolean passthrough;

        private OpImpl(float maxDelay) {
            super(maxDelay);
        }

        public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
            if (this.passthrough) {
                super.processAdd(buffersize, outputs, inputs);
            } else {
                super.processReplace(buffersize, outputs, inputs);
            }
        }
    }
}

