/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import java.util.List;
import java.util.function.DoubleUnaryOperator;
import org.jaudiolibs.pipes.Buffer;
import org.jaudiolibs.pipes.Pipe;

public final class Fn
extends Pipe {
    private static final DoubleUnaryOperator PASSTHROUGH = d -> d;
    private DoubleUnaryOperator fn;

    public Fn() {
        super(1, 1);
    }

    public Fn(DoubleUnaryOperator fn) {
        this();
        this.function(fn);
    }

    public Fn function(DoubleUnaryOperator fn) {
        this.fn = fn == null ? PASSTHROUGH : fn;
        return this;
    }

    public void reset() {
        this.fn = null;
    }

    protected void process(List<Buffer> buffers) {
        if (buffers.isEmpty()) {
            return;
        }
        DoubleUnaryOperator f = this.fn == null ? PASSTHROUGH : this.fn;
        Buffer buffer = buffers.get(0);
        int size = buffer.getSize();
        float[] data = buffer.getData();
        for (int i = 0; i < size; ++i) {
            data[i] = (float)f.applyAsDouble(data[i]);
        }
    }
}

