/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.audioops.impl.FreeverbOp;
import org.jaudiolibs.pipes.OpHolder;
import org.jaudiolibs.pipes.units.Utils;

public final class Freeverb
extends OpHolder {
    private static final float INITIAL_DAMP = 0.5f;
    private static final float INITIAL_DRY = 0.5f;
    private static final float INITIAL_ROOM_SIZE = 0.5f;
    private static final float INITIAL_WET = 0.0f;
    private static final float INITIAL_WIDTH = 0.5f;
    private final FreeverbOp op;

    public Freeverb() {
        this(new FreeverbOp(), 2);
    }

    private Freeverb(FreeverbOp op, int channels) {
        super((AudioOp)op, channels);
        this.op = op;
        this.reset();
    }

    public Freeverb damp(double damp) {
        this.op.setDamp((float)Utils.constrain(damp, 0.0, 1.0));
        return this;
    }

    public double damp() {
        return this.op.getDamp();
    }

    public Freeverb dry(double dry) {
        this.op.setDry((float)Utils.constrain(dry, 0.0, 1.0));
        return this;
    }

    public double dry() {
        return this.op.getDry();
    }

    public Freeverb roomSize(double size) {
        this.op.setRoomSize((float)Utils.constrain(size, 0.0, 1.0));
        return this;
    }

    public double roomSize() {
        return this.op.getRoomSize();
    }

    public Freeverb wet(double wet) {
        this.op.setWet((float)Utils.constrain(wet, 0.0, 1.0));
        return this;
    }

    public double wet() {
        return this.op.getWet();
    }

    public Freeverb width(double width) {
        this.op.setWidth((float)Utils.constrain(width, 0.0, 1.0));
        return this;
    }

    public double width() {
        return this.op.getWidth();
    }

    public void reset() {
        this.op.setDamp(0.5f);
        this.op.setDry(0.5f);
        this.op.setRoomSize(0.5f);
        this.op.setWet(0.0f);
        this.op.setWidth(0.5f);
    }
}

