/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.audioops.impl.IIRFilterOp;
import org.jaudiolibs.pipes.OpHolder;
import org.jaudiolibs.pipes.units.Utils;

public final class IIRFilter
extends OpHolder {
    public static final Type LP6 = Type.LP6;
    public static final Type LP12 = Type.LP12;
    public static final Type LP24 = Type.LP24;
    public static final Type HP12 = Type.HP12;
    public static final Type HP24 = Type.HP24;
    public static final Type BP12 = Type.BP12;
    public static final Type NP12 = Type.NP12;
    private final IIRFilterOp filter;

    public IIRFilter() {
        this(new IIRFilterOp());
    }

    private IIRFilter(IIRFilterOp filter) {
        super((AudioOp)filter, 1);
        this.filter = filter;
        this.reset();
    }

    public IIRFilter frequency(double frequency) {
        this.filter.setFrequency((float)Utils.constrain(frequency, 20.0, 20000.0));
        return this;
    }

    public double frequency() {
        return this.filter.getFrequency();
    }

    public IIRFilter resonance(double db) {
        this.filter.setResonance((float)Utils.constrain(db, 0.0, 30.0));
        return this;
    }

    public double resonance() {
        return this.filter.getResonance();
    }

    public IIRFilter type(Type type) {
        switch (type) {
            case LP6: {
                this.filter.setFilterType(IIRFilterOp.Type.LP6);
                break;
            }
            case LP12: {
                this.filter.setFilterType(IIRFilterOp.Type.LP12);
                break;
            }
            case LP24: {
                this.filter.setFilterType(IIRFilterOp.Type.LP24);
                break;
            }
            case HP12: {
                this.filter.setFilterType(IIRFilterOp.Type.HP12);
                break;
            }
            case HP24: {
                this.filter.setFilterType(IIRFilterOp.Type.HP24);
                break;
            }
            case BP12: {
                this.filter.setFilterType(IIRFilterOp.Type.BP12);
                break;
            }
            case NP12: {
                this.filter.setFilterType(IIRFilterOp.Type.NP12);
            }
        }
        return this;
    }

    public Type type() {
        switch (this.filter.getFilterType()) {
            case LP6: {
                return Type.LP6;
            }
            case LP12: {
                return Type.LP12;
            }
            case LP24: {
                return Type.LP24;
            }
            case HP12: {
                return Type.HP12;
            }
            case HP24: {
                return Type.HP24;
            }
            case BP12: {
                return Type.BP12;
            }
            case NP12: {
                return Type.NP12;
            }
        }
        return LP6;
    }

    public void reset() {
        this.resonance(0.0);
        this.frequency(20000.0);
        this.type(LP6);
    }

    public static enum Type {
        LP6,
        LP12,
        LP24,
        HP12,
        HP24,
        BP12,
        NP12;

    }
}

