/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import java.util.Arrays;
import java.util.Objects;
import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.pipes.OpHolder;
import org.jaudiolibs.pipes.units.Waveform;

public final class LFO
extends OpHolder {
    private static final float DEFAULT_FREQUENCY = 1.0f;
    private static final Waveform DEFAULT_WAVEFORM = Waveform.Sine;
    private final Op op;

    public LFO() {
        this(new Op());
    }

    private LFO(Op op) {
        super((AudioOp)op, 0, 1);
        this.op = op;
        this.reset();
    }

    public LFO frequency(double frequency) {
        this.op.setFrequency((float)frequency);
        return this;
    }

    public double frequency() {
        return this.op.getFrequency();
    }

    public LFO waveform(Waveform waveform) {
        this.op.setWaveform(Objects.requireNonNull(waveform));
        return this;
    }

    public Waveform waveform() {
        return this.op.getWaveform();
    }

    public LFO gain(double level) {
        this.op.setGain((float)level);
        return this;
    }

    public double gain() {
        return this.op.getGain();
    }

    public LFO bipolar(boolean bipolar) {
        this.op.setBipolar(bipolar);
        return this;
    }

    public boolean bipolar() {
        return this.op.getBipolar();
    }

    public void reset() {
        this.op.setFrequency(1.0f);
        this.op.setWaveform(Waveform.Sine);
        this.op.setGain(1.0f);
        this.op.setBipolar(false);
    }

    static /* synthetic */ Waveform access$100() {
        return DEFAULT_WAVEFORM;
    }

    private static class Op
    implements AudioOp {
        private static final float TWOPI = (float)Math.PI * 2;
        private float phase;
        private float phaseIncrement;
        private float freq = 1.0f;
        private float srate;
        private float gain = 1.0f;
        private float oldGain;
        private Waveform wave = LFO.access$100();
        private boolean bipolar;

        private Op() {
        }

        public void setGain(float gain) {
            this.gain = gain;
        }

        public float getGain() {
            return this.gain;
        }

        public void setFrequency(float frequency) {
            this.freq = frequency;
            this.updateIncrement();
        }

        public float getFrequency() {
            return this.freq;
        }

        public void setWaveform(Waveform mode) {
            this.wave = mode;
        }

        public Waveform getWaveform() {
            return this.wave;
        }

        public void setBipolar(boolean bipolar) {
            this.bipolar = bipolar;
        }

        public boolean getBipolar() {
            return this.bipolar;
        }

        public void initialize(float samplerate, int buffersize) {
            this.srate = samplerate;
            this.phase = 0.0f;
            this.updateIncrement();
        }

        public void reset(int i) {
            this.phase = 0.0f;
        }

        public boolean isInputRequired(boolean bln) {
            return false;
        }

        public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
            float[] out = outputs[0];
            if (this.gain != 0.0f || this.oldGain != 0.0f) {
                float g = this.oldGain;
                float delta = (this.gain - g) / (float)buffersize;
                for (int i = 0; i < buffersize; ++i) {
                    out[i] = g * this.nextSample();
                    g += delta;
                }
                this.oldGain = this.gain;
            } else {
                Arrays.fill(out, 0.0f);
                this.phase += this.phaseIncrement * (float)buffersize;
                while (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
            }
        }

        public void processAdd(int buffersize, float[][] outputs, float[][] inputs) {
            float[] out = outputs[0];
            if (this.gain != 0.0f || this.oldGain != 0.0f) {
                float g = this.oldGain;
                float delta = (this.gain - g) / (float)buffersize;
                int i = 0;
                while (i < buffersize) {
                    int n = i++;
                    out[n] = out[n] + g * this.nextSample();
                    g += delta;
                }
                this.oldGain = this.gain;
            } else {
                this.phase += this.phaseIncrement * (float)buffersize;
                while (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
            }
        }

        private void updateIncrement() {
            float inc = 0.0f;
            if (this.srate > 0.0f && (inc = (float)Math.PI * 2 * this.freq / this.srate) < 0.0f) {
                inc = 0.0f;
            }
            this.phaseIncrement = inc;
        }

        private float nextSample() {
            float value = 0.0f;
            float t = this.phase / ((float)Math.PI * 2);
            switch (this.wave) {
                case Sine: {
                    value = (float)Math.sin(this.phase);
                    break;
                }
                case Saw: {
                    value = 2.0f * t - 1.0f;
                    break;
                }
                case Square: {
                    value = (double)this.phase < Math.PI ? 1.0f : -1.0f;
                }
            }
            if (!this.bipolar) {
                value = value / 2.0f + 0.5f;
            }
            this.phase += this.phaseIncrement;
            while (this.phase >= (float)Math.PI * 2) {
                this.phase -= (float)Math.PI * 2;
            }
            return value;
        }
    }
}

