/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.audioops.impl.LFODelayOp;
import org.jaudiolibs.pipes.OpHolder;
import org.jaudiolibs.pipes.units.Utils;

public final class LFODelay
extends OpHolder {
    private final LFODelayOp op;

    public LFODelay() {
        this(new LFODelayOp());
    }

    private LFODelay(LFODelayOp op) {
        super((AudioOp)op, 1);
        this.op = op;
        this.reset();
    }

    public LFODelay time(double time) {
        this.op.setDelay((float)Utils.constrain(time, 0.0, 1.0));
        return this;
    }

    public double time() {
        return this.op.getDelay();
    }

    public LFODelay feedback(double feedback) {
        this.op.setFeedback((float)Utils.constrain(feedback, 0.0, 1.0));
        return this;
    }

    public double feedback() {
        return this.op.getFeedback();
    }

    public LFODelay range(double range) {
        this.op.setRange((float)Utils.constrain(range, 0.0, 1.0));
        return this;
    }

    public double range() {
        return this.op.getRange();
    }

    public LFODelay rate(double rate) {
        this.op.setRate((float)rate);
        return this;
    }

    public double rate() {
        return this.op.getRate();
    }

    public void reset() {
        this.op.setDelay(0.0f);
        this.op.setRange(0.0f);
        this.op.setFeedback(0.0f);
        this.op.setRate(0.0f);
    }
}

