/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import java.util.List;
import org.jaudiolibs.pipes.Buffer;
import org.jaudiolibs.pipes.Pipe;
import org.jaudiolibs.pipes.units.AudioTable;

public final class Looper
extends Pipe {
    private AudioTable table;
    private double in;
    private double out;
    private double speed;
    private boolean playing;
    private boolean recording;
    private boolean looping;
    private double cursor;
    private double realSpeed;
    private int iIn;
    private int iOut;
    private Channel[] channels = new Channel[]{new Channel()};
    private static final int SMOOTH_AMOUNT = 256;

    public Looper() {
        super(16, 16);
        this.reset();
    }

    public Looper table(AudioTable table) {
        if (table != this.table) {
            this.table = table;
            this.triggerSmoothing();
        }
        return this;
    }

    public AudioTable table() {
        return this.table;
    }

    public Looper in(double in) {
        if (in < 0.0) {
            in = 0.0;
        } else if (in > 1.0) {
            in = 1.0;
        }
        this.in = in;
        return this;
    }

    public double in() {
        return this.in;
    }

    public Looper out(double out) {
        if (out < 0.0) {
            out = 0.0;
        } else if (out > 1.0) {
            out = 1.0;
        }
        this.out = out;
        return this;
    }

    public double out() {
        return this.out;
    }

    public Looper position(double position) {
        if (position < 0.0) {
            position = 0.0;
        } else if (position > 1.0) {
            position = 1.0;
        }
        if (this.table != null) {
            this.cursor = position * (double)this.table.size();
            this.triggerSmoothing();
        }
        return this;
    }

    public double position() {
        return this.table == null ? 0.0 : this.cursor / (double)this.table.size();
    }

    public Looper speed(double speed) {
        this.speed = speed;
        return this;
    }

    public double speed() {
        return this.speed;
    }

    public Looper playing(boolean playing) {
        if (this.playing != playing) {
            this.triggerSmoothing();
        }
        this.playing = playing;
        this.recording = false;
        return this;
    }

    public boolean playing() {
        return this.playing;
    }

    public Looper recording(boolean recording) {
        if (this.recording != recording) {
            this.triggerSmoothing();
        }
        this.recording = recording;
        return this;
    }

    public boolean recording() {
        return this.recording;
    }

    public Looper looping(boolean looping) {
        this.looping = looping;
        return this;
    }

    public boolean looping() {
        return this.looping;
    }

    public Looper play() {
        if (this.speed < 0.0) {
            this.position(1.0);
        } else {
            this.position(0.0);
        }
        this.playing = true;
        return this;
    }

    public Looper stop() {
        this.playing(false);
        return this;
    }

    public void reset() {
        this.table = null;
        this.in = 0.0;
        this.out = 1.0;
        this.speed = 1.0;
        this.looping = false;
        this.recording = false;
    }

    protected boolean isProcessRequired(long time) {
        return this.recording || super.isProcessRequired(time);
    }

    protected boolean isOutputRequired(Pipe source, long time) {
        return this.recording;
    }

    protected void process(List<Buffer> buffers) {
        block16: {
            block14: {
                int loopLength;
                block15: {
                    int i;
                    if (buffers.size() != this.channels.length) {
                        this.configureChannels(buffers.size());
                    }
                    if (this.table != null) {
                        this.iIn = (int)(this.in * (double)this.table.size());
                        this.iOut = (int)(this.out * (double)this.table.size());
                    } else {
                        this.iOut = 0;
                        this.iIn = 0;
                    }
                    loopLength = this.iOut - this.iIn;
                    if (!this.playing || loopLength <= 0) break block14;
                    if (this.recording) {
                        this.realSpeed = 1.0;
                        for (i = 0; i < this.channels.length; ++i) {
                            this.channels[i].processRecording(buffers.get(i), i % this.table.channels());
                        }
                    } else {
                        this.realSpeed = this.speed;
                        for (i = 0; i < this.channels.length; ++i) {
                            this.channels[i].processPlaying(buffers.get(i), i % this.table.channels(), true);
                        }
                    }
                    this.cursor += this.realSpeed * (double)buffers.get(0).getSize();
                    if (!(this.cursor > (double)this.iOut)) break block15;
                    if (this.looping) {
                        while (this.cursor > (double)this.iOut) {
                            this.cursor -= (double)loopLength;
                        }
                    } else {
                        this.cursor = this.iIn;
                        this.playing = false;
                    }
                    break block16;
                }
                if (!(this.cursor < (double)this.iIn)) break block16;
                if (this.looping) {
                    while (this.cursor < (double)this.iIn) {
                        this.cursor += (double)loopLength;
                    }
                } else {
                    this.cursor = this.iOut - 1;
                    this.playing = false;
                }
                break block16;
            }
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i].processStopped(buffers.get(i), 0, true);
            }
        }
    }

    protected void skip(int samples) {
        int loopLength = this.iOut - this.iIn;
        if (this.playing && loopLength > 0) {
            this.cursor += this.realSpeed * (double)samples;
            if (this.cursor > (double)this.iOut) {
                if (this.looping) {
                    while (this.cursor > (double)this.iOut) {
                        this.cursor -= (double)loopLength;
                    }
                } else {
                    this.cursor = this.iIn;
                    this.playing = false;
                }
            } else if (this.cursor < (double)this.iIn) {
                if (this.looping) {
                    while (this.cursor < (double)this.iIn) {
                        this.cursor += (double)loopLength;
                    }
                } else {
                    this.cursor = this.iOut - 1;
                    this.playing = false;
                }
            }
        }
    }

    private void configureChannels(int count) {
        Channel[] old = this.channels;
        this.channels = new Channel[count];
        int copy = Math.min(old.length, this.channels.length);
        if (copy > 0) {
            System.arraycopy(old, 0, this.channels, 0, copy);
        }
        for (int i = copy; i < this.channels.length; ++i) {
            this.channels[i] = new Channel();
        }
    }

    private void triggerSmoothing() {
        for (Channel c : this.channels) {
            c.smoothIndex = 256;
        }
    }

    private class Channel {
        private boolean wasRecording = false;
        private double previousSample = 0.0;
        private int smoothIndex = 0;

        private Channel() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processPlaying(Buffer buffer, int channel, boolean rendering) {
            if (this.wasRecording) {
                this.fadeFrom(channel, (int)Looper.this.cursor);
                this.fadeTo(channel, (int)(Looper.this.cursor + 0.5));
                this.smoothIndex = 0;
                this.wasRecording = false;
            }
            if (!rendering) {
                this.smoothIndex = 0;
                return;
            }
            int bSize = buffer.getSize();
            float[] data = buffer.getData();
            double p = Looper.this.cursor;
            int loopLength = Looper.this.iOut - Looper.this.iIn;
            if (loopLength <= 0 || Looper.this.table == null) {
                if (this.previousSample != 0.0) {
                    this.smoothIndex = 256;
                }
                this.processStopped(buffer, 0, rendering);
                return;
            }
            for (int i = 0; i < bSize; p += Looper.this.realSpeed, ++i) {
                if (p >= (double)Looper.this.iOut) {
                    this.smoothIndex = 256;
                    if (!Looper.this.looping) {
                        this.processStopped(buffer, i, rendering);
                        return;
                    }
                    while (p >= (double)Looper.this.iOut) {
                        p -= (double)loopLength;
                    }
                } else if (p < (double)Looper.this.iIn) {
                    this.smoothIndex = 256;
                    if (!Looper.this.looping) {
                        this.processStopped(buffer, i, rendering);
                        return;
                    }
                    while (p < (double)Looper.this.iIn) {
                        p += (double)loopLength;
                    }
                }
                double sample = Looper.this.table.get(channel, p);
                if (this.smoothIndex > 0) {
                    sample = this.smooth(sample);
                    --this.smoothIndex;
                }
                data[i] = (float)sample;
                this.previousSample = sample;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processRecording(Buffer buffer, int channel) {
            if (!this.wasRecording) {
                this.smoothIndex = 0;
            }
            int bSize = buffer.getSize();
            float[] data = buffer.getData();
            double p = Looper.this.cursor;
            int loopLength = Looper.this.iOut - Looper.this.iIn;
            if (loopLength <= 0 || Looper.this.table == null) {
                if (this.previousSample != 0.0) {
                    this.smoothIndex = 256;
                }
                this.processStopped(buffer, 0, true);
                return;
            }
            for (int i = 0; i < bSize; p += Looper.this.realSpeed, ++i) {
                if (p >= (double)Looper.this.iOut) {
                    this.smoothEnds(channel);
                    this.smoothIndex = 256;
                    if (!Looper.this.looping) {
                        this.processStopped(buffer, i, true);
                        return;
                    }
                    while (p >= (double)Looper.this.iOut) {
                        p -= (double)loopLength;
                    }
                } else if (p < (double)Looper.this.iIn) {
                    this.smoothEnds(channel);
                    this.smoothIndex = 256;
                    if (!Looper.this.looping) {
                        this.processStopped(buffer, i, true);
                        return;
                    }
                    while (p < (double)Looper.this.iIn) {
                        p += (double)loopLength;
                    }
                }
                double sample = data[i];
                Looper.this.table.set(channel, (int)p, sample);
                if (this.smoothIndex > 0) {
                    data[i] = (float)this.smooth(sample);
                    --this.smoothIndex;
                }
                this.previousSample = sample;
            }
        }

        private void processStopped(Buffer buffer, int offset, boolean rendering) {
            int i;
            if (!rendering) {
                this.smoothIndex = 0;
                return;
            }
            int bSize = buffer.getSize();
            float[] data = buffer.getData();
            if (this.smoothIndex > 0) {
                for (i = offset; i < bSize; ++i) {
                    double sample;
                    this.previousSample = sample = this.smooth(0.0);
                    data[i] = (float)sample;
                    --this.smoothIndex;
                    if (sample != 0.0 && this.smoothIndex != 0) continue;
                    this.smoothIndex = 0;
                    offset = i;
                    break;
                }
            }
            for (i = offset; i < bSize; ++i) {
                data[i] = 0.0f;
            }
        }

        private double smooth(double sample) {
            sample -= (sample - this.previousSample) * (double)this.smoothIndex / 256.0;
            return sample;
        }

        private void smoothEnds(int channel) {
            this.fadeFrom(channel, Looper.this.iIn);
            this.fadeTo(channel, Looper.this.iOut);
        }

        private void fadeTo(int channel, int idx) {
            if (idx < 256) {
                for (int i = 0; i < idx; ++i) {
                    Looper.this.table.set(0, i, 0.0);
                }
            } else {
                double mult = 1.0;
                double decrement = 0.00390625;
                for (int i = idx - 256; i < idx; ++i) {
                    Looper.this.table.set(channel, i, (mult -= decrement) * Looper.this.table.get(channel, i));
                }
            }
        }

        private void fadeFrom(int channel, int idx) {
            int size = Looper.this.table.size();
            if (idx + 256 > size) {
                for (int i = idx; i < size; ++i) {
                    Looper.this.table.set(0, i, 0.0);
                }
            } else {
                float mult = 0.0f;
                float increment = 0.00390625f;
                size = idx + 256;
                for (int i = idx; i < size; ++i) {
                    Looper.this.table.set(channel, i, (double)mult * Looper.this.table.get(channel, i));
                    mult += increment;
                }
            }
        }
    }
}

