/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import java.util.List;
import java.util.function.DoubleBinaryOperator;
import org.jaudiolibs.pipes.Buffer;
import org.jaudiolibs.pipes.Pipe;

public final class Mod
extends Pipe {
    private DoubleBinaryOperator function;

    public Mod() {
        super(32, 1);
    }

    public Mod function(DoubleBinaryOperator function) {
        this.function = function;
        return this;
    }

    protected void process(List<Buffer> buffers) {
        int sourceCount = this.getSourceCount();
        if (sourceCount < 2) {
            return;
        }
        float[] out = buffers.get(0).getData();
        int size = buffers.get(0).getSize();
        for (int i = 1; i < this.getSourceCount(); ++i) {
            int k;
            float[] in = buffers.get(i).getData();
            if (this.function == null) {
                for (k = 0; k < size; ++k) {
                    int n = k;
                    out[n] = out[n] * in[k];
                }
                continue;
            }
            for (k = 0; k < size; ++k) {
                out[k] = (float)this.function.applyAsDouble(in[k], out[k]);
            }
        }
    }

    protected void writeOutput(List<Buffer> inputs, Buffer output, int index) {
        super.writeOutput(inputs, output, 0);
    }

    public void reset() {
        this.function = null;
    }
}

