/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import java.util.Arrays;
import java.util.Objects;
import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.pipes.OpHolder;
import org.jaudiolibs.pipes.units.Waveform;

public final class Osc
extends OpHolder {
    private static final float DEFAULT_FREQUENCY = 440.0f;
    private final Op op;

    public Osc() {
        this(new Op());
    }

    Osc(Op op) {
        super((AudioOp)op, 1);
        this.op = op;
        this.reset();
    }

    public Osc frequency(double frequency) {
        this.op.setFrequency((float)frequency);
        return this;
    }

    public double frequency() {
        return this.op.getFrequency();
    }

    public Osc waveform(Waveform waveform) {
        this.op.setWaveform(Objects.requireNonNull(waveform));
        return this;
    }

    public Waveform waveform() {
        return this.op.getWaveform();
    }

    public Osc gain(double level) {
        this.op.setGain((float)level);
        return this;
    }

    public double gain() {
        return this.op.getGain();
    }

    public void reset() {
        this.op.setFrequency(440.0f);
        this.op.setWaveform(Waveform.Sine);
        this.op.setGain(1.0f);
    }

    private static class Op
    implements AudioOp {
        private static final float TWOPI = (float)Math.PI * 2;
        private float phase;
        private float phaseIncrement;
        private float freq = 440.0f;
        private float srate;
        private float gain = 1.0f;
        private float oldGain;
        private Waveform wave = Waveform.Sine;

        private Op() {
        }

        public void setGain(float gain) {
            this.gain = gain;
        }

        public float getGain() {
            return this.gain;
        }

        public void setFrequency(float frequency) {
            this.freq = frequency;
            this.updateIncrement();
        }

        public float getFrequency() {
            return this.freq;
        }

        public void setWaveform(Waveform mode) {
            this.wave = mode;
        }

        public Waveform getWaveform() {
            return this.wave;
        }

        public void initialize(float samplerate, int buffersize) {
            this.srate = samplerate;
            this.phase = 0.0f;
            this.updateIncrement();
        }

        public void reset(int i) {
            this.phase = 0.0f;
        }

        public boolean isInputRequired(boolean bln) {
            return false;
        }

        public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
            float g2;
            float[] out = outputs[0];
            float g1 = this.oldGain;
            float f = g2 = this.freq > 1.0f ? this.gain : 0.0f;
            if (g1 != 0.0f || g2 != 0.0f) {
                float delta = (g2 - g1) / (float)buffersize;
                for (int i = 0; i < buffersize; ++i) {
                    out[i] = g1 * this.nextSample();
                    g1 += delta;
                }
            } else {
                Arrays.fill(out, 0.0f);
                this.phase += this.phaseIncrement * (float)buffersize;
                while (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
            }
            this.oldGain = g2;
        }

        public void processAdd(int buffersize, float[][] outputs, float[][] inputs) {
            float g2;
            float[] out = outputs[0];
            float g1 = this.oldGain;
            float f = g2 = this.freq > 1.0f ? this.gain : 0.0f;
            if (g1 != 0.0f || g2 != 0.0f) {
                float delta = (g2 - g1) / (float)buffersize;
                int i = 0;
                while (i < buffersize) {
                    int n = i++;
                    out[n] = out[n] + g1 * this.nextSample();
                    g1 += delta;
                }
            } else {
                this.phase += this.phaseIncrement * (float)buffersize;
                while (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
            }
            this.oldGain = g2;
        }

        private void updateIncrement() {
            float inc = 0.0f;
            if (this.srate > 0.0f && (inc = (float)Math.PI * 2 * this.freq / this.srate) < 0.0f) {
                inc = 0.0f;
            }
            this.phaseIncrement = inc;
        }

        private float nextSample() {
            float value = 0.0f;
            float t = this.phase / ((float)Math.PI * 2);
            switch (this.wave) {
                case Sine: {
                    value = (float)Math.sin(this.phase);
                    break;
                }
                case Saw: {
                    value = 2.0f * t - 1.0f;
                    value -= this.polyBLEP(t);
                    break;
                }
                case Square: {
                    value = (double)this.phase < Math.PI ? 1.0f : -1.0f;
                    value += this.polyBLEP(t);
                    value -= this.polyBLEP((t + 0.5f) % 1.0f);
                }
            }
            this.phase += this.phaseIncrement;
            while (this.phase >= (float)Math.PI * 2) {
                this.phase -= (float)Math.PI * 2;
            }
            return value;
        }

        private float polyBLEP(float t) {
            float dt = this.phaseIncrement / ((float)Math.PI * 2);
            if (t < dt) {
                return (t /= dt) + t - t * t - 1.0f;
            }
            if (t > 1.0f - dt) {
                t = (t - 1.0f) / dt;
                return t * t + t + t + 1.0f;
            }
            return 0.0f;
        }
    }
}

