/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.pipes.OpHolder;

public final class Overdrive
extends OpHolder {
    private final Op op;

    public Overdrive() {
        this(new Op());
    }

    private Overdrive(Op op) {
        super((AudioOp)op, 1);
        this.op = op;
        this.reset();
    }

    public Overdrive drive(double amt) {
        this.op.setDrive(amt);
        return this;
    }

    public double drive() {
        return this.op.getDrive();
    }

    public void reset() {
        this.op.setDrive(0.0);
    }

    private static class Op
    implements AudioOp {
        private double drive;

        private Op() {
        }

        public void processReplace(int bufferSize, float[][] outputs, float[][] inputs) {
            float[] in = inputs[0];
            float[] out = outputs[0];
            double preMul = this.drive * 99.0 + 1.0;
            double postMul = 1.0 / (Math.log(preMul * 2.0) / Math.log(2.0));
            for (int i = 0; i < bufferSize; ++i) {
                out[i] = (float)(Math.atan((double)in[i] * preMul) * postMul);
            }
        }

        public void processAdd(int bufferSize, float[][] outputs, float[][] inputs) {
            float[] in = inputs[0];
            float[] out = outputs[0];
            double preMul = this.drive * 99.0 + 1.0;
            double postMul = 1.0 / (Math.log(preMul * 2.0) / Math.log(2.0));
            for (int i = 0; i < bufferSize; ++i) {
                int n = i;
                out[n] = out[n] + (float)(Math.atan((double)in[i] * preMul) * postMul);
            }
        }

        public void setDrive(double drive) {
            this.drive = drive < 0.0 ? 0.0 : (drive > 1.0 ? 1.0 : drive);
        }

        public double getDrive() {
            return this.drive;
        }

        public void initialize(float sampleRate, int maxBufferSize) {
        }

        public void reset(int skipped) {
        }

        public boolean isInputRequired(boolean outputRequired) {
            return outputRequired;
        }
    }
}

