/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import org.jaudiolibs.audioops.AudioOp;
import org.jaudiolibs.pipes.OpHolder;

public final class Phasor
extends OpHolder {
    private static final float DEFAULT_FREQUENCY = 1.0f;
    private final Op op;

    public Phasor() {
        this(new Op());
    }

    private Phasor(Op op) {
        super((AudioOp)op, 1);
        this.op = op;
        this.reset();
    }

    public Phasor frequency(double frequency) {
        this.op.setFrequency((float)frequency);
        return this;
    }

    public double frequency() {
        return this.op.getFrequency();
    }

    public Phasor minimum(double minimum) {
        this.op.setMinimum((float)minimum);
        return this;
    }

    public double minimum() {
        return this.op.getMinimum();
    }

    public Phasor maximum(double maximum) {
        this.op.setMaximum((float)maximum);
        return this;
    }

    public double maximum() {
        return this.op.getMaximum();
    }

    public Phasor phase(double phase) {
        this.op.setPhase((float)phase);
        return this;
    }

    public double phase() {
        return this.op.getPhase();
    }

    public void reset() {
        this.op.setFrequency(1.0f);
        this.op.setMinimum(0.0f);
        this.op.setMaximum(1.0f);
    }

    private static class Op
    implements AudioOp {
        private static final float TWOPI = (float)Math.PI * 2;
        private float phase;
        private float phaseIncrement;
        private float freq = 1.0f;
        private float srate;
        private float minimum = 0.0f;
        private float maximum = 1.0f;

        private Op() {
        }

        public void setFrequency(float frequency) {
            this.freq = frequency;
            this.updateIncrement();
        }

        public float getFrequency() {
            return this.freq;
        }

        public void setMinimum(float minimum) {
            this.minimum = minimum;
        }

        public float getMinimum() {
            return this.minimum;
        }

        public void setMaximum(float maximum) {
            this.maximum = maximum;
        }

        public float getMaximum() {
            return this.maximum;
        }

        public void setPhase(float phase) {
            this.phase = Math.abs(phase) % ((float)Math.PI * 2);
        }

        public float getPhase() {
            return this.phase;
        }

        public void initialize(float samplerate, int buffersize) {
            this.srate = samplerate;
            this.phase = 0.0f;
            this.updateIncrement();
        }

        public void reset(int i) {
            this.phase = 0.0f;
        }

        public boolean isInputRequired(boolean bln) {
            return false;
        }

        public void processReplace(int buffersize, float[][] outputs, float[][] inputs) {
            float[] out = outputs[0];
            for (int i = 0; i < buffersize; ++i) {
                out[i] = this.nextSample();
            }
        }

        public void processAdd(int buffersize, float[][] outputs, float[][] inputs) {
            float[] out = outputs[0];
            int i = 0;
            while (i < buffersize) {
                int n = i++;
                out[n] = out[n] + this.nextSample();
            }
        }

        private void updateIncrement() {
            float inc = 0.0f;
            if (this.srate > 0.0f && (inc = (float)Math.PI * 2 * this.freq / this.srate) < 0.0f) {
                inc = 0.0f;
            }
            this.phaseIncrement = inc;
        }

        private float nextSample() {
            float value = this.phase / ((float)Math.PI * 2) * (this.maximum - this.minimum) + this.minimum;
            this.phase += this.phaseIncrement;
            while (this.phase >= (float)Math.PI * 2) {
                this.phase -= (float)Math.PI * 2;
            }
            return value;
        }
    }
}

